/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.database.agent;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;
import org.thexeler.freeepicgames.FreeEpicGamesConfigs;
import org.thexeler.freeepicgames.database.agent.AbstractDataAgent;
import org.thexeler.freeepicgames.database.type.JobType;
import org.thexeler.freeepicgames.database.untils.DataUtils;
import org.thexeler.freeepicgames.database.untils.ModSavedData;

public class GlobalJobDataAgent
extends AbstractDataAgent {
    private static GlobalJobDataAgent instance;
    private final JsonObject playerData;
    private final Map<String, String> playerJobMap = Collections.synchronizedMap(new HashMap());

    private GlobalJobDataAgent() {
        this.playerData = FreeEpicGamesConfigs.isEnabledJobCachePersistence ? ModSavedData.getGlobalData("JobsCache") : new JsonObject();
        this.load();
    }

    public static GlobalJobDataAgent getInstance() {
        if (instance == null) {
            instance = new GlobalJobDataAgent();
        }
        return instance;
    }

    public Collection<String> getAllPlayerJob() {
        return this.playerJobMap.values();
    }

    public boolean setPlayerJob(ServerPlayer player, String jobName) {
        if (JobType.getType(jobName) != null) {
            this.playerJobMap.put(player.getStringUUID(), jobName);
            return true;
        }
        return false;
    }

    @Nullable
    public String getPlayerJob(ServerPlayer player) {
        return this.playerJobMap.get(player.getStringUUID());
    }

    @Override
    public void load() {
        if (FreeEpicGamesConfigs.isEnabledJobCachePersistence) {
            this.playerData.asMap().forEach((key, value) -> this.playerJobMap.put((String)key, value.getAsString()));
        }
    }

    @Override
    public void save() {
        if (FreeEpicGamesConfigs.isEnabledJobCachePersistence) {
            DataUtils.clearDeprecatedKey(this.playerData, this.playerJobMap);
            this.playerJobMap.forEach((arg_0, arg_1) -> ((JsonObject)this.playerData).addProperty(arg_0, arg_1));
        }
    }

    public static void expire() {
        instance = null;
    }
}

