/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.database.agent;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;
import org.thexeler.freeepicgames.FreeEpicGames;
import org.thexeler.freeepicgames.database.agent.AbstractDataAgent;
import org.thexeler.freeepicgames.database.type.NpcType;
import org.thexeler.freeepicgames.database.untils.DataUtils;
import org.thexeler.freeepicgames.database.untils.ModSavedData;
import org.thexeler.freeepicgames.database.view.NpcView;
import org.thexeler.freeepicgames.events.NpcEvent;

public class WorldNpcDataAgent
extends AbstractDataAgent {
    private static final Map<ServerLevel, WorldNpcDataAgent> instances = new HashMap<ServerLevel, WorldNpcDataAgent>();
    private final ServerLevel world;
    private final JsonObject optionData;
    private final JsonObject npcData;
    private final Map<String, NpcView> npcViewMap = Collections.synchronizedMap(new HashMap());

    private WorldNpcDataAgent(ServerLevel world) {
        this.world = world;
        this.optionData = ModSavedData.getWorldData((Level)world, "NPCSettings");
        this.npcData = ModSavedData.getWorldData((Level)world, "NPCData");
        this.load();
    }

    public static WorldNpcDataAgent getInstance(ServerLevel world) {
        return instances.computeIfAbsent(world, WorldNpcDataAgent::new);
    }

    public Collection<NpcView> getAllNpc() {
        return this.npcViewMap.values();
    }

    public NpcView createNpc(NpcType type) {
        return this.createNpc(type, null);
    }

    public NpcView createNpc(NpcType type, Entity origin) {
        NpcView view = null;
        if (origin == null) {
            origin = type.getEntityType().create((Level)this.world);
        }
        if (origin != null) {
            if (this.npcData.get(origin.getStringUUID()) == null) {
                view = new NpcView(origin, type, this);
                origin.setInvulnerable(type.isInvulnerable());
                origin.setInvisible(type.isInvisible());
                origin.setNoGravity(type.isNoGravity());
                if (type.isNoAI()) {
                    if (origin instanceof Mob) {
                        Mob mob = (Mob)origin;
                        mob.setNoAi(true);
                    }
                    origin.getPersistentData().putBoolean("NoAI", true);
                }
                NeoForge.EVENT_BUS.post((Event)new NpcEvent.CreateEvent(view));
                this.world.addFreshEntity(origin);
                NeoForge.EVENT_BUS.post((Event)new NpcEvent.JoinEvent(view, this.world));
                this.npcViewMap.put(view.getId(), view);
            } else {
                FreeEpicGames.LOGGER.error("NpcEntity {} already exists", (Object)origin.getStringUUID());
            }
        } else {
            FreeEpicGames.LOGGER.error("Entity type {} not found", type.getEntityType());
        }
        return view;
    }

    public boolean deleteNpc(String id) {
        if (this.npcViewMap.get(id) != null) {
            this.npcViewMap.remove(id);
            return true;
        }
        return false;
    }

    @Nullable
    public NpcView getNpcView(String id) {
        return this.npcViewMap.get(id);
    }

    @Override
    public void load() {
        this.npcData.keySet().forEach(id -> {
            NpcView view = new NpcView(this.npcData.getAsJsonObject(id), this);
            if (view.getOriginEntity() == null) {
                this.npcViewMap.put((String)id, view);
            }
        });
    }

    @Override
    public void save() {
        DataUtils.computeViewMap(this.npcViewMap, this.npcData);
    }

    public static void expire() {
        instances.clear();
    }

    public ServerLevel getWorld() {
        return this.world;
    }
}

