/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.mind;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.world.entity.Entity;
import org.thexeler.mind.intention.Intention;
import org.thexeler.mind.intention.IntentionPriority;
import org.thexeler.mind.intention.IntentionType;

public class MindMachine {
    private Entity origin;
    private final List<Intention> intentions = Collections.synchronizedList(new LinkedList());

    public void addIntention(Intention intention) {
        if (intention.getPriority() == IntentionPriority.URGENT) {
            this.intentions.addFirst(intention);
        } else {
            ListIterator<Intention> i = this.intentions.listIterator();
            while (i.hasNext()) {
                Intention current = i.next();
                if (intention.getPriority().biggerThan(current.getPriority())) continue;
                i.previous();
                i.add(intention);
                return;
            }
            this.intentions.add(intention);
        }
    }

    public void step() {
        Intention intention = this.intentions.getFirst();
        if (intention != null) {
            if (intention.getType() != IntentionType.IDLE) {
                if (intention.execute() && intention.getType() != IntentionType.IDLE) {
                    this.intentions.removeFirst();
                }
                this.intentions.forEach(i -> {
                    if (i != intention) {
                        i.hold();
                    }
                });
                this.intentions.sort((i1, i2) -> i2.getPriority().compareTo(i1.getPriority()));
            }
        } else {
            this.intentions.add(new Intention.SimpleIntention(this, this.origin, IntentionType.IDLE, IntentionPriority.LOWEST){

                @Override
                public boolean execute() {
                    return false;
                }
            });
        }
    }

    public Entity getOrigin() {
        return this.origin;
    }
}

