/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Random;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import org.thexeler.freeepicgames.command.lamp.actor.ForgeCommandActor;
import org.thexeler.freeepicgames.command.lamp.annotations.RequiresOP;
import org.thexeler.freeepicgames.command.lamp.annotations.WithAreas;
import org.thexeler.freeepicgames.command.lamp.annotations.WithTargetLocation;
import org.thexeler.freeepicgames.command.lamp.annotations.WithTargetLocationYZ;
import org.thexeler.freeepicgames.command.lamp.annotations.WithTargetLocationZ;
import org.thexeler.freeepicgames.command.lamp.annotations.WithTeam;
import org.thexeler.freeepicgames.command.lamp.parameters.EntitySelectorList;
import org.thexeler.freeepicgames.database.agent.WorldCaptureDataAgent;
import org.thexeler.freeepicgames.database.untils.LogicTeam;
import org.thexeler.freeepicgames.database.view.AreaView;
import revxrsal.commands.annotation.Command;
import revxrsal.commands.annotation.CommandPlaceholder;
import revxrsal.commands.annotation.Subcommand;

@Command(value={"fegcapture"})
public class ModelCaptureCommand {
    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"area create <area> <x1> <y1> <z1> <x2> <y2> <z2>"})
    public void areaCreate(ForgeCommandActor sender, String area, @WithTargetLocation double x1, @WithTargetLocationYZ double y1, @WithTargetLocationZ double z1, @WithTargetLocation double x2, @WithTargetLocationYZ double y2, @WithTargetLocationZ double z2) {
        WorldCaptureDataAgent agent = WorldCaptureDataAgent.getInstance(sender.getLevel());
        if (agent.createArea(area, x1, y1, z1, x2, y2, z2)) {
            sender.reply("\u6210\u529f\u521b\u5efa\u533a\u57df" + area);
        } else {
            sender.reply("\u521b\u5efa\u5931\u8d25:\u5df2\u5b58\u5728\u7684\u533a\u57df:" + area);
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"area delete <area>"})
    public void areaDelete(ForgeCommandActor sender, @WithAreas String area) {
        WorldCaptureDataAgent agent = WorldCaptureDataAgent.getInstance(sender.getLevel());
        if (agent.deleteArea(area)) {
            sender.reply("\u6210\u529f\u5220\u9664\u533a\u57df" + area);
        } else {
            sender.reply("\u5220\u9664\u5931\u8d25:\u4e0d\u5b58\u5728\u7684\u533a\u57df:" + area);
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"area set <area> LockWhenAttackerCapture <areas>"})
    public void areaSetLockWhenAttackerCapture(ForgeCommandActor sender, @WithAreas String area, @WithAreas String[] areas) {
        WorldCaptureDataAgent agent = WorldCaptureDataAgent.getInstance(sender.getLevel());
        AreaView view = agent.getAreaView(area);
        if (view != null) {
            view.setLockWhenAttackerCapture(Arrays.asList(areas));
            sender.reply("\u8bbe\u7f6e\u6210\u529f");
        } else {
            sender.reply("\u8bbe\u7f6e\u5931\u8d25:\u4e0d\u5b58\u5728\u7684\u533a\u57df" + area);
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"area set <area> UnlockWhenAttackerCapture <areas>"})
    public void areaSetUnlockWhenAttackerCapture(ForgeCommandActor sender, @WithAreas String area, @WithAreas String[] areas) {
        WorldCaptureDataAgent agent = WorldCaptureDataAgent.getInstance(sender.getLevel());
        AreaView view = agent.getAreaView(area);
        if (view != null) {
            view.setUnlockWhenAttackerCapture(Arrays.asList(areas));
            sender.reply("\u8bbe\u7f6e\u6210\u529f");
        } else {
            sender.reply("\u8bbe\u7f6e\u5931\u8d25:\u4e0d\u5b58\u5728\u7684\u533a\u57df" + area);
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"area set <area> LockWhenDefenderCapture <areas>"})
    public void areaSetLockWhenDefenderCapture(ForgeCommandActor sender, @WithAreas String area, @WithAreas String[] areas) {
        WorldCaptureDataAgent agent = WorldCaptureDataAgent.getInstance(sender.getLevel());
        AreaView view = agent.getAreaView(area);
        if (view != null) {
            view.setLockWhenDefenderCapture(Arrays.asList(areas));
            sender.reply("\u8bbe\u7f6e\u6210\u529f");
        } else {
            sender.reply("\u8bbe\u7f6e\u5931\u8d25:\u4e0d\u5b58\u5728\u7684\u533a\u57df" + area);
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"area set <area> UnlockWhenDefenderCapture <areas>"})
    public void areaSetUnlockWhenDefenderCapture(ForgeCommandActor sender, @WithAreas String area, @WithAreas String[] areas) {
        WorldCaptureDataAgent agent = WorldCaptureDataAgent.getInstance(sender.getLevel());
        AreaView view = agent.getAreaView(area);
        if (view != null) {
            view.setUnlockWhenDefenderCapture(Arrays.asList(areas));
            sender.reply("\u8bbe\u7f6e\u6210\u529f");
        } else {
            sender.reply("\u8bbe\u7f6e\u5931\u8d25:\u4e0d\u5b58\u5728\u7684\u533a\u57df" + area);
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"area set <area> ExportSchedule <bool>"})
    public void areaSetExportSchedule(ForgeCommandActor sender, @WithAreas String area, boolean bool) {
        WorldCaptureDataAgent agent = WorldCaptureDataAgent.getInstance(sender.getLevel());
        AreaView view = agent.getAreaView(area);
        if (view != null) {
            view.setExportSchedule(bool);
            sender.reply("\u8bbe\u7f6e\u6210\u529f");
        } else {
            sender.reply("\u8bbe\u7f6e\u5931\u8d25:\u4e0d\u5b58\u5728\u7684\u533a\u57df:" + area);
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"area set <area> ScheduleFormatExport <bool>"})
    public void areaSetScheduleFormatExport(ForgeCommandActor sender, @WithAreas String area, boolean bool) {
        WorldCaptureDataAgent agent = WorldCaptureDataAgent.getInstance(sender.getLevel());
        AreaView view = agent.getAreaView(area);
        if (view != null) {
            view.setExportScheduleFormat(bool);
            sender.reply("\u8bbe\u7f6e\u6210\u529f");
        } else {
            sender.reply("\u8bbe\u7f6e\u5931\u8d25:\u4e0d\u5b58\u5728\u7684\u533a\u57df:" + area);
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"area list"})
    public void areaList(ForgeCommandActor sender) {
        WorldCaptureDataAgent agent = WorldCaptureDataAgent.getInstance(sender.getLevel());
        Collection<AreaView> areaList = agent.getAllAreas();
        StringBuilder message = new StringBuilder("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u5171\u8ba1" + areaList.size() + "\u4e2a\u533a\u57df\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\n");
        areaList.forEach(value -> {
            ServerScoreboard board = sender.getLevel().getScoreboard();
            double schedule = value.getSchedule();
            LogicTeam controllerTeam = value.getController();
            String controller = "\u4e2d\u7acb";
            if (controllerTeam != LogicTeam.NEUTRAL) {
                controller = Objects.requireNonNull(board.getPlayerTeam(controllerTeam == LogicTeam.ATTACKER ? agent.getAttacker() : agent.getDefender())).getDisplayName().getString();
            }
            message.append("\u540d\u79f0:").append(value.getName()).append("  \u5360\u9886\u8fdb\u5ea6:").append(Math.abs(schedule)).append("%  \u63a7\u5236\u8005:").append(controller).append("  \u662f\u5426\u5df2\u9501\u5b9a:").append(value.isLocked()).append("\n");
        });
        message.append("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014");
        sender.reply(message.toString());
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"area lock <area>"})
    public void areaLock(ForgeCommandActor sender, @WithAreas String area) {
        WorldCaptureDataAgent agent = WorldCaptureDataAgent.getInstance(sender.getLevel());
        AreaView view = agent.getAreaView(area);
        if (view != null) {
            view.setLocked(true);
            sender.reply("\u533a\u57df" + area + "\u5df2\u9501\u5b9a");
        } else {
            sender.reply("\u64cd\u4f5c\u5931\u8d25:\u4e0d\u5b58\u5728\u7684\u533a\u57df" + area);
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"area unlock <area>"})
    public void areaUnlock(ForgeCommandActor sender, @WithAreas String area) {
        WorldCaptureDataAgent agent = WorldCaptureDataAgent.getInstance(sender.getLevel());
        AreaView view = agent.getAreaView(area);
        if (view != null) {
            view.setLocked(false);
            sender.reply("\u533a\u57df" + area + "\u5df2\u89e3\u9501");
        } else {
            sender.reply("\u64cd\u4f5c\u5931\u8d25:\u4e0d\u5b58\u5728\u7684\u533a\u57df" + area);
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"area teleport <area>"})
    public void areaTeleport(ForgeCommandActor sender, @WithAreas String area) {
        WorldCaptureDataAgent agent = WorldCaptureDataAgent.getInstance(sender.getLevel());
        AreaView view = agent.getAreaView(area);
        ServerPlayer player = sender.requirePlayer();
        if (player != null) {
            if (view != null) {
                Random random = new Random();
                double maxX = view.getEnd().x - view.getPos().x;
                double maxZ = view.getEnd().z - view.getPos().z;
                player.teleportTo(view.getPos().x + random.nextDouble() % maxX, view.getPos().y + 1.0, view.getPos().z + random.nextDouble() % maxZ);
                sender.reply("\u4f20\u9001\u6210\u529f");
            } else {
                sender.reply("\u4f20\u9001\u5931\u8d25:\u4e0d\u5b58\u5728\u7684\u533a\u57df" + area);
            }
        } else {
            sender.reply("\u4f20\u9001\u5931\u8d25:\u8be5\u6307\u4ee4\u4ec5\u9650\u73a9\u5bb6\u4f7f\u7528");
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"area teleport <area> <player>"})
    public void areaTeleport(ForgeCommandActor sender, @WithAreas String area, ServerPlayer player) {
        WorldCaptureDataAgent agent = WorldCaptureDataAgent.getInstance(sender.getLevel());
        AreaView view = agent.getAreaView(area);
        if (view != null) {
            Random random = new Random();
            double maxX = view.getEnd().x - view.getPos().x;
            double maxZ = view.getEnd().z - view.getPos().z;
            player.setPos(new Vec3(view.getPos().x + random.nextDouble() % maxX, view.getPos().y + 1.0, view.getPos().z + random.nextDouble() % maxZ));
            sender.reply("\u4f20\u9001\u6210\u529f");
        } else {
            sender.reply("\u4f20\u9001\u5931\u8d25:\u4e0d\u5b58\u5728\u7684\u533a\u57df" + area);
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"area teleport <area> <selector>"})
    public void areaTeleport(ForgeCommandActor sender, @WithAreas String area, EntitySelectorList<ServerPlayer> selector) {
        WorldCaptureDataAgent agent = WorldCaptureDataAgent.getInstance(sender.getLevel());
        AreaView view = agent.getAreaView(area);
        if (view != null) {
            Random random = new Random();
            selector.stream().filter(entity -> entity instanceof ServerPlayer).forEach(player -> {
                double maxX = view.getEnd().x - view.getPos().x;
                double maxZ = view.getEnd().z - view.getPos().z;
                player.setPos(view.getPos().x + random.nextDouble() % maxX, view.getPos().y + 1.0, view.getPos().z + random.nextDouble() % maxZ);
            });
            sender.reply("\u4f20\u9001\u6210\u529f");
        } else {
            sender.reply("\u4f20\u9001\u5931\u8d25:\u4e0d\u5b58\u5728\u7684\u533a\u57df" + area);
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"set Rate <rate>"})
    public void setRate(ForgeCommandActor sender, float rate) {
        WorldCaptureDataAgent agent = WorldCaptureDataAgent.getInstance(sender.getLevel());
        agent.setRate(rate);
        sender.reply("\u8bbe\u7f6e\u6210\u529f");
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"set OutputObjectiveName <object>"})
    public void setOutputObjectiveName(ForgeCommandActor sender, String object) {
        WorldCaptureDataAgent agent = WorldCaptureDataAgent.getInstance(sender.getLevel());
        agent.setExportObjectiveName(object);
        sender.reply("\u8bbe\u7f6e\u6210\u529f");
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"set team Attacker <team>"})
    public void setTeamAttacker(ForgeCommandActor sender, @WithTeam String team) {
        WorldCaptureDataAgent agent = WorldCaptureDataAgent.getInstance(sender.getLevel());
        if (sender.getLevel().getScoreboard().getPlayerTeam(team) != null) {
            agent.setAttacker(team);
            sender.reply("\u6210\u529f\u8bbe\u7f6e\u8fdb\u653b\u65b9\u4e3a\u961f\u4f0d" + team);
        } else {
            sender.reply("\u8bbe\u7f6e\u5931\u8d25:\u4e0d\u5b58\u5728\u7684\u961f\u4f0d\u540d" + team);
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"set team Defender <team>"})
    public void setTeamDefender(ForgeCommandActor sender, @WithTeam String team) {
        WorldCaptureDataAgent agent = WorldCaptureDataAgent.getInstance(sender.getLevel());
        if (sender.getLevel().getScoreboard().getTeamNames().contains(team)) {
            agent.setDefender(team);
            sender.reply("\u6210\u529f\u8bbe\u7f6e\u9632\u5b88\u65b9\u4e3a\u961f\u4f0d" + team);
        } else {
            sender.reply("\u8bbe\u7f6e\u5931\u8d25:\u4e0d\u5b58\u5728\u7684\u961f\u4f0d\u540d" + team);
        }
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"set team AttackerCommander <player>"})
    public void setTeamAttackerCommander(ForgeCommandActor sender, ServerPlayer player) {
        WorldCaptureDataAgent agent = WorldCaptureDataAgent.getInstance(sender.getLevel());
        agent.setAttackerCommander(player.getStringUUID());
        sender.reply("\u6210\u529f\u8bbe\u7f6e\u8fdb\u653b\u65b9\u6307\u6325\u5b98\u4e3a" + player.getDisplayName().getString());
    }

    @CommandPlaceholder
    @RequiresOP
    @Subcommand(value={"set team DefenderCommander <player>"})
    public void setTeamDefenderCommander(ForgeCommandActor sender, ServerPlayer player) {
        WorldCaptureDataAgent agent = WorldCaptureDataAgent.getInstance(sender.getLevel());
        agent.setDefenderCommander(player.getStringUUID());
        sender.reply("\u6210\u529f\u8bbe\u7f6e\u9632\u5b88\u65b9\u6307\u6325\u5b98\u4e3a {}" + player.getDisplayName().getString());
    }
}

