/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.command.lamp.actor;

import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.Lamp;
import revxrsal.commands.command.CommandActor;

public record ForgeCommandActor(CommandSourceStack source, Lamp<?> lamp) implements CommandActor
{
    @Override
    @NotNull
    public String name() {
        return this.source.getTextName();
    }

    @Override
    @NotNull
    public UUID uniqueId() {
        if (this.source.getEntity() != null) {
            return this.source.getEntity().getUUID();
        }
        return UUID.nameUUIDFromBytes(this.name().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void reply(@NotNull String message) {
        this.reply((Component)Component.literal((String)message));
    }

    public void reply(@NotNull Component message) {
        this.source.sendSystemMessage(message);
    }

    @Override
    public void sendRawMessage(@NotNull String message) {
        this.source.sendSystemMessage((Component)Component.literal((String)message));
    }

    @Override
    public void sendRawError(@NotNull String message) {
        this.source.sendSystemMessage((Component)Component.literal((String)message).withStyle(ChatFormatting.RED));
    }

    @Nullable
    public ServerPlayer requirePlayer() {
        return this.source.getPlayer();
    }

    public ServerLevel getLevel() {
        if (this.source.getPlayer() != null) {
            return this.source.getPlayer().serverLevel();
        }
        return this.source.getServer().overworld();
    }
}

