/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.database.agent;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.Nullable;
import org.thexeler.freeepicgames.FreeEpicGamesConfigs;
import org.thexeler.freeepicgames.database.agent.AbstractDataAgent;
import org.thexeler.freeepicgames.database.type.RaidType;
import org.thexeler.freeepicgames.database.untils.DataUtils;
import org.thexeler.freeepicgames.database.untils.ModSavedData;
import org.thexeler.freeepicgames.database.view.RaidInstanceView;

public class GlobalRaidDataAgent
implements AbstractDataAgent {
    private static GlobalRaidDataAgent instance;
    private final JsonObject optionData;
    private final JsonObject raidInstanceData;
    private final Map<String, RaidInstanceView> raidInstances = Collections.synchronizedMap(new HashMap());

    private GlobalRaidDataAgent() {
        this.optionData = ModSavedData.getGlobalData("RaidSettings");
        this.raidInstanceData = FreeEpicGamesConfigs.isEnabledRaidCachePersistence ? ModSavedData.getGlobalData("RaidsInstanceCache") : new JsonObject();
        this.load();
    }

    public static GlobalRaidDataAgent getInstance() {
        if (instance == null) {
            instance = new GlobalRaidDataAgent();
        }
        return instance;
    }

    @Nullable
    public RaidInstanceView createRaidInstance(RaidType type) {
        RaidInstanceView raidInstanceView = null;
        if (type != null) {
            String uuid = UUID.randomUUID().toString();
            raidInstanceView = new RaidInstanceView(uuid, type, this.locateEmptyChunk(type));
            raidInstanceView.build();
            this.raidInstances.put(uuid, raidInstanceView);
        }
        return raidInstanceView;
    }

    public ChunkPos locateEmptyChunk(RaidType type) {
        int level = 0;
        int sizeX = type.getSize().getX();
        int sizeZ = type.getSize().getZ();
        while (true) {
            int negationZ;
            int negationX;
            int posX;
            int posZ = level;
            for (posX = 0; posX < level; ++posX) {
                negationX = posX * -1;
                negationZ = posZ * -1;
                if (DataUtils.isChunkEmpty(posX, posZ) && DataUtils.isChunkEmpty(posX + sizeX, posZ + sizeZ)) {
                    return new ChunkPos(posX, posZ);
                }
                if (DataUtils.isChunkEmpty(posX, negationZ) && DataUtils.isChunkEmpty(posX + sizeX, negationZ + sizeZ)) {
                    return new ChunkPos(posX, negationZ);
                }
                if (DataUtils.isChunkEmpty(negationX, posZ) && DataUtils.isChunkEmpty(negationX + sizeX, posZ + sizeZ)) {
                    return new ChunkPos(negationX, posZ);
                }
                if (!DataUtils.isChunkEmpty(negationX, negationZ) || !DataUtils.isChunkEmpty(negationX + sizeX, negationZ + sizeZ)) continue;
                return new ChunkPos(negationX, negationZ);
            }
            for (posZ = 0; posZ < level - 1; ++posZ) {
                negationX = posX * -1;
                negationZ = posZ * -1;
                if (DataUtils.isChunkEmpty(posX, posZ) && DataUtils.isChunkEmpty(posX + sizeX, posZ + sizeZ)) {
                    return new ChunkPos(posX, posZ);
                }
                if (DataUtils.isChunkEmpty(posX, negationZ) && DataUtils.isChunkEmpty(posX + sizeX, negationZ + sizeZ)) {
                    return new ChunkPos(posX, negationZ);
                }
                if (DataUtils.isChunkEmpty(negationX, posZ) && DataUtils.isChunkEmpty(negationX + sizeX, posZ + sizeZ)) {
                    return new ChunkPos(negationX, posZ);
                }
                if (!DataUtils.isChunkEmpty(negationX, negationZ) || !DataUtils.isChunkEmpty(negationX + sizeX, negationZ + sizeZ)) continue;
                return new ChunkPos(negationX, negationZ);
            }
            ++level;
        }
    }

    public Collection<RaidInstanceView> getAllRaidInstance() {
        return this.raidInstances.values();
    }

    @Nullable
    public RaidInstanceView getRaidInstance(ServerPlayer player) {
        return RaidInstanceView.getRaidInstanceFromPlayer((Player)player);
    }

    @Nullable
    public RaidInstanceView getRaidInstance(String name) {
        return this.raidInstances.get(name);
    }

    @Override
    public void load() {
        if (FreeEpicGamesConfigs.isEnabledRaidCachePersistence) {
            this.raidInstanceData.asMap().forEach((key, value) -> this.raidInstances.put((String)key, new RaidInstanceView(value.getAsJsonObject())));
        }
    }

    @Override
    public void save() {
        if (FreeEpicGamesConfigs.isEnabledRaidCachePersistence) {
            DataUtils.computeCacheViewMap(this.raidInstances, this.raidInstanceData);
        }
    }
}

