/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.database.type;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import org.thexeler.freeepicgames.database.type.NpcType;

public class NpcEntity<T extends Entity> {
    public static final Map<UUID, NpcEntity<?>> entities = new HashMap();
    private final NpcType entityType;
    private final T originEntity;

    public NpcEntity(NpcType type, T origin) {
        entities.put(origin.getUUID(), this);
        this.entityType = type;
        this.originEntity = origin;
    }

    public void discard() {
        entities.remove(this.originEntity.getUUID());
        this.originEntity.discard();
    }

    public static void discardAdditional(Entity entity) {
        NpcEntity.discardAdditional(entity.getUUID());
    }

    public static void discardAdditional(UUID uuid) {
        entities.remove(uuid);
    }

    @Nullable
    public static NpcEntity<?> getEntity(Entity entity) {
        return NpcEntity.getEntity(entity.getUUID());
    }

    @Nullable
    public static NpcEntity<?> getEntity(UUID uuid) {
        return entities.get(uuid);
    }

    public NpcType getEntityType() {
        return this.entityType;
    }

    public T getOriginEntity() {
        return this.originEntity;
    }
}

