/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.database.type;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;
import org.thexeler.freeepicgames.FreeEpicGames;
import org.thexeler.freeepicgames.database.agent.WorldNpcDataAgent;
import org.thexeler.freeepicgames.database.untils.DataPacket;
import org.thexeler.freeepicgames.database.untils.DataUtils;
import org.thexeler.freeepicgames.database.view.NpcView;

public class NpcType {
    private static final Map<String, NpcType> types = new HashMap<String, NpcType>();
    private final String name;
    private final EntityType<?> entityType;
    private final boolean isInvulnerable;
    private final boolean isInvisible;
    private final boolean isNoGravity;
    private final boolean isNoAI;

    private NpcType(String name, EntityType<?> type, boolean isInvulnerable, boolean isInvisible, boolean isNoGravity, boolean isNoAI) {
        this.name = name;
        this.entityType = type;
        this.isInvulnerable = isInvulnerable;
        this.isInvisible = isInvisible;
        this.isNoGravity = isNoGravity;
        this.isNoAI = isNoAI;
    }

    public NpcView create(ServerLevel level) {
        WorldNpcDataAgent agent = WorldNpcDataAgent.getInstance(level);
        return agent.createNPC(this, null);
    }

    private JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("base_id", this.entityType.toString());
        jsonObject.addProperty("is_invulnerable", Boolean.valueOf(this.isInvulnerable));
        jsonObject.addProperty("is_invisible", Boolean.valueOf(this.isInvisible));
        jsonObject.addProperty("is_no_gravity", Boolean.valueOf(this.isNoGravity));
        jsonObject.addProperty("is_no_ai", Boolean.valueOf(this.isNoAI));
        return jsonObject;
    }

    public static boolean register(String name, JsonObject object) {
        if (!types.containsKey(name)) {
            String typeURI = object.get("base_id").getAsString();
            Optional typeOptional = EntityType.byString((String)typeURI);
            if (typeOptional.isPresent()) {
                types.put(name, new NpcType(name, (EntityType)typeOptional.get(), DataUtils.getValue(object, "is_invulnerable", true), DataUtils.getValue(object, "is_invisible", true), DataUtils.getValue(object, "is_no_gravity", true), DataUtils.getValue(object, "is_no_ai", true)));
                return true;
            }
            FreeEpicGames.LOGGER.error("Unknow entity type from URI : {}", (Object)typeURI);
        } else {
            FreeEpicGames.LOGGER.error("Repeated registration key : {}", (Object)name);
        }
        return false;
    }

    public static boolean unregister(String name) {
        if (types.containsKey(name)) {
            types.remove(name);
            FreeEpicGames.LOGGER.info("Unregistered npc type : {}", (Object)name);
            return true;
        }
        FreeEpicGames.LOGGER.error("Unregister failed : {}", (Object)name);
        return false;
    }

    public static List<NpcType> getAllType() {
        return new ArrayList<NpcType>(types.values());
    }

    public static List<String> getAllTypeName() {
        return new ArrayList<String>(types.keySet());
    }

    @Nullable
    public static NpcType getType(String name) {
        return types.get(name);
    }

    public static void init() {
        FreeEpicGames.LOGGER.info("Loading NpcView types...");
        DataUtils.getPackAllData(DataPacket.NPC_TYPE).forEach(NpcType::register);
        FreeEpicGames.LOGGER.info("Loaded {} NpcView types", (Object)types.size());
    }

    public static void expire() {
        FreeEpicGames.LOGGER.info("Saving NpcView types...");
        HashMap<String, JsonObject> jsonMap = new HashMap<String, JsonObject>();
        types.forEach((name, type) -> jsonMap.put((String)name, type.toJson()));
        DataUtils.savePacketAllData(DataPacket.NPC_TYPE, jsonMap);
        FreeEpicGames.LOGGER.info("Expiring NpcView types...");
        types.clear();
        FreeEpicGames.LOGGER.info("Expired NpcView types");
    }

    public String getName() {
        return this.name;
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    public boolean isInvulnerable() {
        return this.isInvulnerable;
    }

    public boolean isInvisible() {
        return this.isInvisible;
    }

    public boolean isNoGravity() {
        return this.isNoGravity;
    }

    public boolean isNoAI() {
        return this.isNoAI;
    }
}

