/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.database.type;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.Container;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.jetbrains.annotations.Nullable;
import org.thexeler.freeepicgames.FreeEpicGames;
import org.thexeler.freeepicgames.database.untils.DataPacket;
import org.thexeler.freeepicgames.database.untils.DataUtils;

public class RaidTreasureType {
    private static final Map<String, RaidTreasureType> types = Collections.synchronizedMap(new HashMap());
    private final String name;
    private final String title;
    private final boolean isPlayerOwn;
    private final LootTable lootTable;

    private RaidTreasureType(String name, String title, boolean isPlayerOwn, LootTable lootTable) {
        this.name = name;
        this.title = title;
        this.isPlayerOwn = isPlayerOwn;
        this.lootTable = lootTable;
    }

    public void generator(Container container) {
        if (this.lootTable != null) {
            this.lootTable.fill(container, new LootParams.Builder(FreeEpicGames.RAID_WORLD).create(LootContextParamSets.CHEST), 0L);
        }
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        Gson gson = new Gson();
        jsonObject.addProperty("title", this.title);
        jsonObject.addProperty("is_player_own", Boolean.valueOf(this.isPlayerOwn));
        jsonObject.addProperty("loot_table", gson.toJson((Object)this.lootTable));
        return jsonObject;
    }

    public static boolean register(String name, JsonObject object) {
        if (!types.containsKey(name)) {
            Gson gson = new Gson();
            types.put(name, new RaidTreasureType(name, DataUtils.getValue(object, "title", ""), DataUtils.getValue(object, "is_player_own", false), (LootTable)gson.fromJson((JsonElement)object.getAsJsonObject("loot_table"), LootTable.class)));
            return true;
        }
        FreeEpicGames.LOGGER.error("Repeated registration key : {}", (Object)name);
        return false;
    }

    public static boolean unregister(String name) {
        if (types.containsKey(name)) {
            types.remove(name);
            return true;
        }
        return false;
    }

    public static List<RaidTreasureType> getAllType() {
        return new ArrayList<RaidTreasureType>(types.values());
    }

    public static List<String> getAllTypeName() {
        return new ArrayList<String>(types.keySet());
    }

    @Nullable
    public static RaidTreasureType getType(String name) {
        return types.get(name);
    }

    public static void init() {
        FreeEpicGames.LOGGER.info("Initializing RaidTreasureTypes...");
        DataUtils.getPackAllData(DataPacket.RAID_TREASURE_TYPE).forEach(RaidTreasureType::register);
    }

    public static void expire() {
        FreeEpicGames.LOGGER.info("Saving RaidTreasureTypes...");
        HashMap<String, JsonObject> jsonMap = new HashMap<String, JsonObject>();
        types.forEach((name, type) -> jsonMap.put((String)name, type.toJson()));
        DataUtils.savePacketAllData(DataPacket.RAID_TREASURE_TYPE, jsonMap);
        FreeEpicGames.LOGGER.info("Expiring RaidTreasureTypes...");
        types.clear();
        FreeEpicGames.LOGGER.info("Expired RaidTreasureTypes.");
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isPlayerOwn() {
        return this.isPlayerOwn;
    }
}

