/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.database.untils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.thexeler.freeepicgames.database.agent.AbstractDataAgent;
import org.thexeler.freeepicgames.database.agent.GlobalJobDataAgent;
import org.thexeler.freeepicgames.database.agent.GlobalRaidDataAgent;

public class ModSavedData
extends SavedData {
    private static ModSavedData instance = null;
    private final Map<String, JsonObject> globalDataMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<String, JsonObject>> worldDataMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, AbstractDataAgent> worldAgentMap = Collections.synchronizedMap(new HashMap());

    private ModSavedData() {
        instance = this;
    }

    public static JsonObject getGlobalData(String id) {
        return ModSavedData.instance.globalDataMap.computeIfAbsent(id, key -> new JsonObject());
    }

    public static JsonObject getWorldData(Level world, String id) {
        return ModSavedData.instance.worldDataMap.computeIfAbsent(world.dimension().toString(), key -> Collections.synchronizedMap(new HashMap())).computeIfAbsent(id, key -> new JsonObject());
    }

    public static ModSavedData create() {
        return new ModSavedData();
    }

    public static ModSavedData load(CompoundTag compoundTag, HolderLookup.Provider lookupProvider) {
        Gson gson = new Gson();
        ModSavedData savedData = ModSavedData.create();
        CompoundTag globalTag = compoundTag.getCompound("Global");
        CompoundTag worldsTag = compoundTag.getCompound("Worlds");
        if (!globalTag.isEmpty()) {
            globalTag.getAllKeys().forEach(key -> savedData.globalDataMap.put((String)key, (JsonObject)gson.fromJson(globalTag.get(key).getAsString(), JsonObject.class)));
        }
        if (!worldsTag.isEmpty()) {
            worldsTag.getAllKeys().forEach(key -> {
                Map worldData = savedData.worldDataMap.computeIfAbsent((String)key, k -> new HashMap());
                CompoundTag worldTag = worldsTag.getCompound(key);
                if (!worldTag.isEmpty()) {
                    worldTag.getAllKeys().forEach(key2 -> worldData.put(key2, (JsonObject)gson.fromJson(worldTag.get(key2).getAsString(), JsonObject.class)));
                }
                savedData.worldDataMap.put((String)key, worldData);
            });
        }
        return savedData;
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag compoundTag, @NotNull HolderLookup.Provider registries) {
        GlobalJobDataAgent.getInstance().save();
        GlobalRaidDataAgent.getInstance().save();
        this.worldAgentMap.forEach((key, value) -> value.save());
        Gson gson = new Gson();
        CompoundTag globalTag = new CompoundTag();
        CompoundTag worldsTag = new CompoundTag();
        this.globalDataMap.forEach((key, value) -> globalTag.put(key, (Tag)StringTag.valueOf((String)gson.toJson((JsonElement)value))));
        this.worldDataMap.forEach((key, value) -> {
            CompoundTag worldTag = new CompoundTag();
            value.forEach((key2, value2) -> worldTag.put(key2, (Tag)StringTag.valueOf((String)gson.toJson((JsonElement)value2))));
            worldsTag.put(key, (Tag)worldTag);
        });
        compoundTag.put("Global", (Tag)globalTag);
        compoundTag.put("Worlds", (Tag)worldsTag);
        return compoundTag;
    }

    public boolean isDirty() {
        return true;
    }
}

