/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.database.view;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.thexeler.freeepicgames.FreeEpicGames;
import org.thexeler.freeepicgames.database.type.RaidTreasureType;
import org.thexeler.freeepicgames.database.type.RaidType;
import org.thexeler.freeepicgames.database.untils.DataUtils;
import org.thexeler.freeepicgames.database.view.AbstractCacheView;

public class RaidInstanceView
implements AbstractCacheView {
    private static final Map<String, RaidInstanceView> playerInstanceMappings = Collections.synchronizedMap(new HashMap());
    private final String id;
    private final RaidType baseType;
    private final ChunkPos startChunk;
    private final ChunkPos endChunk;
    private final Map<String, Vec3> playerCheckpointPosMap;
    private final Map<BlockPos, Container> sharedTreasuresMap;
    private final Map<String, Map<BlockPos, Container>> playerTreasuresMap;
    private boolean isActive;
    private final AABB frame;
    private final BlockPos blockPosOffset;

    public RaidInstanceView(String id, RaidType baseType, ChunkPos startChunk) {
        this.id = id;
        this.baseType = baseType;
        this.startChunk = startChunk;
        this.endChunk = new ChunkPos(SectionPos.blockToSectionCoord((int)(startChunk.getMaxBlockX() + baseType.getSize().getX())), SectionPos.blockToSectionCoord((int)(startChunk.getMaxBlockZ() + baseType.getSize().getZ())));
        this.playerCheckpointPosMap = new HashMap<String, Vec3>();
        this.sharedTreasuresMap = new HashMap<BlockPos, Container>();
        this.playerTreasuresMap = new HashMap<String, Map<BlockPos, Container>>();
        Vec3 startPos = new Vec3((double)startChunk.getMinBlockX(), 0.0, (double)startChunk.getMinBlockZ());
        Vec3 endPos = new Vec3((double)this.endChunk.getMaxBlockX(), (double)FreeEpicGames.RAID_WORLD.getMaxBuildHeight(), (double)this.endChunk.getMaxBlockZ());
        this.frame = new AABB(startPos, endPos);
        this.isActive = false;
        this.blockPosOffset = new BlockPos(startChunk.getMinBlockX(), 0, startChunk.getMinBlockZ());
    }

    public RaidInstanceView(JsonObject object) {
        this.id = DataUtils.getValue(object, "uuid", UUID.randomUUID().toString());
        this.baseType = RaidType.getType(DataUtils.getValue(object, "base_type", ""));
        this.startChunk = new ChunkPos(object.get("start_chunk").getAsInt(), object.get("start_chunk").getAsInt());
        this.endChunk = new ChunkPos(object.get("end_chunk").getAsInt(), object.get("end_chunk").getAsInt());
        this.playerCheckpointPosMap = new HashMap<String, Vec3>();
        Map<String, JsonElement> checkPoints = DataUtils.getValue(object, "check_points", new HashMap<String, JsonElement>());
        checkPoints.forEach((uuid, infoElement) -> {
            JsonObject infoObject = infoElement.getAsJsonObject();
            this.playerCheckpointPosMap.put((String)uuid, new Vec3((double)DataUtils.getValue(infoObject, "x", 0.0f), (double)DataUtils.getValue(infoObject, "y", 0.0f), (double)DataUtils.getValue(infoObject, "z", 0.0f)));
        });
        this.sharedTreasuresMap = new HashMap<BlockPos, Container>();
        List<JsonElement> sharedTreasures = DataUtils.getValue(object, "shared_treasures", new ArrayList<JsonElement>());
        sharedTreasures.forEach(infoElement -> {
            JsonObject infoObject = infoElement.getAsJsonObject();
            JsonArray containerJson = DataUtils.getValue(infoObject, "container", new JsonArray());
            if (containerJson != null) {
                this.sharedTreasuresMap.put(new BlockPos(DataUtils.getValue(infoObject, "x", 0), DataUtils.getValue(infoObject, "y", 0), DataUtils.getValue(infoObject, "z", 0)), DataUtils.toContainer(containerJson));
            }
        });
        this.playerTreasuresMap = new HashMap<String, Map<BlockPos, Container>>();
        Map<String, JsonElement> allPlayerTreasures = DataUtils.getValue(object, "player_treasures", new HashMap<String, JsonElement>());
        allPlayerTreasures.forEach((uuid, playerTreasuresInfo) -> {
            JsonObject playerTreasuresInfoObject = playerTreasuresInfo.getAsJsonObject();
            Map playerTreasuresMap = this.playerTreasuresMap.computeIfAbsent((String)uuid, k -> new HashMap());
            List<JsonElement> playerTreasures = DataUtils.getValue(playerTreasuresInfoObject, "treasures", new ArrayList<JsonElement>());
            playerTreasures.forEach(playerTreasureInfo -> {
                JsonObject playerTreasureInfoObject = playerTreasureInfo.getAsJsonObject();
                JsonArray containerJson = DataUtils.getValue(playerTreasureInfoObject, "container", new JsonArray());
                playerTreasuresMap.put(new BlockPos(DataUtils.getValue(playerTreasureInfoObject, "x", 0), DataUtils.getValue(playerTreasureInfoObject, "y", 0), DataUtils.getValue(playerTreasureInfoObject, "z", 0)), DataUtils.toContainer(containerJson));
            });
        });
        BlockPos startBlock = new BlockPos(this.startChunk.getMinBlockX(), 0, this.startChunk.getMinBlockZ());
        BlockPos endBlock = new BlockPos(this.endChunk.getMaxBlockX(), FreeEpicGames.RAID_WORLD.getMaxBuildHeight(), this.endChunk.getMaxBlockZ());
        this.frame = new AABB(new Vec3((double)startBlock.getX(), (double)startBlock.getY(), (double)startBlock.getZ()), new Vec3((double)endBlock.getX(), (double)endBlock.getY(), (double)endBlock.getZ()));
        this.isActive = DataUtils.getValue(object, "is_active", false);
        this.blockPosOffset = new BlockPos(this.startChunk.getMinBlockX(), 0, this.startChunk.getMinBlockZ());
    }

    public MenuProvider getMenuProvider(ServerPlayer player, BlockPos blockPos) {
        RaidTreasureType treasure = this.baseType.getTreasureType(blockPos.subtract((Vec3i)this.blockPosOffset));
        Map actualMap = treasure.isPlayerOwn() ? this.sharedTreasuresMap : this.playerTreasuresMap.computeIfAbsent(player.getStringUUID(), p -> new HashMap());
        return new SimpleMenuProvider((ci, i, p) -> {
            Container container = actualMap.computeIfAbsent(blockPos, bp -> {
                SimpleContainer simpleContainer = new SimpleContainer(27);
                treasure.generator((Container)simpleContainer);
                return simpleContainer;
            });
            return ChestMenu.threeRows((int)ci, (Inventory)i, (Container)container);
        }, (Component)Component.literal((String)treasure.getTitle()));
    }

    public boolean isInside(Vec3 pos) {
        return this.frame.contains(pos);
    }

    public RaidTreasureType getTreasureType(BlockPos blockPos) {
        return this.baseType.getTreasureType(blockPos.subtract((Vec3i)this.blockPosOffset));
    }

    public void respawn(ServerPlayer player) {
        Vec3 checkpointPos = new Vec3(0.0, 0.0, 0.0);
        if (player.isDeadOrDying()) {
            player.respawn();
        }
        player.teleportTo(FreeEpicGames.RAID_WORLD, checkpointPos.x, checkpointPos.y, checkpointPos.z, Collections.emptySet(), 0.0f, 0.0f);
    }

    public void setPlayer(ServerPlayer player, Vec3 checkpointPos) {
        playerInstanceMappings.put(player.getStringUUID(), this);
        this.playerCheckpointPosMap.put(player.getStringUUID(), checkpointPos);
        if (!FreeEpicGames.RAID_WORLD.players().contains(player)) {
            player.teleportTo(FreeEpicGames.RAID_WORLD, checkpointPos.x, checkpointPos.y, checkpointPos.z, Collections.emptySet(), 0.0f, 0.0f);
        }
    }

    public void removePlayer(ServerPlayer player) {
        if (player.getRespawnPosition() != null) {
            this.removePlayer(player, player.getRespawnPosition());
        } else {
            this.removePlayer(player, FreeEpicGames.OVER_WORLD.getSharedSpawnPos());
        }
    }

    public void removePlayer(ServerPlayer player, BlockPos pos) {
        playerInstanceMappings.remove(player.getStringUUID());
        this.playerCheckpointPosMap.remove(player.getStringUUID());
        player.teleportTo(FreeEpicGames.OVER_WORLD, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), Collections.emptySet(), player.getYRot(), player.getXRot());
    }

    public static RaidInstanceView getRaidInstanceFromPlayer(Player player) {
        return playerInstanceMappings.get(player.getStringUUID());
    }

    public void build() {
        if (!this.isActive) {
            FreeEpicGames.LOGGER.info("Raid instance building: {}", (Object)this.id);
            int targetZ = 0;
            int chunkSizeX = this.endChunk.x - this.startChunk.x;
            int chunkSizeZ = this.endChunk.z - this.startChunk.z;
            for (int targetX = 0; targetX <= this.endChunk.x; ++targetX) {
                while (targetZ <= this.endChunk.z) {
                    LevelChunk chunk = FreeEpicGames.RAID_WORLD.getChunk(targetX, targetZ);
                    ++targetZ;
                }
            }
            this.isActive = true;
        } else {
            FreeEpicGames.LOGGER.warn("Raid instance already active: {}", (Object)this.id);
        }
    }

    public void destroy() {
        if (this.isActive) {
            this.isActive = false;
        } else {
            FreeEpicGames.LOGGER.warn("Raid instance already inactive: {}", (Object)this.id);
        }
    }

    @Override
    public JsonObject toCacheJson() {
        JsonObject cacheInfo = new JsonObject();
        cacheInfo.addProperty("uuid", this.id);
        cacheInfo.addProperty("base_type", this.baseType.getName());
        cacheInfo.addProperty("start_chunk", this.startChunk.toString());
        cacheInfo.addProperty("end_chunk", this.endChunk.toString());
        JsonObject checkpointsJson = new JsonObject();
        this.playerCheckpointPosMap.forEach((u, v) -> {
            JsonObject posObject = new JsonObject();
            posObject.addProperty("x", (Number)v.x);
            posObject.addProperty("y", (Number)v.y);
            posObject.addProperty("z", (Number)v.z);
            checkpointsJson.add(u, (JsonElement)posObject);
        });
        cacheInfo.add("check_points", (JsonElement)checkpointsJson);
        JsonArray sharedTreasure = new JsonArray();
        this.sharedTreasuresMap.forEach((bp, c) -> {
            JsonObject treasureObject = new JsonObject();
            treasureObject.addProperty("x", (Number)bp.getX());
            treasureObject.addProperty("y", (Number)bp.getY());
            treasureObject.addProperty("z", (Number)bp.getZ());
            treasureObject.add("container", (JsonElement)DataUtils.fromContainer(c));
            sharedTreasure.add((JsonElement)treasureObject);
        });
        cacheInfo.add("shared_treasures", (JsonElement)sharedTreasure);
        JsonObject allPlayerTreasures = new JsonObject();
        this.playerTreasuresMap.forEach((p, pc) -> {
            JsonArray playerTreasures = new JsonArray();
            pc.forEach((bp, c) -> {
                JsonObject treasureObject = new JsonObject();
                treasureObject.addProperty("x", (Number)bp.getX());
                treasureObject.addProperty("y", (Number)bp.getY());
                treasureObject.addProperty("z", (Number)bp.getZ());
                treasureObject.add("container", (JsonElement)DataUtils.fromContainer(c));
                playerTreasures.add((JsonElement)treasureObject);
            });
            allPlayerTreasures.add(p, (JsonElement)playerTreasures);
        });
        cacheInfo.add("player_treasures", (JsonElement)allPlayerTreasures);
        return cacheInfo;
    }

    public String getId() {
        return this.id;
    }
}

