/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.handler;

import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.thexeler.freeepicgames.FreeEpicGames;
import org.thexeler.freeepicgames.FreeEpicGamesConfigs;
import org.thexeler.freeepicgames.database.agent.WorldCaptureDataAgent;
import org.thexeler.freeepicgames.database.untils.LogicTeam;
import org.thexeler.freeepicgames.database.view.AreaView;

@EventBusSubscriber
public class CaptureEventHandler {
    private static int tickCount = 0;

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        if (FreeEpicGamesConfigs.isEnabledCapture && ++tickCount % FreeEpicGamesConfigs.captureTick == 0) {
            tickCount -= FreeEpicGamesConfigs.captureTick;
            event.getServer().getAllLevels().forEach(serverLevel -> {
                WorldCaptureDataAgent agent = WorldCaptureDataAgent.getInstance(serverLevel);
                String attackerName = agent.getAttacker();
                String defenderName = agent.getDefender();
                agent.getAllAreas().stream().filter(AreaView::isLocked).forEach(area -> {
                    float areaSchedule = area.getSchedule();
                    AtomicInteger scheduleCount = new AtomicInteger();
                    LogicTeam controller = area.getController();
                    ServerBossEvent bossBar = area.getBossBar();
                    PlayerTeam attacker = serverLevel.getServer().getScoreboard().getPlayerTeam(attackerName);
                    PlayerTeam defender = serverLevel.getServer().getScoreboard().getPlayerTeam(defenderName);
                    serverLevel.players().forEach(player -> {
                        if (area.isInside(player.position())) {
                            if (attacker != null && attacker.getPlayers().contains(player.getName().getString())) {
                                scheduleCount.getAndIncrement();
                            }
                            if (defender != null && defender.getPlayers().contains(player.getName().getString())) {
                                scheduleCount.getAndDecrement();
                            }
                            bossBar.addPlayer(player);
                        } else {
                            bossBar.removePlayer(player);
                        }
                    });
                    if (scheduleCount.get() != 0) {
                        area.setSchedule((float)scheduleCount.get() * agent.getRate() + area.getSchedule());
                    }
                    if (areaSchedule >= 100.0f) {
                        if (controller != LogicTeam.ATTACKER) {
                            serverLevel.players().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("\u8fdb\u653b\u65b9\u5df2\u593a\u53d6\u533a\u57df" + area.getName() + "!"))));
                            area.setController(LogicTeam.ATTACKER);
                        }
                    } else if (areaSchedule <= -100.0f) {
                        if (controller != LogicTeam.DEFENDER) {
                            serverLevel.players().forEach(player -> player.sendSystemMessage((Component)Component.literal((String)("\u9632\u5b88\u65b9\u5df2\u593a\u53d6\u533a\u57df" + area.getName() + "!"))));
                            area.setController(LogicTeam.DEFENDER);
                        }
                    } else if (areaSchedule <= 50.0f && controller == LogicTeam.ATTACKER || areaSchedule >= -50.0f && controller == LogicTeam.DEFENDER) {
                        serverLevel.players().forEach(player -> {
                            String string = area.getName();
                            player.sendSystemMessage((Component)Component.literal((String)("\u533a\u57df" + string + "\u5df2\u88ab" + (switch (controller) {
                                case LogicTeam.ATTACKER -> "\u9632\u5b88\u65b9";
                                case LogicTeam.DEFENDER -> "\u8fdb\u653b\u65b9";
                                default -> "";
                            }) + "\u4e2d\u7acb\u5316!")));
                        });
                        area.setController(LogicTeam.NEUTRAL);
                    }
                });
            });
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (projectile instanceof SpectralArrow) {
            SpectralArrow arrow = (SpectralArrow)projectile;
            try (Level world = arrow.level();){
                if (world.isClientSide()) {
                    return;
                }
                if (arrow.getOwner() == null) {
                    return;
                }
                WorldCaptureDataAgent agent = WorldCaptureDataAgent.getInstance((ServerLevel)world);
                EntityType cannonType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"createbigcannons", (String)"drop_mortar_shell"));
                String uuid = arrow.getOwner().getStringUUID();
                if (uuid.equals(agent.getAttackerCommander()) || uuid.equals(agent.getDefenderCommander())) {
                    Random random = new Random();
                    CaptureEventHandler.createCannonShell(cannonType, world, arrow.getBlockX(), (double)arrow.getBlockY() + 100.0, arrow.getBlockZ());
                    int i = 0;
                    while (i++ < 80) {
                        CaptureEventHandler.createCannonShell(cannonType, world, (double)arrow.getBlockX() + random.nextDouble(-20.0, 20.0), (double)arrow.getBlockY() + 300.0 + (double)i * 20.0, (double)arrow.getBlockZ() + random.nextDouble(-20.0, 20.0));
                    }
                    arrow.discard();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static Entity createCannonShell(EntityType<?> cannonType, Level world, double x, double y, double z) {
        Entity entity = cannonType.create(world);
        if (entity != null) {
            CompoundTag fuze = new CompoundTag();
            fuze.putInt("Count", 1);
            fuze.putString("id", "createbigcannons:impact_fuze");
            entity.getPersistentData().put("Fuze", (Tag)fuze);
            entity.setPos(x, y, z);
            world.addFreshEntity(entity);
        } else {
            FreeEpicGames.LOGGER.error("Can not create entity by type \"{}\" !", cannonType);
        }
        return entity;
    }
}

