/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.thexeler.freeepicgames.FreeEpicGamesConfigs;
import org.thexeler.freeepicgames.FreeEpicGamesKeys;
import org.thexeler.freeepicgames.handler.CaptureEventHandler;
import org.thexeler.freeepicgames.handler.JobEventHandler;
import org.thexeler.freeepicgames.handler.NpcEventHandler;
import org.thexeler.freeepicgames.handler.RaidEventHandler;
import org.thexeler.freeepicgames.storage.agent.CaptureWorldDataAgent;
import org.thexeler.freeepicgames.storage.agent.JobDataAgent;
import org.thexeler.freeepicgames.storage.agent.NpcWorldDataAgent;
import org.thexeler.freeepicgames.storage.agent.RaidDataAgent;
import org.thexeler.freeepicgames.storage.type.JobType;
import org.thexeler.freeepicgames.storage.type.NpcType;
import org.thexeler.freeepicgames.storage.type.RaidTreasureType;
import org.thexeler.freeepicgames.storage.type.RaidType;
import org.thexeler.freeepicgames.storage.utils.ModSavedData;

@Mod(value="freeepicgames")
public class FreeEpicGames {
    public static final String MOD_ID = "freeepicgames";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static ModSavedData SAVED_DATA = null;
    public static ServerLevel RAID_WORLD = null;
    public static ServerLevel OVER_WORLD = null;
    public static final List<Object> EVENT_LISTENER = new ArrayList<Object>();

    public FreeEpicGames() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)FreeEpicGamesConfigs.SPEC);
        EVENT_LISTENER.add(new CaptureEventHandler());
        EVENT_LISTENER.add(new JobEventHandler());
        EVENT_LISTENER.add(new NpcEventHandler());
        EVENT_LISTENER.add(new RaidEventHandler());
    }

    @SubscribeEvent
    public void onReloadListenerAdd(AddReloadListenerEvent event) {
        event.addListener(new PreparableReloadListener(){

            @NotNull
            public CompletableFuture<Void> m_5540_(@NotNull PreparableReloadListener.PreparationBarrier preparationBarrier, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller preparationsProfiler, @NotNull ProfilerFiller reloadProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
                if (FreeEpicGamesConfigs.isEnabledJob) {
                    JobType.expire(true);
                    JobType.init();
                }
                if (FreeEpicGamesConfigs.isEnabledRaid) {
                    RaidTreasureType.expire(true);
                    RaidTreasureType.init();
                    RaidType.expire(true);
                    RaidType.init();
                }
                NpcType.expire(true);
                NpcType.init();
                return preparationBarrier.m_6769_(CompletableFuture.completedFuture(null)).thenRunAsync(() -> LOGGER.info("\u914d\u7f6e\u6587\u4ef6\u91cd\u8f7d\u5b8c\u6210"), gameExecutor);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onOverWorldLoad(ServerStartedEvent event) {
        RAID_WORLD = event.getServer().m_129880_(FreeEpicGamesKeys.RAID_WORLD_KEY);
        OVER_WORLD = event.getServer().m_129783_();
        if (FreeEpicGamesConfigs.isEnabledJob) {
            JobType.init();
        }
        if (FreeEpicGamesConfigs.isEnabledRaid) {
            RaidTreasureType.init();
            RaidType.init();
        }
        NpcType.init();
        SAVED_DATA = (ModSavedData)OVER_WORLD.m_8895_().m_164861_(ModSavedData::load, ModSavedData::create, MOD_ID);
        EVENT_LISTENER.forEach(arg_0 -> ((IEventBus)MinecraftForge.EVENT_BUS).register(arg_0));
    }

    @SubscribeEvent
    public void onAddReloadListener(AddReloadListenerEvent event) {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onOverWorldUnload(ServerStoppedEvent event) {
        RAID_WORLD = null;
        OVER_WORLD = null;
        if (FreeEpicGamesConfigs.isEnabledJob) {
            JobType.expire();
        }
        if (FreeEpicGamesConfigs.isEnabledRaid) {
            RaidTreasureType.expire();
            RaidType.expire();
        }
        NpcType.expire();
        CaptureWorldDataAgent.expire();
        JobDataAgent.expire();
        RaidDataAgent.expire();
        NpcWorldDataAgent.expire();
        SAVED_DATA = null;
        EVENT_LISTENER.forEach(arg_0 -> ((IEventBus)MinecraftForge.EVENT_BUS).unregister(arg_0));
    }
}

