/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.handler;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.thexeler.freeepicgames.FreeEpicGames;
import org.thexeler.freeepicgames.FreeEpicGamesConfigs;
import org.thexeler.freeepicgames.storage.agent.JobDataAgent;
import org.thexeler.freeepicgames.storage.type.JobType;

public class JobEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (FreeEpicGamesConfigs.isEnabledJob && (livingEntity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            player.m_150109_().m_6211_();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player;
        if (FreeEpicGamesConfigs.isEnabledJob && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            JobDataAgent agent = JobDataAgent.getInstance();
            JobType type = JobType.getType(agent.getPlayerJob(player2));
            if (type != null) {
                type.getAllItems().forEach(stack -> {
                    EquipmentSlot slot = ServerPlayer.m_147233_((ItemStack)stack);
                    if (player2.m_6844_(slot).m_41619_()) {
                        player2.m_150109_().m_36054_(stack);
                    } else {
                        switch (slot) {
                            case HEAD: 
                            case CHEST: 
                            case LEGS: 
                            case FEET: {
                                player2.m_238392_(slot, player2.m_6844_(slot), stack);
                                break;
                            }
                            default: {
                                player2.m_150109_().m_36054_(stack);
                            }
                        }
                    }
                });
            } else {
                agent.setPlayerJob(player2, "");
            }
        }
    }

    @SubscribeEvent
    public void onItemUse(LivingEntityUseItemEvent event) {
        LivingEntity livingEntity;
        if (FreeEpicGamesConfigs.isEnabledJob && (livingEntity = event.getEntity()) instanceof ServerPlayer) {
            String customCommand;
            ServerPlayer player = (ServerPlayer)livingEntity;
            CompoundTag data = event.getItem().serializeNBT();
            if (data != null && data.m_128441_("custom_command") && !(customCommand = data.m_128461_("custom_command")).isEmpty()) {
                try {
                    player.f_8924_.m_129892_().m_82094_().execute(customCommand, (Object)player.f_8924_.m_129893_());
                }
                catch (CommandSyntaxException e) {
                    FreeEpicGames.LOGGER.error(e.getMessage());
                }
            }
        }
    }
}

