/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.handler;

import java.util.Collections;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.thexeler.freeepicgames.FreeEpicGames;
import org.thexeler.freeepicgames.FreeEpicGamesKeys;
import org.thexeler.freeepicgames.events.RaidEvent;
import org.thexeler.freeepicgames.storage.agent.RaidDataAgent;
import org.thexeler.freeepicgames.storage.type.RaidTreasureType;
import org.thexeler.freeepicgames.storage.view.RaidInstanceView;
import org.thexeler.freeepicgames.utils.chestmenu.ChestMenuHelper;
import org.thexeler.slacker.SlackerForge;
import oshi.util.tuples.Pair;

public class RaidEventHandler {
    @SubscribeEvent
    public void onOpenContainer(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            RaidTreasureType treasure;
            RaidDataAgent agent;
            RaidInstanceView view;
            ServerPlayer player2 = (ServerPlayer)player;
            if (FreeEpicGames.RAID_WORLD.equals(event.getLevel()) && (view = (agent = RaidDataAgent.getInstance()).getRaidInstance(player2)) != null && (treasure = view.getTreasureType(event.getPos())) != null && !SlackerForge.EVENT_BUS.post(new RaidEvent.OpenTreasureEvent(view, view.getTreasureContainer(player2, event.getPos()), player2)).isCanceled()) {
                Container container = view.getTreasureContainer(player2, event.getPos());
                ChestMenuHelper.openVirtualChest(player2, container, treasure.getTitle());
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).m_9236_().equals(FreeEpicGames.RAID_WORLD)) {
            RaidDataAgent agent = RaidDataAgent.getInstance();
            RaidInstanceView view = agent.getRaidInstance(player);
            if (view != null) {
                view.respawn(player);
            } else {
                Pair<String, Vec3> backPosInfo = agent.getBackPos(player);
                ServerLevel level = FreeEpicGames.OVER_WORLD;
                if (backPosInfo != null) {
                    if (player.m_20194_() != null) {
                        level = player.m_20194_().m_129880_(FreeEpicGamesKeys.parseWorldKey((String)backPosInfo.getA()));
                    }
                    if (level != null) {
                        player.m_264318_(level, ((Vec3)backPosInfo.getB()).f_82479_, ((Vec3)backPosInfo.getB()).f_82480_, ((Vec3)backPosInfo.getB()).f_82481_, Collections.emptySet(), 0.0f, 0.0f);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            RaidDataAgent agent = RaidDataAgent.getInstance();
            RaidInstanceView view = agent.getRaidInstance(player2);
            if (view != null && player2.m_8961_() != null && view.isInside(player2.m_8961_().m_252807_())) {
                view.respawn(player2);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRaidTick(TickEvent.ServerTickEvent event) {
        RaidDataAgent agent = RaidDataAgent.getInstance();
        agent.getAllRaidInstance().forEach(view -> MinecraftForge.EVENT_BUS.post((Event)new RaidEvent.TickEvent((RaidInstanceView)view)));
    }
}

