/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.storage.agent;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.Nullable;
import org.thexeler.freeepicgames.FreeEpicGamesConfigs;
import org.thexeler.freeepicgames.storage.agent.AbstractWorldDataAgent;
import org.thexeler.freeepicgames.storage.utils.DataUtils;
import org.thexeler.freeepicgames.storage.utils.ModSavedData;
import org.thexeler.freeepicgames.storage.view.AreaView;

public class CaptureWorldDataAgent
extends AbstractWorldDataAgent {
    private static final Map<ServerLevel, CaptureWorldDataAgent> instances = new HashMap<ServerLevel, CaptureWorldDataAgent>();
    private final JsonObject optionData;
    private final JsonObject areasData;
    private final JsonObject areasCache;
    private String attacker;
    private String attackerCommander;
    private String defender;
    private String defenderCommander;
    private float rate;
    private String exportObjectiveName;
    private final Map<String, AreaView> areaViewMap = Collections.synchronizedMap(new HashMap());

    private CaptureWorldDataAgent(ServerLevel world) {
        super(world);
        this.optionData = ModSavedData.getWorldData(world, "CaptureSettings");
        this.areasData = ModSavedData.getWorldData(world, "AreasData");
        this.areasCache = FreeEpicGamesConfigs.isEnabledCaptureCachePersistence ? ModSavedData.getWorldData(world, "AreasCache") : new JsonObject();
        this.load();
    }

    public static CaptureWorldDataAgent getInstance(ServerLevel world) {
        return instances.computeIfAbsent(world, CaptureWorldDataAgent::new);
    }

    public Collection<AreaView> getAllAreas() {
        return this.areaViewMap.values();
    }

    public boolean createArea(String name, double pos1X, double pos1Y, double pos1Z, double pos2X, double pos2Y, double pos2Z) {
        if (this.areasData.get(name) == null) {
            JsonObject areaCacheInfo = new JsonObject();
            areaCacheInfo.addProperty("locked", Boolean.valueOf(false));
            areaCacheInfo.addProperty("schedule", (Number)0.0);
            areaCacheInfo.addProperty("controller", "Neutral");
            areaCacheInfo.addProperty("exportSchedule", Boolean.valueOf(false));
            areaCacheInfo.addProperty("exportScheduleFormat", Boolean.valueOf(false));
            return this.createArea(name, pos1X, pos1Y, pos1Z, pos2X, pos2Y, pos2Z, areaCacheInfo);
        }
        return false;
    }

    public boolean createArea(String name, double pos1X, double pos1Y, double pos1Z, double pos2X, double pos2Y, double pos2Z, JsonObject cacheInfo) {
        if (this.areasData.get(name) == null) {
            JsonObject areaInfo = new JsonObject();
            areaInfo.addProperty("posX", (Number)Math.min(pos1X, pos2X));
            areaInfo.addProperty("posY", (Number)(Math.min(pos1Y, pos2Y) - 1.0));
            areaInfo.addProperty("posZ", (Number)Math.min(pos1Z, pos2Z));
            areaInfo.addProperty("endX", (Number)(Math.max(pos1X, pos2X) + 1.0));
            areaInfo.addProperty("endY", (Number)(Math.max(pos1Y, pos2Y) + 1.0));
            areaInfo.addProperty("endZ", (Number)(Math.max(pos1Z, pos2Z) + 1.0));
            areaInfo.addProperty("objectName", "");
            areaInfo.add("lockWhenAttackerCapture", (JsonElement)new JsonArray());
            areaInfo.add("unlockWhenAttackerCapture", (JsonElement)new JsonArray());
            areaInfo.add("lockWhenDefenderCapture", (JsonElement)new JsonArray());
            areaInfo.add("unlockWhenDefenderCapture", (JsonElement)new JsonArray());
            AreaView view = new AreaView(name, areaInfo, this);
            view.loadStatus(cacheInfo);
            this.areaViewMap.put(name, view);
            return true;
        }
        return false;
    }

    public boolean deleteArea(String name) {
        if (this.areaViewMap.get(name) != null) {
            this.areaViewMap.remove(name);
            return true;
        }
        return false;
    }

    @Nullable
    public AreaView getAreaView(String name) {
        return this.areaViewMap.get(name);
    }

    @Override
    public void load() {
        this.attacker = DataUtils.getValue(this.optionData, "attacker", "");
        this.defender = DataUtils.getValue(this.optionData, "defender", "");
        this.rate = DataUtils.getValue(this.optionData, "capture_rate", 1.0f);
        this.attackerCommander = DataUtils.getValue(this.optionData, "attacker_commander", "");
        this.defenderCommander = DataUtils.getValue(this.optionData, "defender_commander", "");
        this.areasData.keySet().forEach(name -> {
            AreaView view = new AreaView((String)name, this.areasData.getAsJsonObject(name), this);
            this.areaViewMap.put((String)name, view);
            if (FreeEpicGamesConfigs.isEnabledCaptureCachePersistence && this.areasCache != null && this.areasCache.get(name) != null) {
                view.loadStatus(this.areasCache.getAsJsonObject(name));
            }
        });
    }

    @Override
    public void save() {
        this.optionData.addProperty("Attacker", this.attacker);
        this.optionData.addProperty("Defender", this.defender);
        this.optionData.addProperty("CaptureRate", (Number)Float.valueOf(this.rate));
        this.optionData.addProperty("AttackerCommander", this.attackerCommander);
        this.optionData.addProperty("DefenderCommander", this.defenderCommander);
        this.optionData.addProperty("exportObjectiveName", this.exportObjectiveName);
        DataUtils.computeViewMap(this.areaViewMap, this.areasData);
        DataUtils.computeCacheViewMap(this.areaViewMap, this.areasCache);
    }

    public static void expire() {
        instances.clear();
    }

    public String getAttacker() {
        return this.attacker;
    }

    public String getAttackerCommander() {
        return this.attackerCommander;
    }

    public String getDefender() {
        return this.defender;
    }

    public String getDefenderCommander() {
        return this.defenderCommander;
    }

    public void setAttacker(String attacker) {
        this.attacker = attacker;
    }

    public void setAttackerCommander(String attackerCommander) {
        this.attackerCommander = attackerCommander;
    }

    public void setDefender(String defender) {
        this.defender = defender;
    }

    public void setDefenderCommander(String defenderCommander) {
        this.defenderCommander = defenderCommander;
    }

    public float getRate() {
        return this.rate;
    }

    public void setRate(float rate) {
        this.rate = rate;
    }

    public String getExportObjectiveName() {
        return this.exportObjectiveName;
    }

    public void setExportObjectiveName(String exportObjectiveName) {
        this.exportObjectiveName = exportObjectiveName;
    }
}

