/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.storage.agent;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.thexeler.freeepicgames.FreeEpicGames;
import org.thexeler.freeepicgames.events.NpcEvent;
import org.thexeler.freeepicgames.storage.agent.AbstractWorldDataAgent;
import org.thexeler.freeepicgames.storage.type.NpcType;
import org.thexeler.freeepicgames.storage.utils.DataUtils;
import org.thexeler.freeepicgames.storage.utils.ModSavedData;
import org.thexeler.freeepicgames.storage.view.NpcView;

public class NpcWorldDataAgent
extends AbstractWorldDataAgent {
    private static final Map<ServerLevel, NpcWorldDataAgent> instances = new HashMap<ServerLevel, NpcWorldDataAgent>();
    private final JsonObject optionData;
    private final JsonObject npcData;
    private boolean isReinforceMode;
    private final Map<String, NpcView> npcViewMap = Collections.synchronizedMap(new HashMap());

    private NpcWorldDataAgent(ServerLevel world) {
        super(world);
        this.optionData = ModSavedData.getWorldData(world, "NPCSettings");
        this.npcData = ModSavedData.getWorldData(world, "NPCData");
        this.load();
    }

    public static NpcWorldDataAgent getInstance(ServerLevel world) {
        return instances.computeIfAbsent(world, NpcWorldDataAgent::new);
    }

    public Collection<NpcView> getAllNpc() {
        return this.npcViewMap.values();
    }

    public NpcView createNpc(NpcType type, double x, double y, double z) {
        return this.createNpc(type, x, y, z, null);
    }

    public NpcView createNpc(NpcType type, @NotNull Entity origin) {
        return this.createNpc(type, origin.m_20185_(), origin.m_20186_(), origin.m_20189_(), origin);
    }

    public NpcView createNpc(NpcType type, double x, double y, double z, Entity origin) {
        boolean freshEntity = false;
        NpcView view = null;
        if (origin == null) {
            if (type.getEntityType() != EntityType.f_20532_) {
                origin = type.getEntityType().m_20615_((Level)this.world);
                freshEntity = true;
            } else {
                UUID uuid = UUID.randomUUID();
                GameProfile profile = new GameProfile(uuid, uuid.toString());
                origin = FakePlayerFactory.get((ServerLevel)this.world, (GameProfile)profile);
            }
        }
        if (origin != null) {
            if (this.npcData.get(origin.m_20149_()) == null) {
                view = new NpcView(origin, type, this);
                origin.m_20331_(type.isInvulnerable());
                origin.m_6842_(type.isInvisible());
                origin.m_20242_(type.isNoGravity());
                if (origin instanceof Mob) {
                    Mob mob = (Mob)origin;
                    if (type.isNoAI()) {
                        mob.m_21557_(true);
                    }
                    if (type.getLootTable() != null) {
                        // empty if block
                    }
                } else {
                    origin.getPersistentData().m_128379_("NoAI", true);
                }
                MinecraftForge.EVENT_BUS.post((Event)new NpcEvent.CreateEvent(view));
                if (freshEntity) {
                    origin.m_6021_(x, y, z);
                    this.world.m_7967_(origin);
                    MinecraftForge.EVENT_BUS.post((Event)new NpcEvent.JoinEvent(view, this.world));
                }
                this.npcViewMap.put(origin.m_20148_().toString(), view);
            } else {
                FreeEpicGames.LOGGER.error("NpcEntity {} already exists", (Object)origin.m_20149_());
            }
        } else {
            FreeEpicGames.LOGGER.error("Entity type {} not found", type.getEntityType());
        }
        return view;
    }

    public boolean deleteNpc(UUID id) {
        if (this.npcViewMap.get(id.toString()) != null) {
            this.npcViewMap.remove(id.toString());
            return true;
        }
        return false;
    }

    @Nullable
    public NpcView getNpcView(String id) {
        return this.npcViewMap.get(id);
    }

    @Override
    public void load() {
        this.isReinforceMode = DataUtils.getValue(this.optionData, "is_reinforce_mode", false);
        this.npcData.keySet().forEach(id -> {
            NpcView view = new NpcView(this.npcData.getAsJsonObject(id), this);
            if (view.getOriginEntity() == null) {
                this.npcViewMap.put((String)id, view);
            }
        });
    }

    @Override
    public void save() {
        this.optionData.addProperty("is_reinforce_mode", Boolean.valueOf(this.isReinforceMode));
        DataUtils.computeViewMap(this.npcViewMap, this.npcData);
    }

    public static void expire() {
        instances.clear();
    }

    public boolean isReinforceMode() {
        return this.isReinforceMode;
    }

    public void setReinforceMode(boolean isReinforceMode) {
        this.isReinforceMode = isReinforceMode;
    }
}

