/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.storage.type;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.thexeler.freeepicgames.FreeEpicGames;
import org.thexeler.freeepicgames.storage.utils.DataPacket;
import org.thexeler.freeepicgames.storage.utils.DataUtils;

public class ChestMenuType {
    private static final Map<String, ChestMenuType> types = Collections.synchronizedMap(new HashMap());
    private final String name;
    private final int size;
    private final Map<ItemStack, String> items;
    private final Container container;

    public ChestMenuType(String name, int size, Map<ItemStack, String> items) {
        this.name = name;
        this.size = size;
        this.items = items;
        this.container = new SimpleContainer(size);
    }

    public JsonObject toJson() {
        JsonObject menuData = new JsonObject();
        menuData.addProperty("size", (Number)this.size);
        menuData.add("items", (JsonElement)new JsonArray());
        this.items.forEach((item, itemCmd) -> {
            JsonObject specialObject = DataUtils.fromItemStack(item);
            specialObject.addProperty("command", itemCmd);
            menuData.getAsJsonArray("items").add((JsonElement)specialObject);
        });
        return menuData;
    }

    public static boolean register(String name, JsonObject object) {
        if (!types.containsKey(name)) {
            Map<ItemStack, String> items = Collections.synchronizedMap(new HashMap());
            JsonArray itemsJson = DataUtils.getValue(object, "items", new JsonArray());
            itemsJson.asList().forEach(element -> {
                ItemStack stack = DataUtils.toItemStack(element.getAsJsonObject());
                items.computeIfAbsent(stack, i -> DataUtils.getValue(element.getAsJsonObject(), "command", ""));
            });
            types.put(name, new ChestMenuType(name, DataUtils.getValue(object, "size", 27), items));
            return true;
        }
        FreeEpicGames.LOGGER.error("Repeated registration key : {}", (Object)name);
        return false;
    }

    public static boolean unregister(String name) {
        if (types.containsKey(name)) {
            types.remove(name);
            return true;
        }
        return false;
    }

    public static List<ChestMenuType> getAllType() {
        return new ArrayList<ChestMenuType>(types.values());
    }

    public static List<String> getAllTypeName() {
        return new ArrayList<String>(types.keySet());
    }

    @Nullable
    public static ChestMenuType getType(String name) {
        return types.get(name);
    }

    public static void init() {
        FreeEpicGames.LOGGER.info("Registering ChestMenuTypes...");
        DataUtils.getPackAllData(DataPacket.CHEST_MENU_TYPE).forEach(ChestMenuType::register);
        FreeEpicGames.LOGGER.info("Registered {} ChestMenuTypes.", (Object)types.size());
    }

    public static void expire() {
        FreeEpicGames.LOGGER.info("Saving ChestMenuTypes...");
        HashMap<String, JsonObject> jsonMap = new HashMap<String, JsonObject>();
        types.forEach((name, type) -> jsonMap.put((String)name, type.toJson()));
        FreeEpicGames.LOGGER.info("Expiring ChestMenuTypes...");
        DataUtils.savePacketAllData(DataPacket.CHEST_MENU_TYPE, jsonMap);
        types.clear();
        FreeEpicGames.LOGGER.info("Expired ChestMenuTypes.");
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public Container getContainer() {
        return this.container;
    }
}

