/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.storage.type;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.Nullable;
import org.thexeler.freeepicgames.FreeEpicGames;
import org.thexeler.freeepicgames.storage.utils.DataPacket;
import org.thexeler.freeepicgames.storage.utils.DataUtils;

public class NpcType {
    private static final Map<String, NpcType> types = new HashMap<String, NpcType>();
    private final String name;
    private final EntityType<?> entityType;
    private final boolean isInvulnerable;
    private final boolean isInvisible;
    private final boolean isNoGravity;
    private final boolean isNoAI;
    private boolean isWeakAI;
    @Nullable
    private final ResourceKey<LootTable> lootTable;

    private NpcType(String name, EntityType<?> type, boolean isInvulnerable, boolean isInvisible, boolean isNoGravity, boolean isNoAI, boolean isWeakAI, @Nullable ResourceKey<LootTable> lootTable) {
        this.name = name;
        this.entityType = type;
        this.isInvulnerable = isInvulnerable;
        this.isInvisible = isInvisible;
        this.isNoGravity = isNoGravity;
        this.isNoAI = isNoAI;
        this.isWeakAI = isWeakAI;
        this.lootTable = lootTable;
    }

    private JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("base_id", BuiltInRegistries.f_256780_.m_7981_(this.entityType).toString());
        jsonObject.addProperty("is_invulnerable", Boolean.valueOf(this.isInvulnerable));
        jsonObject.addProperty("is_invisible", Boolean.valueOf(this.isInvisible));
        jsonObject.addProperty("is_no_gravity", Boolean.valueOf(this.isNoGravity));
        jsonObject.addProperty("is_no_ai", Boolean.valueOf(this.isNoAI));
        jsonObject.addProperty("is_weak_ai", Boolean.valueOf(this.isWeakAI));
        if (this.lootTable != null) {
            jsonObject.addProperty("loot_table", this.lootTable.toString());
        }
        return jsonObject;
    }

    public static boolean register(String name, JsonObject object) {
        if (!types.containsKey(name)) {
            String typeURI = object.get("base_id").getAsString();
            Optional typeOptional = EntityType.m_20632_((String)typeURI);
            if (typeOptional.isPresent()) {
                String lootTableKey = DataUtils.getValue(object, "loot_table", "");
                types.put(name, new NpcType(name, (EntityType)typeOptional.get(), DataUtils.getValue(object, "is_invulnerable", true), DataUtils.getValue(object, "is_invisible", true), DataUtils.getValue(object, "is_no_gravity", true), DataUtils.getValue(object, "is_no_ai", true), DataUtils.getValue(object, "is_weak_ai", false), null));
                return true;
            }
            FreeEpicGames.LOGGER.error("Unknow entity type from URI : {}", (Object)typeURI);
        } else {
            FreeEpicGames.LOGGER.error("Repeated registration key : {}", (Object)name);
        }
        return false;
    }

    public static boolean unregister(String name) {
        if (types.containsKey(name)) {
            types.remove(name);
            FreeEpicGames.LOGGER.info("Unregistered npc type : {}", (Object)name);
            return true;
        }
        FreeEpicGames.LOGGER.error("Unregister failed : {}", (Object)name);
        return false;
    }

    public static List<NpcType> getAllType() {
        return new ArrayList<NpcType>(types.values());
    }

    public static List<String> getAllTypeName() {
        return new ArrayList<String>(types.keySet());
    }

    @Nullable
    public static NpcType getType(String name) {
        return types.get(name);
    }

    public static void init() {
        FreeEpicGames.LOGGER.info("Loading Npc types...");
        DataUtils.getPackAllData(DataPacket.NPC_TYPE).forEach(NpcType::register);
        FreeEpicGames.LOGGER.info("Loaded {} Npc types", (Object)types.size());
    }

    public static void expire() {
        NpcType.expire(false);
    }

    public static void expire(boolean forced) {
        if (!forced) {
            FreeEpicGames.LOGGER.info("Saving Npc types...");
            HashMap<String, JsonObject> jsonMap = new HashMap<String, JsonObject>();
            types.forEach((name, type) -> jsonMap.put((String)name, type.toJson()));
            DataUtils.savePacketAllData(DataPacket.NPC_TYPE, jsonMap);
        }
        FreeEpicGames.LOGGER.info("Expiring Npc types...");
        types.clear();
        FreeEpicGames.LOGGER.info("Expired Npc types");
    }

    public String getName() {
        return this.name;
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    public boolean isInvulnerable() {
        return this.isInvulnerable;
    }

    public boolean isInvisible() {
        return this.isInvisible;
    }

    public boolean isNoGravity() {
        return this.isNoGravity;
    }

    public boolean isNoAI() {
        return this.isNoAI;
    }

    public boolean isWeakAI() {
        return this.isWeakAI;
    }

    public void setWeakAI(boolean isWeakAI) {
        this.isWeakAI = isWeakAI;
    }

    @Nullable
    public ResourceKey<LootTable> getLootTable() {
        return this.lootTable;
    }
}

