/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.storage.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.thexeler.freeepicgames.storage.agent.AbstractWorldDataAgent;
import org.thexeler.freeepicgames.storage.agent.JobDataAgent;
import org.thexeler.freeepicgames.storage.agent.RaidDataAgent;

public class ModSavedData
extends SavedData {
    private static ModSavedData instance = null;
    private final Map<String, JsonObject> globalDataMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<String, JsonObject>> worldDataMap = Collections.synchronizedMap(new HashMap());
    private final List<AbstractWorldDataAgent> worldAgentList = Collections.synchronizedList(new ArrayList());

    private ModSavedData() {
        instance = this;
    }

    public static JsonObject getGlobalData(String id) {
        return ModSavedData.instance.globalDataMap.computeIfAbsent(id, key -> new JsonObject());
    }

    public static JsonObject getWorldData(ServerLevel world, String id) {
        return ModSavedData.instance.worldDataMap.computeIfAbsent(world.m_46472_().toString(), key -> Collections.synchronizedMap(new HashMap())).computeIfAbsent(id, key -> new JsonObject());
    }

    public static void register(@NotNull AbstractWorldDataAgent agent) {
        if (!ModSavedData.instance.worldAgentList.contains(agent)) {
            ModSavedData.instance.worldAgentList.add(agent);
        }
    }

    public static ModSavedData create() {
        return new ModSavedData();
    }

    public static ModSavedData load(CompoundTag compoundTag) {
        Gson gson = new Gson();
        ModSavedData savedData = ModSavedData.create();
        CompoundTag globalTag = compoundTag.m_128469_("Global");
        CompoundTag worldsTag = compoundTag.m_128469_("Worlds");
        if (!globalTag.m_128456_()) {
            globalTag.m_128431_().forEach(key -> {
                Tag tag = globalTag.m_128423_(key);
                if (tag instanceof StringTag) {
                    savedData.globalDataMap.put((String)key, (JsonObject)gson.fromJson(tag.m_7916_(), JsonObject.class));
                }
            });
        }
        if (!worldsTag.m_128456_()) {
            worldsTag.m_128431_().forEach(key -> {
                Map worldData = savedData.worldDataMap.computeIfAbsent((String)key, k -> new HashMap());
                CompoundTag worldTag = worldsTag.m_128469_(key);
                if (!worldTag.m_128456_()) {
                    worldTag.m_128431_().forEach(key2 -> {
                        Tag tag = worldTag.m_128423_(key2);
                        if (tag instanceof StringTag) {
                            worldData.put(key2, (JsonObject)gson.fromJson(tag.m_7916_(), JsonObject.class));
                        }
                    });
                }
                savedData.worldDataMap.put((String)key, worldData);
            });
        }
        return savedData;
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag compoundTag) {
        JobDataAgent.getInstance().save();
        RaidDataAgent.getInstance().save();
        this.worldAgentList.forEach(AbstractWorldDataAgent::save);
        Gson gson = new Gson();
        CompoundTag globalTag = new CompoundTag();
        CompoundTag worldsTag = new CompoundTag();
        this.globalDataMap.forEach((key, value) -> globalTag.m_128365_(key, (Tag)StringTag.m_129297_((String)gson.toJson((JsonElement)value))));
        this.worldDataMap.forEach((key, value) -> {
            CompoundTag worldTag = new CompoundTag();
            value.forEach((key2, value2) -> worldTag.m_128365_(key2, (Tag)StringTag.m_129297_((String)gson.toJson((JsonElement)value2))));
            worldsTag.m_128365_(key, (Tag)worldTag);
        });
        compoundTag.m_128365_("Global", (Tag)globalTag);
        compoundTag.m_128365_("Worlds", (Tag)worldsTag);
        return compoundTag;
    }

    public boolean m_77764_() {
        return true;
    }
}

