/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.storage.view;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.thexeler.freeepicgames.storage.agent.NpcWorldDataAgent;
import org.thexeler.freeepicgames.storage.type.NpcType;
import org.thexeler.freeepicgames.storage.utils.DataUtils;
import org.thexeler.freeepicgames.storage.view.AbstractView;
import org.thexeler.mind.MindMachine;

public class NpcView
implements AbstractView {
    private final NpcWorldDataAgent rootAgent;
    private final UUID id;
    private final NpcType npcType;
    private final Entity originEntity;
    private final HashMap<String, String> npcData;
    private final MindMachine mind;

    public NpcView(@NotNull Entity originEntity, NpcType type, NpcWorldDataAgent agent) {
        this.rootAgent = agent;
        this.originEntity = originEntity;
        this.id = originEntity.m_20148_();
        this.npcType = type;
        this.rootAgent.getAllNpc();
        this.npcData = new HashMap();
        this.mind = new MindMachine(originEntity);
    }

    public NpcView(JsonObject object, NpcWorldDataAgent agent) {
        this.rootAgent = agent;
        this.id = UUID.fromString(DataUtils.getValue(object, "id", ""));
        this.npcType = NpcType.getType(DataUtils.getValue(object, "type", ""));
        this.originEntity = agent.getWorld().m_8791_(this.id);
        this.npcData = new HashMap();
        this.mind = new MindMachine(this.originEntity);
    }

    public String getName() {
        return this.originEntity.m_7755_().getString();
    }

    public void discard() {
        this.discardAdditional();
        if (this.originEntity != null) {
            this.originEntity.m_146870_();
        }
    }

    public void discardAdditional() {
        this.rootAgent.deleteNpc(this.id);
    }

    public static NpcView getEntity(Entity entity) {
        Level level;
        if (entity != null && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            return NpcView.getEntity(level2, entity.m_20149_());
        }
        return null;
    }

    public static NpcView getEntity(ServerLevel level, UUID uuid) {
        return NpcView.getEntity(level, uuid.toString());
    }

    public static NpcView getEntity(ServerLevel level, String id) {
        return NpcWorldDataAgent.getInstance(level).getNpcView(id);
    }

    @Override
    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("id", this.id.toString());
        jsonObject.addProperty("type", this.npcType.getName());
        JsonObject npcDataJson = new JsonObject();
        this.npcData.forEach((arg_0, arg_1) -> ((JsonObject)npcDataJson).addProperty(arg_0, arg_1));
        jsonObject.add("npc_data", (JsonElement)npcDataJson);
        return jsonObject;
    }

    public UUID getId() {
        return this.id;
    }

    public NpcType getNpcType() {
        return this.npcType;
    }

    public Entity getOriginEntity() {
        return this.originEntity;
    }

    public HashMap<String, String> getNpcData() {
        return this.npcData;
    }

    public MindMachine getMind() {
        return this.mind;
    }
}

