/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.utils.chestmenu;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.thexeler.freeepicgames.FreeEpicGamesConfigs;
import org.thexeler.freeepicgames.events.MenuEvent;
import org.thexeler.freeepicgames.utils.chestmenu.ChestMenuListener;
import org.thexeler.slacker.SlackerForge;

public class EventChestMenu
extends AbstractContainerMenu {
    private final Container container;
    private final int containerRows;
    private final Map<String, ChestMenuListener> listeners;

    public static EventChestMenu SmallMenu(int containerId, Player player, Container container) {
        return new EventChestMenu(MenuType.f_39959_, containerId, player, container, 3);
    }

    public static EventChestMenu LargeMenu(int containerId, Player player, Container container) {
        return new EventChestMenu(MenuType.f_39962_, containerId, player, container, 6);
    }

    protected EventChestMenu(MenuType<?> type, int containerId, Player player, Container container, int rows) {
        super(type, containerId);
        if (FreeEpicGamesConfigs.isEnabledChestMenuPostEventBus) {
            SlackerForge.EVENT_BUS.post(new MenuEvent.CreateEvent(player, containerId, this));
        }
        this.container = container;
        this.containerRows = rows;
        this.listeners = new HashMap<String, ChestMenuListener>();
        container.m_5856_(player);
        int i = (this.containerRows - 4) * 18;
        for (int j = 0; j < this.containerRows; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.m_38897_(new Slot(container, k + j * 9, 8 + k * 18, 18 + j * 18));
            }
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.m_38897_(new Slot((Container)player.m_150109_(), j1 + l * 9 + 9, 8 + j1 * 18, 103 + l * 18 + i));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.m_38897_(new Slot((Container)player.m_150109_(), i1, 8 + i1 * 18, 161 + i));
        }
        if (FreeEpicGamesConfigs.isEnabledChestMenuPostEventBus) {
            SlackerForge.EVENT_BUS.post(new MenuEvent.OpenedEvent(player, containerId, this));
        }
    }

    public void registerListener(ClickType type, String key, ChestMenuListener listener) {
        this.listeners.put(key, listener);
    }

    public void unregisterListener(ClickType type, String key) {
        this.listeners.remove(key);
    }

    public boolean m_6875_(@NotNull Player player) {
        return this.container.m_6542_(player);
    }

    public void m_150399_(int slotId, int button, @NotNull ClickType clickType, @NotNull Player player) {
        this.listeners.forEach((key, listener) -> listener.onClick(clickType, slotId));
        boolean isCanceled = true;
        if (FreeEpicGamesConfigs.isEnabledChestMenuPostEventBus) {
            isCanceled = SlackerForge.EVENT_BUS.post(new MenuEvent.ClickEvent(player, slotId, clickType, this)).isCanceled();
        }
        if (!isCanceled) {
            super.m_150399_(slotId, button, clickType, player);
        }
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        Slot slot;
        ItemStack itemstack = ItemStack.f_41583_;
        this.listeners.forEach((key, listener) -> listener.onClick(ClickType.QUICK_MOVE, index));
        boolean isCanceled = true;
        if (FreeEpicGamesConfigs.isEnabledChestMenuPostEventBus) {
            isCanceled = SlackerForge.EVENT_BUS.post(new MenuEvent.ClickEvent(player, index, ClickType.QUICK_MOVE, this)).isCanceled();
        }
        if (!isCanceled && (slot = (Slot)this.f_38839_.get(index)).m_6657_()) {
            ItemStack itemStack1 = slot.m_7993_();
            itemstack = itemStack1.m_41777_();
            if (index < this.containerRows * 9 ? !this.m_38903_(itemStack1, this.containerRows * 9, this.f_38839_.size(), true) : !this.m_38903_(itemStack1, 0, this.containerRows * 9, false)) {
                return ItemStack.f_41583_;
            }
            if (itemStack1.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void m_6877_(@NotNull Player player) {
        this.listeners.forEach((key, listener) -> listener.onClose());
        if (FreeEpicGamesConfigs.isEnabledChestMenuPostEventBus) {
            SlackerForge.EVENT_BUS.post(new MenuEvent.CloseEvent(player, this.f_38840_, this));
        }
        super.m_6877_(player);
        this.container.m_5785_(player);
    }

    public Container getContainer() {
        return this.container;
    }

    public int getContainerRows() {
        return this.containerRows;
    }
}

