/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames;

import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ChestMenu;
import org.thexeler.freeepicgames.FreeEpicGames;

public class FreeEpicGamesUtils {

    public static class ChestInterfaceHelper {
        public static void openVirtualChest(ServerPlayer player, Container container) {
            ChestInterfaceHelper.openVirtualChest(player, container, "");
        }

        public static MenuProvider getMenuProvider(Container container) {
            return ChestInterfaceHelper.getMenuProvider(container, "");
        }

        public static MenuProvider getMenuProvider(Container container, String title) {
            return ChestInterfaceHelper.getMenuProvider(container, (Component)Component.literal((String)title));
        }

        public static MenuProvider getMenuProvider(Container container, Component title) {
            return new SimpleMenuProvider((ci, i, p) -> ChestMenu.threeRows((int)ci, (Inventory)i, (Container)container), title);
        }

        public static void openVirtualChest(ServerPlayer player, Container container, String title) {
            switch (container.getContainerSize()) {
                case 27: {
                    player.closeContainer();
                    player.openMenu((MenuProvider)new SimpleMenuProvider((ci, i, p) -> ChestMenu.threeRows((int)ci, (Inventory)i, (Container)container), (Component)Component.literal((String)title)));
                    break;
                }
                case 54: {
                    player.closeContainer();
                    player.openMenu((MenuProvider)new SimpleMenuProvider((ci, i, p) -> ChestMenu.sixRows((int)ci, (Inventory)i, (Container)container), (Component)Component.literal((String)title)));
                    break;
                }
                default: {
                    FreeEpicGames.LOGGER.warn("Virtual chest size is not supported. (Please use 27/54 size container)");
                }
            }
        }

        public static void openChestMenu(ServerPlayer player, Container container) {
            ChestInterfaceHelper.openChestMenu(player, container, "");
        }

        public static void openChestMenu(ServerPlayer player, Container container, String title) {
            switch (container.getContainerSize()) {
                case 27: {
                    player.closeContainer();
                    player.openMenu((MenuProvider)new SimpleMenuProvider((ci, i, p) -> ChestMenu.threeRows((int)ci, (Inventory)i, (Container)container), (Component)Component.literal((String)title)));
                    break;
                }
                case 54: {
                    player.closeContainer();
                    player.openMenu((MenuProvider)new SimpleMenuProvider((ci, i, p) -> ChestMenu.sixRows((int)ci, (Inventory)i, (Container)container), (Component)Component.literal((String)title)));
                    break;
                }
                default: {
                    FreeEpicGames.LOGGER.warn("Chest menu size is not supported. (Please use 27/54 size container)");
                }
            }
        }
    }
}

