/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.database.type;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.thexeler.freeepicgames.FreeEpicGames;
import org.thexeler.freeepicgames.database.untils.DataPacket;
import org.thexeler.freeepicgames.database.untils.DataUtils;

public class JobType {
    private static final Map<String, JobType> types = Collections.synchronizedMap(new HashMap());
    private final String name;
    private final Map<Item, Map<Tag, Integer>> jobItems;

    public JobType(String name, Map<Item, Map<Tag, Integer>> jobItems) {
        this.name = name;
        this.jobItems = jobItems;
    }

    public void setItem(ItemStack stack) {
        this.setItem(stack, stack.getCount());
    }

    public void setItem(ItemStack stack, int num) {
        Item item = stack.getItem();
        Tag nbt = DataUtils.encodeForTag(DataComponentPatch.CODEC, stack.getComponentsPatch());
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        Map itemInfo = this.jobItems.computeIfAbsent(item, k -> Collections.synchronizedMap(new HashMap()));
        itemInfo.put(nbt, num);
    }

    public void removeItem(ItemStack stack) {
        Item item = stack.getItem();
        Tag nbt = DataUtils.encodeForTag(DataComponentPatch.CODEC, stack.getComponentsPatch());
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        if (this.jobItems.get(item) != null && this.jobItems.get(item).get(nbt) != null) {
            this.jobItems.get(item).remove(nbt);
        }
        if (this.jobItems.get(item).isEmpty()) {
            this.jobItems.remove(item);
        }
    }

    public List<ItemStack> getAllItems() {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        if (this.jobItems != null && !this.jobItems.isEmpty()) {
            this.jobItems.forEach((item, value) -> value.forEach((nbt, count) -> itemStacks.add(DataUtils.toItemStack(item, count, (DataComponentPatch)DataUtils.decode(DataComponentPatch.CODEC, nbt)))));
        }
        return itemStacks;
    }

    public JsonObject toJson() {
        JsonObject jobData = new JsonObject();
        jobData.add("items", (JsonElement)new JsonArray());
        this.jobItems.forEach((item, itemInfo) -> itemInfo.forEach((nbt, num) -> jobData.getAsJsonArray("items").add((JsonElement)DataUtils.fromItemStack(item, num, (DataComponentPatch)DataUtils.decode(DataComponentPatch.CODEC, nbt)))));
        return jobData;
    }

    public static boolean register(String name, JsonObject object) {
        if (!types.containsKey(name)) {
            Map<Item, Map<Tag, Integer>> items = Collections.synchronizedMap(new HashMap());
            JsonArray itemsJson = DataUtils.getValue(object, "items", new JsonArray());
            itemsJson.asList().forEach(element -> {
                ItemStack stack = DataUtils.toItemStack(element.getAsJsonObject());
                items.computeIfAbsent(stack.getItem(), i -> Collections.synchronizedMap(new HashMap())).put(DataUtils.encodeForTag(DataComponentPatch.CODEC, stack.getComponentsPatch()), stack.getCount());
            });
            types.put(name, new JobType(name, items));
            return true;
        }
        FreeEpicGames.LOGGER.error("Repeated registration key : " + name);
        return false;
    }

    public static boolean unregister(String name) {
        if (types.containsKey(name)) {
            types.remove(name);
            return true;
        }
        return false;
    }

    public static List<JobType> getAllType() {
        return new ArrayList<JobType>(types.values());
    }

    public static List<String> getAllTypeName() {
        return new ArrayList<String>(types.keySet());
    }

    @Nullable
    public static JobType getType(String name) {
        return types.get(name);
    }

    public static void init() {
        FreeEpicGames.LOGGER.info("Registering JobTypes...");
        DataUtils.getPackAllData(DataPacket.JOB_TYPE).forEach(JobType::register);
        FreeEpicGames.LOGGER.info("Registered {} JobTypes.", (Object)types.size());
    }

    public static void expire() {
        FreeEpicGames.LOGGER.info("Saving JobTypes...");
        HashMap<String, JsonObject> jsonMap = new HashMap<String, JsonObject>();
        types.forEach((name, type) -> jsonMap.put((String)name, type.toJson()));
        DataUtils.savePacketAllData(DataPacket.JOB_TYPE, jsonMap);
        FreeEpicGames.LOGGER.info("Expiring JobTypes...");
        types.clear();
        FreeEpicGames.LOGGER.info("Expired JobTypes.");
    }

    public String getName() {
        return this.name;
    }
}

