/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.handler;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.thexeler.freeepicgames.FreeEpicGames;
import org.thexeler.freeepicgames.FreeEpicGamesConfigs;
import org.thexeler.freeepicgames.database.agent.GlobalJobDataAgent;
import org.thexeler.freeepicgames.database.type.JobType;

public class JobEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (FreeEpicGamesConfigs.isEnabledJob && (livingEntity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            player.getInventory().clearContent();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player;
        if (FreeEpicGamesConfigs.isEnabledJob && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            GlobalJobDataAgent agent = GlobalJobDataAgent.getInstance();
            JobType type = JobType.getType(agent.getPlayerJob(player2));
            if (type != null) {
                type.getAllItems().forEach(stack -> {
                    EquipmentSlot slot = player2.getEquipmentSlotForItem(stack);
                    if (player2.getItemBySlot(slot).isEmpty()) {
                        player2.getInventory().add(stack);
                    } else {
                        switch (slot) {
                            case HEAD: 
                            case CHEST: 
                            case LEGS: 
                            case FEET: {
                                player2.onEquipItem(slot, player2.getItemBySlot(slot), stack);
                                break;
                            }
                            default: {
                                player2.getInventory().add(stack);
                            }
                        }
                    }
                });
            } else {
                agent.setPlayerJob(player2, "");
            }
        }
    }

    @SubscribeEvent
    public void onItemUse(LivingEntityUseItemEvent event) {
        LivingEntity livingEntity;
        if (FreeEpicGamesConfigs.isEnabledJob && (livingEntity = event.getEntity()) instanceof ServerPlayer) {
            String customCommand;
            ServerPlayer player = (ServerPlayer)livingEntity;
            CustomData data = (CustomData)event.getItem().getComponents().get(DataComponents.CUSTOM_DATA);
            if (data != null && data.contains("custom_command") && !(customCommand = data.copyTag().getString("custom_command")).isEmpty()) {
                try {
                    player.server.getCommands().getDispatcher().execute(customCommand, (Object)player.server.createCommandSourceStack());
                }
                catch (CommandSyntaxException e) {
                    FreeEpicGames.LOGGER.error(e.getMessage());
                }
            }
        }
    }
}

