/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.lamp.parameters;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.thexeler.lamp.actor.ForgeCommandActor;
import org.thexeler.lamp.exception.EmptyEntitySelectorException;
import org.thexeler.lamp.exception.MalformedEntitySelectorException;
import org.thexeler.lamp.exception.MoreThanOneEntityException;
import org.thexeler.lamp.exception.NonPlayerEntitiesException;
import revxrsal.commands.autocomplete.SuggestionProvider;
import revxrsal.commands.exception.CommandErrorException;
import revxrsal.commands.node.ExecutionContext;
import revxrsal.commands.parameter.ParameterType;
import revxrsal.commands.stream.MutableStringStream;

public final class ServerPlayerParameterType
implements ParameterType<ForgeCommandActor, ServerPlayer> {
    @NotNull
    private static ServerPlayer fromSelector(@NotNull CommandSourceStack sender, @NotNull String selectorString) {
        try {
            EntitySelector selector = new EntitySelectorParser(new StringReader(selectorString)).getSelector();
            List entityList = selector.findPlayers(sender);
            if (entityList.isEmpty()) {
                throw new EmptyEntitySelectorException(selectorString);
            }
            if (entityList.size() != 1) {
                throw new MoreThanOneEntityException(selectorString);
            }
            Entity entity = (Entity)entityList.get(0);
            if (!(entity instanceof ServerPlayer)) {
                throw new NonPlayerEntitiesException(selectorString);
            }
            ServerPlayer player = (ServerPlayer)entity;
            return player;
        }
        catch (IllegalArgumentException e) {
            throw new MalformedEntitySelectorException(selectorString, e.getCause().getMessage());
        }
        catch (CommandSyntaxException e) {
            throw new CommandErrorException(e.getCause().getMessage(), new Object[0]);
        }
        catch (NoSuchMethodError e) {
            throw new CommandErrorException("Entity selectors on legacy versions are not supported yet!", new Object[0]);
        }
    }

    @Override
    public ServerPlayer parse(@NotNull MutableStringStream input, @NotNull @NotNull ExecutionContext<@NotNull ForgeCommandActor> context) {
        String value = input.readString();
        return ServerPlayerParameterType.fromSelector(context.actor().source(), value);
    }

    @Override
    @NotNull
    public @NotNull SuggestionProvider<@NotNull ForgeCommandActor> defaultSuggestions() {
        return SuggestionProvider.empty();
    }
}

