/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.mind;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.world.entity.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thexeler.mind.intention.Intention;
import org.thexeler.mind.intention.IntentionPriority;
import org.thexeler.mind.intention.IntentionType;

public class MindMachine {
    private static final Logger log = LoggerFactory.getLogger(MindMachine.class);
    private final Entity origin;
    private final int stepTick;
    private int tickCount;
    private final List<Intention> intentions;

    public MindMachine(Entity origin) {
        this.origin = origin;
        this.stepTick = 5;
        this.tickCount = 0;
        this.intentions = Collections.synchronizedList(new LinkedList());
        this.intentions.add(new Intention.SimpleIntention(this, origin, IntentionType.IDLE, IntentionPriority.LOWEST){

            @Override
            public boolean execute() {
                return false;
            }
        });
    }

    public void addIntention(Intention intention) {
        if (intention.getPriority() == IntentionPriority.URGENT) {
            this.intentions.addFirst(intention);
        } else {
            ListIterator<Intention> i = this.intentions.listIterator();
            while (i.hasNext()) {
                Intention current = i.next();
                if (intention.getPriority().biggerThan(current.getPriority())) continue;
                i.previous();
                i.add(intention);
                return;
            }
            this.intentions.add(intention);
        }
    }

    public void tick() {
        ++this.tickCount;
        if (this.tickCount >= this.stepTick) {
            this.tickCount -= this.stepTick;
            this.step();
        }
    }

    private void step() {
        Intention intention = this.intentions.getFirst();
        if (intention != null && intention.getType() != IntentionType.IDLE) {
            if (intention.execute() && intention.getType() != IntentionType.IDLE) {
                this.intentions.removeFirst();
            }
            this.intentions.forEach(i -> {
                if (i != intention) {
                    i.hold();
                }
            });
            this.intentions.sort((i1, i2) -> i2.getPriority().compareTo(i1.getPriority()));
        }
    }

    public boolean interrupt() {
        if (this.intentions.size() > 1) {
            this.intentions.removeFirst();
            return true;
        }
        return false;
    }

    public Entity getOrigin() {
        return this.origin;
    }

    public int getStepTick() {
        return this.stepTick;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public void setTickCount(int tickCount) {
        this.tickCount = tickCount;
    }
}

