/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.events;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import org.thexeler.freeepicgames.database.view.NpcView;

public abstract class NpcEvent
extends Event {
    private final Entity entity;
    private final NpcView view;

    public NpcEvent(NpcView npc) {
        this.entity = npc.getOriginEntity();
        this.view = npc;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public NpcView getView() {
        return this.view;
    }

    public static abstract class RangeAttack
    extends NpcEvent {
        private final Projectile projectile;

        public RangeAttack(NpcView npc, Projectile projectile) {
            super(npc);
            this.projectile = projectile;
        }

        public Projectile getProjectile() {
            return this.projectile;
        }

        public static class HitEvent
        extends RangeAttack
        implements ICancellableEvent {
            private final HitResult hitResult;
            private final Entity target;

            public HitEvent(NpcView npc, Projectile projectile, HitResult hitResult, Entity target) {
                super(npc, projectile);
                this.hitResult = hitResult;
                this.target = target;
            }

            public HitResult getHitResult() {
                return this.hitResult;
            }

            public Entity getTarget() {
                return this.target;
            }
        }

        public static class FireEvent
        extends RangeAttack {
            public FireEvent(NpcView npc, Projectile projectile) {
                super(npc, projectile);
            }
        }
    }

    public static class MeleeAttackEvent
    extends NpcEvent {
        private final Entity target;
        private final DamageSource source;
        private float amount;
        private final DamageContainer container;

        public MeleeAttackEvent(NpcView npc, Entity target, DamageSource source, float amount, DamageContainer container) {
            super(npc);
            this.target = target;
            this.source = source;
            this.amount = amount;
            this.container = container;
        }

        public Entity getTarget() {
            return this.target;
        }

        public DamageSource getSource() {
            return this.source;
        }

        public float getAmount() {
            return this.amount;
        }

        public void setAmount(float amount) {
            this.amount = amount;
        }

        public DamageContainer getContainer() {
            return this.container;
        }
    }

    public static class KilledEvent
    extends NpcEvent
    implements ICancellableEvent {
        private final Entity entity;
        private final DamageSource source;

        public KilledEvent(NpcView npc, Entity entity, DamageSource source) {
            super(npc);
            this.entity = entity;
            this.source = source;
        }

        @Override
        public Entity getEntity() {
            return this.entity;
        }

        public DamageSource getSource() {
            return this.source;
        }
    }

    public static class TickEvent
    extends NpcEvent {
        public TickEvent(NpcView npc) {
            super(npc);
        }
    }

    public static class DamageEvent
    extends NpcEvent
    implements ICancellableEvent {
        private final DamageSource source;
        private float amount;
        private final DamageContainer container;

        public DamageEvent(NpcView npc, DamageSource source, float amount, DamageContainer container) {
            super(npc);
            this.source = source;
            this.amount = amount;
            this.container = container;
        }

        public DamageSource getSource() {
            return this.source;
        }

        public float getAmount() {
            return this.amount;
        }

        public void setAmount(float amount) {
            this.amount = amount;
        }

        public DamageContainer getContainer() {
            return this.container;
        }
    }

    public static class InteractEvent
    extends NpcEvent {
        private final Player player;

        public InteractEvent(NpcView npc, Player player) {
            super(npc);
            this.player = player;
        }

        public Player getPlayer() {
            return this.player;
        }
    }

    public static class DeathEvent
    extends NpcEvent
    implements ICancellableEvent {
        private final DamageSource source;

        public DeathEvent(NpcView npc, DamageSource source) {
            super(npc);
            this.source = source;
        }

        public DamageSource getSource() {
            return this.source;
        }
    }

    public static class JoinEvent
    extends NpcEvent {
        private final ServerLevel level;

        public JoinEvent(NpcView npc, ServerLevel level) {
            super(npc);
            this.level = level;
        }

        public ServerLevel getLevel() {
            return this.level;
        }
    }

    public static class CreateEvent
    extends NpcEvent {
        public CreateEvent(NpcView npc) {
            super(npc);
        }
    }
}

