/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.freeepicgames.handler;

import java.util.Collections;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.thexeler.freeepicgames.FreeEpicGames;
import org.thexeler.freeepicgames.FreeEpicGamesKeys;
import org.thexeler.freeepicgames.FreeEpicGamesUtils;
import org.thexeler.freeepicgames.database.agent.GlobalRaidDataAgent;
import org.thexeler.freeepicgames.database.type.RaidTreasureType;
import org.thexeler.freeepicgames.database.view.RaidInstanceView;
import org.thexeler.freeepicgames.events.RaidEvent;
import oshi.util.tuples.Pair;

public class RaidEventHandler {
    @SubscribeEvent
    public void onOpenContainer(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            RaidTreasureType treasure;
            GlobalRaidDataAgent agent;
            RaidInstanceView view;
            ServerPlayer player2 = (ServerPlayer)player;
            if (FreeEpicGames.RAID_WORLD.equals(event.getLevel()) && (view = (agent = GlobalRaidDataAgent.getInstance()).getRaidInstance(player2)) != null && (treasure = view.getTreasureType(event.getPos())) != null && !((RaidEvent.OpenTreasureEvent)NeoForge.EVENT_BUS.post((Event)new RaidEvent.OpenTreasureEvent(view, view.getTreasureContainer(player2, event.getPos()), player2))).isCanceled()) {
                Container container = view.getTreasureContainer(player2, event.getPos());
                MenuProvider provider = FreeEpicGamesUtils.ChestInterfaceHelper.getMenuProvider(container, treasure.getTitle());
                player2.openMenu(provider);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).level().equals(FreeEpicGames.RAID_WORLD)) {
            GlobalRaidDataAgent agent = GlobalRaidDataAgent.getInstance();
            RaidInstanceView view = agent.getRaidInstance(player);
            if (view != null) {
                view.respawn(player);
            } else {
                Pair<String, Vec3> backPosInfo = agent.getBackPos(player);
                ServerLevel level = FreeEpicGames.OVER_WORLD;
                if (backPosInfo != null) {
                    if (player.getServer() != null) {
                        level = player.getServer().getLevel(FreeEpicGamesKeys.parseWorldKey((String)backPosInfo.getA()));
                    }
                    if (level != null) {
                        player.teleportTo(level, ((Vec3)backPosInfo.getB()).x, ((Vec3)backPosInfo.getB()).y, ((Vec3)backPosInfo.getB()).z, Collections.emptySet(), 0.0f, 0.0f);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            GlobalRaidDataAgent agent = GlobalRaidDataAgent.getInstance();
            RaidInstanceView view = agent.getRaidInstance(player2);
            if (view != null && player2.getRespawnPosition() != null && view.isInside(player2.getRespawnPosition().getCenter())) {
                view.respawn(player2);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRaidTick(ServerTickEvent.Post event) {
        GlobalRaidDataAgent agent = GlobalRaidDataAgent.getInstance();
        agent.getAllRaidInstance().forEach(view -> NeoForge.EVENT_BUS.post((Event)new RaidEvent.TickEvent((RaidInstanceView)view)));
    }
}

