/*
 * Decompiled with CFR 0.152.
 */
package org.thexeler.lamp.annotations;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.thexeler.freeepicgames.FreeEpicGames;
import org.thexeler.lamp.actor.ForgeCommandActor;
import org.thexeler.lamp.annotations.WithTargetLocation;
import revxrsal.commands.Lamp;
import revxrsal.commands.annotation.list.AnnotationList;
import revxrsal.commands.autocomplete.SuggestionProvider;

public enum WithTargetLocationSuggestionFactory implements SuggestionProvider.Factory<ForgeCommandActor>
{
    INSTANCE;


    @Override
    @Nullable
    public SuggestionProvider<ForgeCommandActor> create(@NotNull Type type, @NotNull AnnotationList annotations, @NotNull Lamp<ForgeCommandActor> lamp) {
        if (annotations.get(WithTargetLocation.class) == null) {
            return null;
        }
        return context -> {
            ArrayList<Object> ret = new ArrayList<Object>();
            ServerPlayer player = ((ForgeCommandActor)context.actor()).requirePlayer();
            if (player != null) {
                BlockPos pos = BlockPos.containing((Position)player.pick(20.0, 0.0f, false).getLocation());
                try (Level level = player.level();){
                    if (!level.getBlockState(pos).isAir()) {
                        ret.add(String.valueOf(pos.getX()));
                        ret.add(pos.getX() + " " + pos.getY());
                        ret.add(pos.getX() + " " + pos.getY() + " " + pos.getZ());
                    }
                }
                catch (IOException e) {
                    FreeEpicGames.LOGGER.error(e.getMessage());
                }
            }
            return ret;
        };
    }
}

