/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.parameter.builtins;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.Lamp;
import revxrsal.commands.annotation.list.AnnotationList;
import revxrsal.commands.autocomplete.SuggestionProvider;
import revxrsal.commands.command.CommandActor;
import revxrsal.commands.exception.EnumNotFoundException;
import revxrsal.commands.node.ExecutionContext;
import revxrsal.commands.parameter.ParameterType;
import revxrsal.commands.parameter.PrioritySpec;
import revxrsal.commands.stream.MutableStringStream;
import revxrsal.commands.util.Classes;

@ApiStatus.Internal
public enum EnumParameterTypeFactory implements ParameterType.Factory<CommandActor>
{
    INSTANCE;


    @Override
    public <T> ParameterType<CommandActor, T> create(@NotNull Type parameterType, @NotNull AnnotationList annotations, @NotNull Lamp<CommandActor> lamp) {
        Class<?> rawType = Classes.getRawType(parameterType);
        if (!rawType.isEnum()) {
            return null;
        }
        Enum[] enumConstants = (Enum[])rawType.getEnumConstants();
        HashMap<String, Enum> byKeys = new HashMap<String, Enum>();
        ArrayList<String> suggestions = new ArrayList<String>();
        for (Enum enumConstant : enumConstants) {
            String name = enumConstant.name().toLowerCase();
            byKeys.put(name, enumConstant);
            suggestions.add(name);
        }
        return new EnumParameterType(byKeys, suggestions);
    }

    private static final class EnumParameterType<E extends Enum<E>>
    implements ParameterType<CommandActor, E> {
        private final Map<String, E> byKeys;
        private final List<String> suggestions;

        private EnumParameterType(Map<String, E> byKeys, List<String> suggestions) {
            this.byKeys = byKeys;
            this.suggestions = suggestions;
        }

        @Override
        public E parse(@NotNull MutableStringStream input, @NotNull ExecutionContext<CommandActor> context) {
            String key = input.readUnquotedString();
            Enum value = (Enum)this.byKeys.get(key.toLowerCase());
            if (value != null) {
                return (E)value;
            }
            throw new EnumNotFoundException(key);
        }

        @Override
        @NotNull
        public SuggestionProvider<CommandActor> defaultSuggestions() {
            return SuggestionProvider.of(this.suggestions);
        }

        @Override
        @NotNull
        public PrioritySpec parsePriority() {
            return PrioritySpec.highest();
        }

        public Map<String, E> byKeys() {
            return this.byKeys;
        }

        public List<String> suggestions() {
            return this.suggestions;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            EnumParameterType that = (EnumParameterType)obj;
            return Objects.equals(this.byKeys, that.byKeys) && Objects.equals(this.suggestions, that.suggestions);
        }

        public int hashCode() {
            return Objects.hash(this.byKeys, this.suggestions);
        }

        public String toString() {
            return "EnumParameterType[byKeys=" + this.byKeys + ", suggestions=" + this.suggestions + ']';
        }
    }
}

