/*
 * Decompiled with CFR 0.152.
 */
package net.snackbag.tt20.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.snackbag.tt20.TT20;

public class TPSUtil {
    private static final DecimalFormat df = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.ROOT));
    private static final DecimalFormat dfMissedTicks = new DecimalFormat("0.0000", DecimalFormatSymbols.getInstance(Locale.ROOT));

    public static String colorizeTPS(double tps, boolean format) {
        if (tps > 15.0) {
            return "\u00a7a" + String.valueOf(format ? TPSUtil.formatTPS(tps) : Double.valueOf(tps));
        }
        if (tps > 10.0) {
            return "\u00a7e" + String.valueOf(format ? TPSUtil.formatTPS(tps) : Double.valueOf(tps));
        }
        return "\u00a7c" + String.valueOf(format ? TPSUtil.formatTPS(tps) : Double.valueOf(tps));
    }

    public static String formatTPS(double tps) {
        return df.format(tps);
    }

    public static String formatMissedTicks(double missedTicks) {
        return dfMissedTicks.format(missedTicks);
    }

    public static float tt20(float ticks, boolean limitZero) {
        float newTicks = (float)TPSUtil.rawTT20(ticks);
        if (limitZero) {
            return newTicks > 0.0f ? newTicks : 1.0f;
        }
        return newTicks;
    }

    public static int tt20(int ticks, boolean limitZero) {
        int newTicks = (int)Math.ceil(TPSUtil.rawTT20(ticks));
        if (limitZero) {
            return newTicks > 0 ? newTicks : 1;
        }
        return newTicks;
    }

    public static double tt20(double ticks, boolean limitZero) {
        double newTicks = TPSUtil.rawTT20(ticks);
        if (limitZero) {
            return newTicks > 0.0 ? newTicks : 1.0;
        }
        return newTicks;
    }

    public static double rawTT20(double ticks) {
        return ticks == 0.0 ? 0.0 : ticks * TT20.TPS_CALCULATOR.getMostAccurateTPS() / 20.0;
    }
}

