/*
 * Decompiled with CFR 0.152.
 */
package net.snackbag.tt20.util;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;

public class TPSCalculator {
    public Long lastTick;
    public Long currentTick;
    private double allMissedTicks = 0.0;
    private final List<Double> tpsHistory = new CopyOnWriteArrayList<Double>();
    private static final int historyLimit = 40;
    public static final int MAX_TPS = 20;
    public static final int FULL_TICK = 50;

    public TPSCalculator() {
        ServerTickEvents.START_SERVER_TICK.register(server -> this.onTick());
    }

    private void onTick() {
        if (this.currentTick != null) {
            this.lastTick = this.currentTick;
        }
        this.currentTick = System.currentTimeMillis();
        this.addToHistory(this.getTPS());
        this.clearMissedTicks();
        this.missedTick();
    }

    private void addToHistory(double tps) {
        if (this.tpsHistory.size() >= 40) {
            this.tpsHistory.remove(0);
        }
        this.tpsHistory.add(tps);
    }

    public long getMSPT() {
        return this.currentTick - this.lastTick;
    }

    public double getAverageTPS() {
        return this.tpsHistory.stream().mapToDouble(Double::doubleValue).average().orElse(0.1);
    }

    public double getTPS() {
        if (this.lastTick == null) {
            return -1.0;
        }
        if (this.getMSPT() <= 0L) {
            return 0.1;
        }
        double tps = 1000.0 / (double)this.getMSPT();
        return tps > 20.0 ? 20.0 : tps;
    }

    public void missedTick() {
        if (this.lastTick == null) {
            return;
        }
        long mspt = this.getMSPT() <= 0L ? 50L : this.getMSPT();
        double missedTicks = (double)mspt / 50.0 - 1.0;
        this.allMissedTicks += missedTicks <= 0.0 ? 0.0 : missedTicks;
    }

    public double getMostAccurateTPS() {
        return this.getTPS() > this.getAverageTPS() ? this.getAverageTPS() : this.getTPS();
    }

    public double getAllMissedTicks() {
        return this.allMissedTicks;
    }

    public int applicableMissedTicks() {
        return (int)Math.floor(this.allMissedTicks);
    }

    public void clearMissedTicks() {
        this.allMissedTicks -= (double)this.applicableMissedTicks();
    }

    public void resetMissedTicks() {
        this.allMissedTicks = 0.0;
    }
}

