/*
 * Decompiled with CFR 0.152.
 */
package net.snackbag.tt20;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.snackbag.shit.web.WebRequest;
import net.snackbag.shit.web.WebResponse;
import net.snackbag.tt20.TT20;

public class ModUpdater {
    private static final URL updateUrl;
    public static String updateMessage;
    public static boolean hasUpdate;

    public static void check() {
        WebResponse resp;
        if (!TT20.config.automaticUpdater()) {
            TT20.LOGGER.info("(TT20) Not checking for updates, because the updater is disabled. Current version: 0.7.1");
            return;
        }
        TT20.LOGGER.info("(TT20) Checking for updates...");
        try {
            resp = new WebRequest(updateUrl).get();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to GET update info for TT20. URL: " + String.valueOf(updateUrl));
        }
        JsonObject body = JsonParser.parseString((String)resp.content()).getAsJsonObject();
        boolean status = body.get("status").getAsBoolean();
        if (!status) {
            throw new RuntimeException("(TT20) Failed to check for updates, status is false.");
        }
        String latest = body.get("latest").getAsString();
        boolean shouldUpdate = ModUpdater.checkUpdatesAvailable(latest);
        if (!shouldUpdate) {
            TT20.LOGGER.info("(TT20) Running the latest version");
            return;
        }
        updateMessage = body.get("updateMessage").getAsString();
        hasUpdate = true;
        TT20.LOGGER.warn("(TT20) User is running an outdated version of TT20. Latest: " + latest + " - current: 0.7.1");
    }

    public static boolean checkUpdatesAvailable(String latest) {
        String[] latestVer = latest.split("\\.");
        String[] oldVer = "0.7.1".split("\\.");
        return ModUpdater.laterVersion(latestVer, oldVer);
    }

    public static boolean laterVersion(String[] newVer, String[] oldVer) {
        int newVerMajor = Integer.valueOf(newVer[0]);
        int newVerMinor = Integer.valueOf(newVer[1]);
        int newVerPatch = Integer.valueOf(newVer[2]);
        int oldVerMajor = Integer.valueOf(oldVer[0]);
        int oldVerMinor = Integer.valueOf(oldVer[1]);
        int oldVerPatch = Integer.valueOf(oldVer[2]);
        if (newVerMajor > oldVerMajor) {
            return true;
        }
        if (newVerMinor > oldVerMinor) {
            return true;
        }
        return newVerPatch > oldVerPatch;
    }

    static {
        hasUpdate = false;
        try {
            updateUrl = new URL("https://playout.snackbag.net/updater/v1/tt20");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

