/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.Gson;
import java.io.File;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\n\u0010\u0005J\u0017\u0010\f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\f\u0010\u0005J\u0015\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000e\u0010\u0005J\u0017\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0010J\u000f\u0010\u0014\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0014\u0010\bR\u0014\u0010\u0015\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"LAIHandler;", "", "", "dirPath", "<init>", "(Ljava/lang/String;)V", "", "start", "()V", "input", "enviarMensagem", "mensagem", "respostaNormal", "texto", "analisarTexto", "callGemini", "(Ljava/lang/String;)Ljava/lang/String;", "buildJson", "text", "escape", "limitarHistorico", "apiKey", "Ljava/lang/String;", "Ljava/nio/file/Path;", "comandoPath", "Ljava/nio/file/Path;", "respostaPath", "", "LMensagem;", "historico", "Ljava/util/List;", "Companion", "cobblemon-cobblebrain"})
public final class AIHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String apiKey;
    @NotNull
    private final Path comandoPath;
    @NotNull
    private final Path respostaPath;
    @NotNull
    private final List<Mensagem> historico;
    @NotNull
    private static final Gson gson = new Gson();
    @NotNull
    private static final File configFile = new File("config/cobblebrain.json");
    @NotNull
    private static final CobblebrainConfig config;
    @NotNull
    private static final String MODEL;
    @NotNull
    private static final String INSTRUCTS;

    public AIHandler(@NotNull String dirPath) {
        Intrinsics.checkNotNullParameter((Object)dirPath, (String)"dirPath");
        this.apiKey = config.getApiKey();
        String[] stringArray = new String[]{"comando_ia.txt"};
        Path path = Paths.get(dirPath, stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        this.comandoPath = path;
        stringArray = new String[]{"resposta_ia.txt"};
        Path path2 = Paths.get(dirPath, stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        this.respostaPath = path2;
        this.historico = new ArrayList();
        if (!Files.exists(this.comandoPath, new LinkOption[0])) {
            Files.writeString(this.comandoPath, (CharSequence)"", new OpenOption[0]);
        }
        if (!Files.exists(this.respostaPath, new LinkOption[0])) {
            Files.writeString(this.respostaPath, (CharSequence)"", new OpenOption[0]);
        }
    }

    public final void start() {
        System.out.println((Object)Files.readString(this.comandoPath));
        WatchService watchService = FileSystems.getDefault().newWatchService();
        WatchEvent.Kind[] kindArray = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY};
        this.comandoPath.getParent().register(watchService, kindArray);
        String lastInput = "";
        while (true) {
            WatchKey key = watchService.take();
            for (WatchEvent<?> event : key.pollEvents()) {
                Object obj = event.context();
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type java.nio.file.Path");
                Path changed = (Path)obj;
                if (!changed.endsWith(this.comandoPath.getFileName())) continue;
                String string = Files.readString(this.comandoPath);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
                String userInput = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (!(((CharSequence)userInput).length() > 0) || Intrinsics.areEqual((Object)userInput, (Object)lastInput) || !config.getPokemonTalk()) continue;
                this.enviarMensagem(userInput);
                lastInput = userInput;
            }
            key.reset();
        }
    }

    private final void enviarMensagem(String input) {
        if (Intrinsics.areEqual((Object)input, (Object)"/end")) {
            System.out.println((Object)"Encerrando IA...");
            System.exit(0);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        if (config.getPokemonTalk()) {
            this.respostaNormal(input);
            System.out.println((Object)"Resposta processada");
        }
    }

    private final void respostaNormal(String mensagem) {
        String responseText = this.callGemini(mensagem);
        String textoFormatado = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)responseText, (String)"\\n", (String)"\n", (boolean)false, (int)4, null), (String)"\n", (String)"|", (boolean)false, (int)4, null), (String)"\\", (String)"", (boolean)false, (int)4, null);
        System.out.println((Object)("Resposta IA: " + textoFormatado));
        Files.writeString(this.respostaPath, (CharSequence)textoFormatado, new OpenOption[0]);
        Files.writeString(this.comandoPath, (CharSequence)"", new OpenOption[0]);
        this.historico.add(new Mensagem("model", responseText));
        this.limitarHistorico();
    }

    public final void analisarTexto(@NotNull String texto) {
        Intrinsics.checkNotNullParameter((Object)texto, (String)"texto");
        if (StringsKt.contains$default((CharSequence)texto, (CharSequence)"\n", (boolean)false, (int)2, null)) {
            System.out.println((Object)"Tem quebra de linha real");
        }
        if (StringsKt.contains$default((CharSequence)texto, (CharSequence)"\\n", (boolean)false, (int)2, null)) {
            System.out.println((Object)"Tem texto literal \\n");
        }
    }

    private final String callGemini(String mensagem) {
        HttpRequest request;
        String endpoint = "https://generativelanguage.googleapis.com/v1beta/models/" + MODEL + ":generateContent?key=" + this.apiKey;
        String jsonBody = this.buildJson(mensagem);
        HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(20L)).build();
        HttpResponse<String> response = client.send(request = HttpRequest.newBuilder().uri(URI.create(endpoint)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonBody)).build(), HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            return "Erro HTTP " + response.statusCode() + ": " + response.body();
        }
        String body = response.body();
        String marker = "\"text\":";
        Intrinsics.checkNotNull((Object)body);
        int idx = StringsKt.indexOf$default((CharSequence)body, (String)marker, (int)0, (boolean)false, (int)6, null);
        if (idx != -1) {
            int start = StringsKt.indexOf$default((CharSequence)body, (char)'\"', (int)(idx + marker.length()), (boolean)false, (int)4, null);
            int end = StringsKt.indexOf$default((CharSequence)body, (char)'\"', (int)(start + 1), (boolean)false, (int)4, null);
            if (start != -1 && end != -1) {
                String string = body.substring(start + 1, end);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }
        }
        return "N\u00e3o foi poss\u00edvel extrair texto da resposta: " + body;
    }

    private final String buildJson(String mensagem) {
        this.historico.add(new Mensagem("user", mensagem));
        this.limitarHistorico();
        String contentsJson = CollectionsKt.joinToString$default((Iterable)this.historico, (CharSequence)",", null, null, (int)0, null, arg_0 -> AIHandler.buildJson$lambda$0(this, arg_0), (int)30, null);
        return StringsKt.trimIndent((String)("\n            {\n              \"contents\": [ " + contentsJson + " ],\n              \"system_instruction\": { \"parts\": [ { \"text\": \"" + this.escape(INSTRUCTS) + "\" } ] }\n            }\n        "));
    }

    private final String escape(String text) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)text, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null);
    }

    private final void limitarHistorico() {
        while (this.historico.size() > 4) {
            this.historico.remove(0);
        }
    }

    private static final CharSequence buildJson$lambda$0(AIHandler this$0, Mensagem msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        return "{ \"role\": \"" + msg.getRole() + "\", \"parts\": [ { \"text\": \"" + this$0.escape(msg.getText()) + "\" } ] }";
    }

    static {
        Object object = gson.fromJson(FilesKt.readText$default((File)configFile, null, (int)1, null), CobblebrainConfig.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        config = (CobblebrainConfig)object;
        MODEL = config.getAiModel();
        INSTRUCTS = StringsKt.trimIndent((String)config.getInstruct());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0011"}, d2={"LAIHandler$Companion;", "", "<init>", "()V", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "Ljava/io/File;", "configFile", "Ljava/io/File;", "LCobblebrainConfig;", "config", "LCobblebrainConfig;", "", "MODEL", "Ljava/lang/String;", "INSTRUCTS", "cobblemon-cobblebrain"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

