/*
 * Decompiled with CFR 0.152.
 */
package vito.cobblebrain.sensors;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vito.cobblebrain.CobblebrainMod;
import vito.cobblebrain.social.PokemonQuery;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000e\u001a\u00020\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ+\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lvito/cobblebrain/sensors/MemoryStore;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "Ljava/nio/file/Path;", "file", "(Lnet/minecraft/server/MinecraftServer;)Ljava/nio/file/Path;", "", "line", "", "maxMemories", "", "savePokemonMemory", "(Lnet/minecraft/server/MinecraftServer;Ljava/lang/String;I)V", "uuid", "", "loadPokemonMemories", "(Lnet/minecraft/server/MinecraftServer;Ljava/lang/String;I)Ljava/util/List;", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "cobblemon-cobblebrain"})
@SourceDebugExtension(value={"SMAP\nWorldContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldContext.kt\nvito/cobblebrain/sensors/MemoryStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,263:1\n1374#2:264\n1460#2,5:265\n295#2,2:270\n295#2,2:272\n2746#2,3:274\n295#2,2:277\n1563#2:279\n1634#2,3:280\n1563#2:283\n1634#2,3:284\n*S KotlinDebug\n*F\n+ 1 WorldContext.kt\nvito/cobblebrain/sensors/MemoryStore\n*L\n176#1:264\n176#1:265,5\n177#1:270,2\n198#1:272,2\n214#1:274,3\n242#1:277,2\n245#1:279\n245#1:280,3\n246#1:283\n246#1:284,3\n*E\n"})
public final class MemoryStore {
    @NotNull
    public static final MemoryStore INSTANCE = new MemoryStore();
    @NotNull
    private static final Gson gson;

    private MemoryStore() {
    }

    private final Path file(MinecraftServer server) {
        Path dataDir = server.method_27050(class_5218.field_24188).resolve("data");
        Files.createDirectories(dataDir, new FileAttribute[0]);
        Path f = dataDir.resolve("cobblebrain_memories.json");
        System.out.println((Object)(">>> memoryFile path: " + f + " (exists=" + Files.exists(f, new LinkOption[0]) + ")"));
        Intrinsics.checkNotNull((Object)f);
        return f;
    }

    /*
     * WARNING - void declaration
     */
    public final void savePokemonMemory(@Nullable MinecraftServer server, @NotNull String line, int maxMemories) {
        Object v4;
        Pokemon poke;
        String memory;
        String nameFromLine;
        String marker;
        MinecraftServer s;
        block22: {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            MinecraftServer minecraftServer = server;
            if (minecraftServer == null) {
                MemoryStore $this$savePokemonMemory_u24lambda_u240 = this;
                boolean bl = false;
                System.out.println((Object)">>> server is null, aborting save");
                return;
            }
            s = minecraftServer;
            System.out.println((Object)(">>> savePokemonMemory called with line='" + line + "'"));
            Regex regex = new Regex("(@{1,2})(?:Pokemon\\s+)?([^:]+):\\s*(.+)");
            MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)line, (int)0, (int)2, null);
            if (matchResult == null) {
                MemoryStore $this$savePokemonMemory_u24lambda_u241 = this;
                boolean bl = false;
                System.out.println((Object)">>> regex did not match, skipping");
                return;
            }
            MatchResult match = matchResult;
            marker = (String)match.getGroupValues().get(1);
            nameFromLine = ((Object)StringsKt.trim((CharSequence)((String)match.getGroupValues().get(2)))).toString();
            memory = ((Object)StringsKt.trim((CharSequence)((String)match.getGroupValues().get(3)))).toString();
            List list = s.method_3760().method_14571();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
            Iterable $this$flatMap$iv = list;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                class_3222 it = (class_3222)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Iterable list$iv$iv = PokemonQuery.INSTANCE.findActivePokemon(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List ativos = (List)destination$iv$iv;
            Iterable $this$firstOrNull$iv = ativos;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                poke = (Pokemon)element$iv;
                boolean bl = false;
                class_5250 class_52502 = poke.getNickname();
                String nick = class_52502 != null ? class_52502.getString() : null;
                if (!(nick != null && StringsKt.equals((String)nick, (String)nameFromLine, (boolean)true) || StringsKt.equals((String)poke.getSpecies().getName(), (String)nameFromLine, (boolean)true))) continue;
                v4 = element$iv;
                break block22;
            }
            v4 = null;
        }
        Pokemon pokemon = v4;
        if (pokemon == null) {
            MemoryStore $this$savePokemonMemory_u24lambda_u244 = this;
            boolean bl = false;
            System.out.println((Object)(">>> no active Pok\u00e9mon found for '" + nameFromLine + "'"));
            return;
        }
        Pokemon alvo = pokemon;
        Path f = this.file(s);
        try {
            boolean bl;
            JsonArray targetArray;
            JsonObject root;
            Gson gson;
            block24: {
                Object v9;
                Iterable $this$firstOrNull$iv;
                String uuidStr;
                JsonArray arr;
                block23: {
                    JsonArray jsonArray;
                    JsonObject jsonObject;
                    gson = new GsonBuilder().setPrettyPrinting().create();
                    if (Files.exists(f, new LinkOption[0])) {
                        jsonObject = (JsonObject)gson.fromJson(Files.readString(f), JsonObject.class);
                        if (jsonObject == null) {
                            jsonObject = new JsonObject();
                        }
                    } else {
                        jsonObject = new JsonObject();
                    }
                    if ((jsonArray = (root = jsonObject).getAsJsonArray("pokemon_memories")) == null) {
                        Pokemon it = poke = new JsonArray();
                        boolean bl2 = false;
                        root.add("pokemon_memories", (JsonElement)it);
                        jsonArray = poke;
                    }
                    arr = jsonArray;
                    String string = alvo.getUuid().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    uuidStr = string;
                    $this$firstOrNull$iv = (Iterable)arr;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        JsonElement it = (JsonElement)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getAsJsonObject().get("uuid").getAsString(), (Object)uuidStr)) continue;
                        v9 = element$iv;
                        break block23;
                    }
                    v9 = null;
                }
                JsonElement jsonElement = v9;
                Object existing = jsonElement != null ? jsonElement.getAsJsonObject() : null;
                Object object = existing;
                if (object == null) {
                    Iterable $this$savePokemonMemory_u24lambda_u247 = $this$firstOrNull$iv = new JsonObject();
                    boolean bl4 = false;
                    $this$savePokemonMemory_u24lambda_u247.addProperty("uuid", uuidStr);
                    Object object2 = alvo.getNickname();
                    if (object2 == null || (object2 = object2.getString()) == null) {
                        object2 = "";
                    }
                    $this$savePokemonMemory_u24lambda_u247.addProperty("nickname", (String)object2);
                    $this$savePokemonMemory_u24lambda_u247.addProperty("species", alvo.getSpecies().getName());
                    $this$savePokemonMemory_u24lambda_u247.add("short_term", (JsonElement)new JsonArray());
                    $this$savePokemonMemory_u24lambda_u247.add("long_term", (JsonElement)new JsonArray());
                    arr.add((JsonElement)$this$savePokemonMemory_u24lambda_u247);
                    object = $this$firstOrNull$iv;
                }
                JsonObject obj = object;
                targetArray = Intrinsics.areEqual((Object)marker, (Object)"@@") ? obj.getAsJsonArray("long_term") : obj.getAsJsonArray("short_term");
                Intrinsics.checkNotNull((Object)targetArray);
                Iterable $this$none$iv = (Iterable)targetArray;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        JsonElement it = (JsonElement)element$iv;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)it.getAsString(), (Object)memory)) continue;
                        bl = false;
                        break block24;
                    }
                    bl = true;
                }
            }
            if (bl) {
                targetArray.add(memory);
            }
            if (Intrinsics.areEqual((Object)marker, (Object)"@") && maxMemories > 0) {
                while (targetArray.size() > maxMemories) {
                    targetArray.remove(0);
                }
            }
            if (Intrinsics.areEqual((Object)marker, (Object)"@@") && CobblebrainMod.INSTANCE.getConfig().getMaxLongMemory() > 0) {
                while (targetArray.size() > CobblebrainMod.INSTANCE.getConfig().getMaxLongMemory()) {
                    targetArray.remove(0);
                }
            }
            Files.writeString(f, (CharSequence)gson.toJson((JsonElement)root), new OpenOption[0]);
            System.out.println((Object)(">>> wrote memories.json (exists=" + Files.exists(f, new LinkOption[0]) + ")"));
        }
        catch (Exception e) {
            System.out.println((Object)(">>> ERROR writing memories.json: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> loadPokemonMemories(@NotNull MinecraftServer server, @NotNull String uuid, int maxMemories) {
        List list;
        List list2;
        Collection collection;
        JsonElement jsonElement;
        Object v2;
        Object it;
        block13: {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Path f = this.file(server);
            if (!Files.exists(f, new LinkOption[0])) {
                return CollectionsKt.emptyList();
            }
            JsonObject jsonObject = (JsonObject)gson.fromJson(Files.readString(f), JsonObject.class);
            if (jsonObject == null) {
                return CollectionsKt.emptyList();
            }
            JsonObject root = jsonObject;
            JsonArray jsonArray = root.getAsJsonArray("pokemon_memories");
            if (jsonArray == null) {
                return CollectionsKt.emptyList();
            }
            JsonArray arr = jsonArray;
            Iterable $this$firstOrNull$iv = (Iterable)arr;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (JsonElement)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getAsJsonObject().get("uuid").getAsString(), (Object)uuid)) continue;
                v2 = element$iv;
                break block13;
            }
            v2 = null;
        }
        if ((jsonElement = (JsonElement)v2) == null || (jsonElement = jsonElement.getAsJsonObject()) == null) {
            return CollectionsKt.emptyList();
        }
        JsonElement obj = jsonElement;
        JsonArray jsonArray = obj.getAsJsonArray("short_term");
        if (jsonArray != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)jsonArray;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                JsonElement jsonElement2 = (JsonElement)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it2.getAsString());
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List shortTerm = list2;
        JsonArray jsonArray2 = obj.getAsJsonArray("long_term");
        if (jsonArray2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)jsonArray2;
            boolean $i$f$map = false;
            Iterable destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                JsonElement bl = (JsonElement)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it3.getAsString());
            }
            list = (List)destination$iv$iv2;
        } else {
            list = CollectionsKt.emptyList();
        }
        List longTerm = list;
        List shortLimited = maxMemories > 0 ? CollectionsKt.takeLast((List)shortTerm, (int)maxMemories) : shortTerm;
        List longLimited = CobblebrainMod.INSTANCE.getConfig().getMaxLongMemory() > 0 ? CollectionsKt.takeLast((List)longTerm, (int)CobblebrainMod.INSTANCE.getConfig().getMaxLongMemory()) : longTerm;
        List result = new ArrayList();
        if (!((Collection)shortLimited).isEmpty()) {
            result.add("SHORT-TERM MEMORIES");
            result.addAll(shortLimited);
        }
        if (!((Collection)longLimited).isEmpty()) {
            result.add("IMPORTANT / CHARACTERISTIC MEMORIES");
            result.addAll(longLimited);
        }
        return result;
    }

    static {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        MemoryStore.gson = gson;
    }
}

