/*
 * Decompiled with CFR 0.152.
 */
package me.noob.noobShulkerBoxes.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.noob.noobShulkerBoxes.NoobShulkerBoxes;
import me.noob.noobShulkerBoxes.playerdata.PlayerDataManager;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShulkerBoxesCommand
implements CommandExecutor,
TabExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("reload")) {
                if (sender.hasPermission("noobshulkerboxes.reload")) {
                    NoobShulkerBoxes.getInstance().reloadConfig();
                    sender.sendRichMessage("<red>Config reloaded");
                }
            } else if (args[0].equalsIgnoreCase("toggle") && sender instanceof Player) {
                Player player = (Player)sender;
                FileConfiguration data = PlayerDataManager.loadPlayerData(player);
                boolean newState = !data.getBoolean("enabled");
                data.set("enabled", (Object)newState);
                PlayerDataManager.savePlayerData(player, data);
                if (newState) {
                    player.sendRichMessage("<green>ShulkerBoxes enabled.");
                } else {
                    player.sendRichMessage("<red>ShulkerBoxes disabled.");
                }
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            if (sender.hasPermission("noobshulkerboxes.reload")) {
                suggestions.add("reload");
            }
            if (sender instanceof Player) {
                suggestions.add("toggle");
            }
            return suggestions.stream().filter(s -> s.startsWith(args[0].toLowerCase())).toList();
        }
        return Collections.emptyList();
    }
}

