/*
 * Decompiled with CFR 0.152.
 */
package chaoscaged;

import com.dipilodopilasaurus.chaoscaged.recipe.EntityDataRecipeSerializer;
import net.minecraft.block.Block;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="chaoscaged")
public class ChaosCaged {
    public static final String MOD_ID = "chaoscaged";
    public static final Logger LOGGER = LogManager.getLogger();

    public ChaosCaged() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Running common setup for Chaos Caged.");
        if (!ModList.get().isLoaded("cagedmobs") || !ModList.get().isLoaded("chaosawakens")) {
            throw new IllegalStateException("Chaos Caged requires both Caged Mobs and Chaos Awakens to be installed!");
        }
        event.enqueueWork(() -> {
            this.validateCagedMobs();
            this.checkCagedMobsCompatibility();
        });
    }

    private void validateCagedMobs() {
        if (!ForgeRegistries.BLOCKS.containsKey(new ResourceLocation("cagedmobs", "mob_cage"))) {
            throw new IllegalStateException("Caged Mobs 'mob_cage' block is missing!");
        }
        if (!ForgeRegistries.ITEMS.containsKey(new ResourceLocation("cagedmobs", "dna_sampler"))) {
            throw new IllegalStateException("Caged Mobs 'dna_sampler' item is missing!");
        }
    }

    private void checkCagedMobsCompatibility() {
        LOGGER.info("Checking compatibility with Caged Mobs.");
        try {
            Block mobCage = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("cagedmobs:mob_cage"));
            if (mobCage == null) {
                LOGGER.error("Caged Mobs 'mob_cage' block is not registered. Compatibility may be broken.");
            } else {
                LOGGER.info("Caged Mobs 'mob_cage' block found. Compatibility intact.");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error checking Caged Mobs compatibility: ", (Throwable)e);
        }
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        LOGGER.info("Running client-specific setup for Chaos Caged.");
    }

    @Mod.EventBusSubscriber(modid="chaoscaged", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEventHandler {
        @SubscribeEvent
        public static void onRegisterRecipes(RegistryEvent.Register<IRecipeSerializer<?>> event) {
            LOGGER.info("Registering custom recipe serializers for Chaos Caged.");
            event.getRegistry().register(new EntityDataRecipeSerializer().setRegistryName(ChaosCaged.MOD_ID, "entity_data"));
        }
    }
}

