/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.scanner;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.api.LoadSettings;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.common.CharConstants;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.exceptions.Mark;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.exceptions.ReaderException;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.exceptions.YamlEngineException;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.CharSequenceExtensionsKt;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character;
import ru.astrainteractive.astrarating.okio.Buffer;
import ru.astrainteractive.astrarating.okio.BufferedSource;
import ru.astrainteractive.astrarating.okio.ByteString;
import ru.astrainteractive.astrarating.okio.Okio;
import ru.astrainteractive.astrarating.okio.Source;
import ru.astrainteractive.astrarating.org.jetbrains.annotations.NotNull;
import ru.astrainteractive.astrarating.org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\u0018\u0000 22\u00020\u0001:\u00012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\tJ\b\u0010 \u001a\u0004\u0018\u00010!J\u0012\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020\u0013H\u0007J\u0006\u0010%\u001a\u00020\u0013J\u000e\u0010%\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013J\u000e\u0010&\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u0013J\u000e\u0010'\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u0013J\u0012\u0010(\u001a\u00020\r2\b\b\u0002\u0010)\u001a\u00020\u0013H\u0002J\b\u0010*\u001a\u00020#H\u0002J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u0013H\u0002J \u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\b2\u0006\u0010,\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u0013H\u0002J\u0010\u00100\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0013H\u0002J\u0006\u00101\u001a\u00020#R\u000e\u0010\u0004\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u001e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u001e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019\u00a8\u00063"}, d2={"Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/scanner/StreamReader;", "", "loadSettings", "Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/api/LoadSettings;", "stream", "Lru/astrainteractive/astrarating/okio/Source;", "<init>", "(Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/api/LoadSettings;Lru/astrainteractive/astrarating/okio/Source;)V", "", "(Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/api/LoadSettings;Ljava/lang/String;)V", "Lru/astrainteractive/astrarating/okio/BufferedSource;", "name", "useMarks", "", "bufferReadSize", "", "codePointsWindow", "", "dataLength", "", "pointer", "eof", "value", "index", "getIndex", "()I", "documentIndex", "getDocumentIndex", "line", "getLine", "column", "getColumn", "getMark", "Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/exceptions/Mark;", "forward", "", "length", "peek", "prefix", "prefixForward", "ensureEnoughData", "size", "update", "prepareWindowFor", "read", "transcodeAndValidateToWindow", "buffer", "cpIndexStart", "moveIndices", "resetDocumentIndex", "Companion", "snakeyaml-engine-kmp"})
@SourceDebugExtension(value={"SMAP\nStreamReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamReader.kt\nit/krzeminski/snakeyaml/engine/kmp/scanner/StreamReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 BufferedSourceExtensions.kt\nit/krzeminski/snakeyaml/engine/kmp/internal/utils/BufferedSourceExtensionsKt\n*L\n1#1,313:1\n1#2:314\n11#3,17:315\n86#3,2:332\n31#3,13:334\n86#3,2:347\n44#3,18:349\n86#3,2:367\n67#3,6:369\n95#3,11:375\n74#3,8:386\n*S KotlinDebug\n*F\n+ 1 StreamReader.kt\nit/krzeminski/snakeyaml/engine/kmp/scanner/StreamReader\n*L\n202#1:315,17\n202#1:332,2\n202#1:334,13\n202#1:347,2\n202#1:349,18\n202#1:367,2\n202#1:369,6\n202#1:375,11\n202#1:386,8\n*E\n"})
public final class StreamReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferedSource stream;
    @NotNull
    private final String name;
    private final boolean useMarks;
    private final long bufferReadSize;
    @NotNull
    private int[] codePointsWindow;
    private int dataLength;
    private int pointer;
    private boolean eof;
    private int index;
    private int documentIndex;
    private int line;
    private int column;

    public StreamReader(@NotNull LoadSettings loadSettings, @NotNull Source stream) {
        Intrinsics.checkNotNullParameter(loadSettings, "loadSettings");
        Intrinsics.checkNotNullParameter(stream, "stream");
        if (!(loadSettings.getBufferSize() >= 4)) {
            boolean bl = false;
            String string = "buffer size must be at least 4 bytes to be able to read all Unicode codepoints";
            throw new IllegalArgumentException(string.toString());
        }
        this.stream = stream instanceof BufferedSource ? (BufferedSource)stream : Okio.buffer(stream);
        this.name = loadSettings.getLabel();
        this.useMarks = loadSettings.getUseMarks();
        this.bufferReadSize = loadSettings.getBufferSize();
        this.codePointsWindow = new int[0];
    }

    public final int getIndex() {
        return this.index;
    }

    public final int getDocumentIndex() {
        return this.documentIndex;
    }

    public final int getLine() {
        return this.line;
    }

    public final int getColumn() {
        return this.column;
    }

    public StreamReader(@NotNull LoadSettings loadSettings, @NotNull String stream) {
        Intrinsics.checkNotNullParameter(loadSettings, "loadSettings");
        Intrinsics.checkNotNullParameter(stream, "stream");
        this(loadSettings, new Buffer().write(ByteString.Companion.encodeUtf8(stream)));
    }

    @Nullable
    public final Mark getMark() {
        if (!this.useMarks) {
            return null;
        }
        return new Mark(this.name, this.index, this.line, this.column, ArraysKt.asList(this.codePointsWindow), this.pointer);
    }

    @JvmOverloads
    public final void forward(int length) {
        for (int i = 0; i < length; ++i) {
            int it = i;
            boolean bl = false;
            if (!StreamReader.ensureEnoughData$default(this, 0, 1, null)) continue;
            int n = this.pointer;
            this.pointer = n + 1;
            int c = this.codePointsWindow[n];
            this.moveIndices(1);
            if (CharConstants.LINEBR.has(c) || c == 13 && StreamReader.ensureEnoughData$default(this, 0, 1, null) && this.codePointsWindow[this.pointer] != 10) {
                n = this.line;
                this.line = n + 1;
                this.column = 0;
                continue;
            }
            if (c == 65279) continue;
            n = this.column;
            this.column = n + 1;
        }
    }

    public static /* synthetic */ void forward$default(StreamReader streamReader, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        streamReader.forward(n);
    }

    public final int peek() {
        return StreamReader.ensureEnoughData$default(this, 0, 1, null) ? this.codePointsWindow[this.pointer] : 0;
    }

    public final int peek(int index) {
        return this.ensureEnoughData(index) ? this.codePointsWindow[this.pointer + index] : 0;
    }

    @NotNull
    public final String prefix(int length) {
        StringBuilder stringBuilder;
        if (length == 0) {
            return "";
        }
        int stringLength = this.ensureEnoughData(length) ? length : RangesKt.coerceAtMost(length, this.dataLength - this.pointer);
        StringBuilder $this$prefix_u24lambda_u242 = stringBuilder = new StringBuilder(stringLength);
        boolean bl = false;
        int n = this.pointer + stringLength;
        for (int i = this.pointer; i < n; ++i) {
            $this$prefix_u24lambda_u242.appendCodePoint(this.codePointsWindow[i]);
        }
        return stringBuilder.toString();
    }

    @NotNull
    public final String prefixForward(int length) {
        String prefix = this.prefix(length);
        this.pointer += length;
        this.moveIndices(length);
        this.column += length;
        return prefix;
    }

    private final boolean ensureEnoughData(int size2) {
        if (!this.eof && this.pointer + size2 >= this.dataLength) {
            this.update();
        }
        return this.pointer + size2 < this.dataLength;
    }

    static /* synthetic */ boolean ensureEnoughData$default(StreamReader streamReader, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return streamReader.ensureEnoughData(n);
    }

    /*
     * WARNING - void declaration
     */
    private final void update() {
        try {
            String buffer$iv;
            long l;
            void $this$readUtf8WithLimit$iv;
            block16: {
                long originalSize$iv$iv;
                void $this$sizeOfFullValidUtf8String$iv$iv;
                BufferedSource bufferedSource = this.stream;
                long limitBytes$iv = this.bufferReadSize;
                boolean $i$f$readUtf8WithLimit = false;
                void var6_6 = $this$readUtf8WithLimit$iv;
                long limitBytes$iv$iv = limitBytes$iv;
                boolean $i$f$sizeOfFullValidUtf8String = false;
                boolean hasAll$iv$iv = $this$sizeOfFullValidUtf8String$iv$iv.request(limitBytes$iv$iv);
                long l2 = originalSize$iv$iv = hasAll$iv$iv ? limitBytes$iv$iv : $this$sizeOfFullValidUtf8String$iv$iv.getBuffer().size();
                if (originalSize$iv$iv == 0L) {
                    l = 0L;
                } else {
                    byte byte$iv$iv;
                    byte byte$iv$iv$iv = byte$iv$iv = $this$sizeOfFullValidUtf8String$iv$iv.getBuffer().getByte(originalSize$iv$iv - 1L);
                    boolean $i$f$isContinuationByte = false;
                    byte asInt$iv$iv$iv = byte$iv$iv$iv;
                    if (!((asInt$iv$iv$iv & 0xC0) == 128)) {
                        l = originalSize$iv$iv - (long)(byte$iv$iv < 0 ? 1 : 0);
                    } else if (!$this$sizeOfFullValidUtf8String$iv$iv.request(originalSize$iv$iv + 1L)) {
                        l = originalSize$iv$iv;
                    } else {
                        byte$iv$iv$iv = $this$sizeOfFullValidUtf8String$iv$iv.getBuffer().getByte(originalSize$iv$iv);
                        $i$f$isContinuationByte = false;
                        asInt$iv$iv$iv = byte$iv$iv$iv;
                        if (!((asInt$iv$iv$iv & 0xC0) == 128)) {
                            l = originalSize$iv$iv;
                        } else {
                            long size$iv$iv = 0L;
                            size$iv$iv = originalSize$iv$iv;
                            int n = 3;
                            for (int i = 0; i < n; ++i) {
                                int it$iv$iv = i;
                                boolean bl = false;
                                if (--size$iv$iv == 0L) {
                                    l = originalSize$iv$iv;
                                } else {
                                    byte byte$iv$iv2;
                                    byte byte$iv$iv$iv2 = byte$iv$iv2 = $this$sizeOfFullValidUtf8String$iv$iv.getBuffer().getByte(size$iv$iv - 1L);
                                    boolean $i$f$isContinuationByte2 = false;
                                    byte asInt$iv$iv$iv2 = byte$iv$iv$iv2;
                                    if ((asInt$iv$iv$iv2 & 0xC0) == 128) continue;
                                    if (byte$iv$iv2 >= 0) {
                                        l = originalSize$iv$iv;
                                    } else {
                                        byte$iv$iv$iv2 = byte$iv$iv2;
                                        boolean $i$f$continuationBytesCountFor = false;
                                        asInt$iv$iv$iv2 = byte$iv$iv$iv2;
                                        l = ((asInt$iv$iv$iv2 & 0xE0) == 192 ? 1 : ((asInt$iv$iv$iv2 & 0xF0) == 224 ? 2 : ((asInt$iv$iv$iv2 & 0xF8) == 240 ? 3 : 0))) < it$iv$iv + 1 ? originalSize$iv$iv : size$iv$iv - 1L;
                                    }
                                }
                                break block16;
                            }
                            l = originalSize$iv$iv;
                        }
                    }
                }
            }
            long fullUtf8Size$iv = l;
            String buffer = buffer$iv = $this$readUtf8WithLimit$iv.readUtf8(fullUtf8Size$iv);
            int read = buffer.length();
            if (read <= 0) {
                this.eof = true;
                return;
            }
            int cpIndex = this.prepareWindowFor(read);
            this.dataLength = this.transcodeAndValidateToWindow(buffer, read, cpIndex);
            this.pointer = 0;
        }
        catch (IOException ioe) {
            throw new YamlEngineException(ioe);
        }
    }

    private final int prepareWindowFor(int read) {
        int cpIndex = this.dataLength - this.pointer;
        this.codePointsWindow = StreamReader.Companion.copyOfRangeSafe(this.codePointsWindow, this.pointer, this.dataLength + read);
        return cpIndex;
    }

    private final int transcodeAndValidateToWindow(String buffer, int read, int cpIndexStart) {
        int cpIndex = cpIndexStart;
        int i = 0;
        while (i < read) {
            int codePoint;
            this.codePointsWindow[cpIndex] = codePoint = CharSequenceExtensionsKt.codePointAt(buffer, i);
            if (!Companion.isPrintable(codePoint)) {
                throw new ReaderException(this.name, this.index + cpIndex, codePoint, "special characters are not allowed");
            }
            i += Character.INSTANCE.charCount$snakeyaml_engine_kmp(codePoint);
            ++cpIndex;
        }
        return cpIndex;
    }

    private final void moveIndices(int length) {
        this.index += length;
        this.documentIndex += length;
    }

    public final void resetDocumentIndex() {
        this.documentIndex = 0;
    }

    @JvmOverloads
    public final void forward() {
        StreamReader.forward$default(this, 0, 1, null);
    }

    @JvmStatic
    public static final boolean isPrintable(@NotNull String data) {
        return Companion.isPrintable(data);
    }

    @JvmStatic
    public static final boolean isPrintable(int c) {
        return Companion.isPrintable(c);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0007J\u001c\u0010\n\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/scanner/StreamReader$Companion;", "", "<init>", "()V", "isPrintable", "", "data", "", "c", "", "copyOfRangeSafe", "", "fromIndex", "toIndex", "snakeyaml-engine-kmp"})
    @SourceDebugExtension(value={"SMAP\nStreamReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamReader.kt\nit/krzeminski/snakeyaml/engine/kmp/scanner/StreamReader$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,313:1\n1#2:314\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isPrintable(@NotNull String data) {
            int codePoint;
            Intrinsics.checkNotNullParameter(data, "data");
            int length = data.length();
            for (int offset = 0; offset < length; offset += Character.INSTANCE.charCount$snakeyaml_engine_kmp(codePoint)) {
                codePoint = CharSequenceExtensionsKt.codePointAt(data, offset);
                if (this.isPrintable(codePoint)) continue;
                return false;
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean isPrintable(int c) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            if (32 <= c) {
                if (c < 127) {
                    return true;
                }
                bl3 = false;
            } else {
                bl3 = false;
            }
            if (bl3) return true;
            if (c == 9) return true;
            if (c == 10) return true;
            if (c == 13) return true;
            if (c == 133) return true;
            if (160 <= c) {
                if (c < 55296) {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return true;
            if (57344 <= c) {
                if (c < 65534) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            if (65536 > c) return false;
            if (c >= 0x110000) return false;
            return true;
        }

        private final int[] copyOfRangeSafe(int[] $this$copyOfRangeSafe, int fromIndex, int toIndex) {
            int n = toIndex - fromIndex;
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3 = i;
                int[] nArray2 = nArray;
                int n4 = n3;
                int[] nArray3 = $this$copyOfRangeSafe;
                int n5 = fromIndex + n3;
                boolean bl = 0 <= n5 ? n5 < nArray3.length : false;
                if (bl) {
                    n2 = nArray3[n5];
                } else {
                    int n6 = n5;
                    int n7 = n4;
                    int[] nArray4 = nArray2;
                    boolean bl2 = false;
                    int n8 = 0;
                    nArray2 = nArray4;
                    n4 = n7;
                    n2 = n8;
                }
                nArray2[n4] = n2;
            }
            return nArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

