/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astrarating.org.jetbrains.exposed.sql;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ru.astrainteractive.astrarating.org.jetbrains.annotations.NotNull;
import ru.astrainteractive.astrarating.org.jetbrains.annotations.Nullable;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.BasicBinaryColumnType;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lru/astrainteractive/astrarating/org/jetbrains/exposed/sql/BinaryColumnType;", "Lru/astrainteractive/astrarating/org/jetbrains/exposed/sql/BasicBinaryColumnType;", "length", "", "<init>", "(I)V", "getLength", "()I", "sqlType", "", "validateValueBeforeUpdate", "", "value", "", "equals", "", "other", "", "hashCode", "exposed-core"})
public class BinaryColumnType
extends BasicBinaryColumnType {
    private final int length;

    public BinaryColumnType(int length) {
        this.length = length;
    }

    public final int getLength() {
        return this.length;
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().binaryType(this.length);
    }

    @Override
    public void validateValueBeforeUpdate(@Nullable byte[] value) {
        int valueLength;
        if (value != null && !((valueLength = value.length) <= this.length)) {
            boolean bl = false;
            String string = "Value can't be stored to database column because exceeds length (" + valueLength + " > " + this.length + ')';
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        Intrinsics.checkNotNull(other, "null cannot be cast to non-null type org.jetbrains.exposed.sql.BinaryColumnType");
        BinaryColumnType cfr_ignored_0 = (BinaryColumnType)other;
        return this.length == ((BinaryColumnType)other).length;
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.length;
        return result2;
    }
}

