/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astrarating.org.jetbrains.exposed.sql;

import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import ru.astrainteractive.astrarating.org.jetbrains.annotations.NotNull;
import ru.astrainteractive.astrarating.org.jetbrains.annotations.Nullable;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.ColumnType;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.vendors.MariaDBDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lru/astrainteractive/astrarating/org/jetbrains/exposed/sql/UUIDColumnType;", "Lru/astrainteractive/astrarating/org/jetbrains/exposed/sql/ColumnType;", "Ljava/util/UUID;", "<init>", "()V", "sqlType", "", "valueFromDB", "value", "", "notNullValueToDB", "nonNullValueToString", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "", "Companion", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nColumnType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColumnType.kt\norg/jetbrains/exposed/sql/UUIDColumnType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1441:1\n1#2:1442\n*E\n"})
public final class UUIDColumnType
extends ColumnType<UUID> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex uuidRegexp = new Regex("[0-9A-F]{8}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{12}", RegexOption.IGNORE_CASE);

    public UUIDColumnType() {
        super(false, 1, null);
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().uuidType();
    }

    @Override
    @NotNull
    public UUID valueFromDB(@NotNull Object value) {
        CharSequence charSequence;
        UUID uUID;
        Intrinsics.checkNotNullParameter(value, "value");
        if (value instanceof UUID) {
            uUID = (UUID)value;
        } else if (value instanceof byte[]) {
            ByteBuffer b = ByteBuffer.wrap((byte[])value);
            boolean bl = false;
            uUID = new UUID(b.getLong(), b.getLong());
        } else if (value instanceof String && uuidRegexp.matches(charSequence = (CharSequence)value)) {
            UUID uUID2 = UUID.fromString((String)value);
            uUID = uUID2;
            Intrinsics.checkNotNullExpressionValue(uUID2, "fromString(...)");
        } else if (value instanceof String) {
            charSequence = (String)value;
            byte[] byArray = ((String)charSequence).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
            ByteBuffer b = ByteBuffer.wrap(byArray);
            boolean bl = false;
            uUID = new UUID(b.getLong(), b.getLong());
        } else {
            throw new IllegalStateException(("Unexpected value of type UUID: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        return uUID;
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().uuidToDB(value);
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return "" + '\'' + value + '\'';
    }

    @Override
    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter(rs, "rs");
        return DatabaseDialectKt.getCurrentDialect() instanceof MariaDBDialect ? rs.getBytes(index) : (byte[])super.readObject(rs, index);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lru/astrainteractive/astrarating/org/jetbrains/exposed/sql/UUIDColumnType$Companion;", "", "<init>", "()V", "uuidRegexp", "Lkotlin/text/Regex;", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

