/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astrarating.libs.okio.internal;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ru.astrainteractive.astrarating.libs.okio.-SegmentedByteString;
import ru.astrainteractive.astrarating.libs.okio.AsyncTimeout;
import ru.astrainteractive.astrarating.libs.okio.Buffer;
import ru.astrainteractive.astrarating.libs.okio.Segment;
import ru.astrainteractive.astrarating.libs.okio.SegmentPool;
import ru.astrainteractive.astrarating.libs.okio.Sink;
import ru.astrainteractive.astrarating.libs.okio.Socket;
import ru.astrainteractive.astrarating.libs.okio.Source;
import ru.astrainteractive.astrarating.libs.okio.internal.SocketAsyncTimeout;
import ru.astrainteractive.astrarating.libs.okio.internal._AtomicKt;
import ru.astrainteractive.astrarating.libs.okio.internal._JavaIoKt;
import ru.astrainteractive.astrarating.libs.org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lru/astrainteractive/astrarating/libs/okio/internal/DefaultSocket;", "Lru/astrainteractive/astrarating/libs/okio/Socket;", "socket", "Ljava/net/Socket;", "<init>", "(Ljava/net/Socket;)V", "getSocket", "()Ljava/net/Socket;", "closeBits", "Ljava/util/concurrent/atomic/AtomicInteger;", "source", "Lru/astrainteractive/astrarating/libs/okio/Source;", "getSource", "()Lokio/Source;", "sink", "Lru/astrainteractive/astrarating/libs/okio/Sink;", "getSink", "()Lokio/Sink;", "cancel", "", "toString", "", "SocketSink", "SocketSource", "ru.astrainteractive.astrarating.libs.okio"})
public final class DefaultSocket
implements Socket {
    @NotNull
    private final java.net.Socket socket;
    @NotNull
    private AtomicInteger closeBits;
    @NotNull
    private final Source source;
    @NotNull
    private final Sink sink;

    public DefaultSocket(@NotNull java.net.Socket socket) {
        Intrinsics.checkNotNullParameter(socket, "socket");
        this.socket = socket;
        this.closeBits = new AtomicInteger();
        this.source = new SocketSource();
        this.sink = new SocketSink();
    }

    @NotNull
    public final java.net.Socket getSocket() {
        return this.socket;
    }

    @Override
    @NotNull
    public Source getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public Sink getSink() {
        return this.sink;
    }

    @Override
    public void cancel() {
        this.socket.close();
    }

    @NotNull
    public String toString() {
        String string = this.socket.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lru/astrainteractive/astrarating/libs/okio/internal/DefaultSocket$SocketSink;", "Lru/astrainteractive/astrarating/libs/okio/Sink;", "<init>", "(Lokio/internal/DefaultSocket;)V", "timeout", "Lru/astrainteractive/astrarating/libs/okio/internal/SocketAsyncTimeout;", "write", "", "source", "Lru/astrainteractive/astrarating/libs/okio/Buffer;", "byteCount", "", "flush", "close", "toString", "", "ru.astrainteractive.astrarating.libs.okio"})
    @SourceDebugExtension(value={"SMAP\nDefaultSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultSocket.kt\nokio/internal/DefaultSocket$SocketSink\n+ 2 Util.kt\nokio/-SegmentedByteString\n+ 3 AsyncTimeout.kt\nokio/AsyncTimeout\n*L\n1#1,162:1\n85#2:163\n171#3,11:164\n171#3,11:175\n171#3,11:186\n*S KotlinDebug\n*F\n+ 1 DefaultSocket.kt\nokio/internal/DefaultSocket$SocketSink\n*L\n59#1:163\n60#1:164,11\n76#1:175,11\n82#1:186,11\n*E\n"})
    public final class SocketSink
    implements Sink {
        @NotNull
        private final SocketAsyncTimeout timeout;

        public SocketSink() {
            this.timeout = new SocketAsyncTimeout(DefaultSocket.this.getSocket());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void write(@NotNull Buffer source2, long byteCount) {
            Intrinsics.checkNotNullParameter(source2, "source");
            -SegmentedByteString.checkOffsetAndCount(source2.size(), 0L, byteCount);
            long remaining = byteCount;
            while (remaining > 0L) {
                int toCopy;
                Segment head;
                block6: {
                    boolean timedOut$iv;
                    void this_$iv;
                    this.timeout.throwIfReached();
                    Intrinsics.checkNotNull(source2.head);
                    int b$iv22 = head.limit - head.pos;
                    boolean $i$f$minOf = false;
                    toCopy = (int)Math.min(remaining, (long)b$iv22);
                    AsyncTimeout b$iv22 = this.timeout;
                    DefaultSocket defaultSocket = DefaultSocket.this;
                    boolean $i$f$withTimeout = false;
                    boolean throwOnTimeout$iv = false;
                    this_$iv.enter();
                    try {
                        boolean bl = false;
                        defaultSocket.getSocket().getOutputStream().write(head.data, head.pos, toCopy);
                        Unit result$iv = Unit.INSTANCE;
                        throwOnTimeout$iv = true;
                        Unit unit = result$iv;
                        timedOut$iv = this_$iv.exit();
                        if (!timedOut$iv) break block6;
                        throw this_$iv.access$newTimeoutException(null);
                    }
                    catch (IOException e$iv) {
                        try {
                            Throwable throwable;
                            if (!this_$iv.exit()) {
                                throwable = e$iv;
                                throw throwable;
                            }
                            throwable = this_$iv.access$newTimeoutException(e$iv);
                            throw throwable;
                        }
                        catch (Throwable throwable) {
                            timedOut$iv = this_$iv.exit();
                            if (!timedOut$iv) throw throwable;
                            if (!throwOnTimeout$iv) throw throwable;
                            throw this_$iv.access$newTimeoutException(null);
                        }
                    }
                }
                head.pos += toCopy;
                remaining -= (long)toCopy;
                source2.setSize$okio(source2.size() - (long)toCopy);
                if (head.pos != head.limit) continue;
                source2.head = head.pop();
                SegmentPool.recycle(head);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void flush() {
            void this_$iv;
            AsyncTimeout asyncTimeout = this.timeout;
            DefaultSocket defaultSocket = DefaultSocket.this;
            boolean $i$f$withTimeout = false;
            boolean throwOnTimeout$iv = false;
            this_$iv.enter();
            try {
                boolean bl = false;
                defaultSocket.getSocket().getOutputStream().flush();
                Unit result$iv = Unit.INSTANCE;
                throwOnTimeout$iv = true;
                Unit unit = result$iv;
                boolean timedOut$iv = this_$iv.exit();
                if (!timedOut$iv) return;
            }
            catch (IOException e$iv) {
                try {
                    throw !this_$iv.exit() ? (Throwable)e$iv : (Throwable)this_$iv.access$newTimeoutException(e$iv);
                }
                catch (Throwable throwable) {
                    boolean timedOut$iv = this_$iv.exit();
                    if (!timedOut$iv || !throwOnTimeout$iv) throw throwable;
                    throw this_$iv.access$newTimeoutException(null);
                }
            }
            throw this_$iv.access$newTimeoutException(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void close() {
            void this_$iv;
            AsyncTimeout asyncTimeout = this.timeout;
            DefaultSocket defaultSocket = DefaultSocket.this;
            boolean $i$f$withTimeout = false;
            boolean throwOnTimeout$iv = false;
            this_$iv.enter();
            try {
                boolean bl = false;
                switch (_AtomicKt.setBitsOrZero(defaultSocket.closeBits, 1)) {
                    case 0: {
                        if (!this_$iv.exit()) return;
                        return;
                    }
                    case 3: {
                        defaultSocket.getSocket().close();
                        break;
                    }
                    default: {
                        if (defaultSocket.getSocket().isClosed() || defaultSocket.getSocket().isOutputShutdown()) {
                            if (!this_$iv.exit()) return;
                            return;
                        }
                        defaultSocket.getSocket().getOutputStream().flush();
                        defaultSocket.getSocket().shutdownOutput();
                    }
                }
                Unit result$iv = Unit.INSTANCE;
                throwOnTimeout$iv = true;
                Unit unit = result$iv;
                boolean timedOut$iv = this_$iv.exit();
                if (!timedOut$iv) return;
            }
            catch (IOException e$iv) {
                try {
                    Throwable throwable;
                    if (!this_$iv.exit()) {
                        throwable = e$iv;
                        throw throwable;
                    }
                    throwable = this_$iv.access$newTimeoutException(e$iv);
                    throw throwable;
                }
                catch (Throwable throwable) {
                    boolean timedOut$iv = this_$iv.exit();
                    if (!timedOut$iv) throw throwable;
                    if (!throwOnTimeout$iv) throw throwable;
                    throw this_$iv.access$newTimeoutException(null);
                }
            }
            throw this_$iv.access$newTimeoutException(null);
        }

        @Override
        @NotNull
        public SocketAsyncTimeout timeout() {
            return this.timeout;
        }

        @NotNull
        public String toString() {
            return "sink(" + DefaultSocket.this.getSocket() + ')';
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lru/astrainteractive/astrarating/libs/okio/internal/DefaultSocket$SocketSource;", "Lru/astrainteractive/astrarating/libs/okio/Source;", "<init>", "(Lokio/internal/DefaultSocket;)V", "timeout", "Lru/astrainteractive/astrarating/libs/okio/internal/SocketAsyncTimeout;", "read", "", "sink", "Lru/astrainteractive/astrarating/libs/okio/Buffer;", "byteCount", "close", "", "toString", "", "ru.astrainteractive.astrarating.libs.okio"})
    @SourceDebugExtension(value={"SMAP\nDefaultSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultSocket.kt\nokio/internal/DefaultSocket$SocketSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Util.kt\nokio/-SegmentedByteString\n+ 4 AsyncTimeout.kt\nokio/AsyncTimeout\n*L\n1#1,162:1\n1#2:163\n85#3:164\n171#4,11:165\n171#4,11:176\n*S KotlinDebug\n*F\n+ 1 DefaultSocket.kt\nokio/internal/DefaultSocket$SocketSource\n*L\n113#1:164\n115#1:165,11\n136#1:176,11\n*E\n"})
    public final class SocketSource
    implements Source {
        @NotNull
        private final SocketAsyncTimeout timeout;

        public SocketSource() {
            this.timeout = new SocketAsyncTimeout(DefaultSocket.this.getSocket());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public long read(@NotNull Buffer sink2, long byteCount) {
            int n;
            Intrinsics.checkNotNullParameter(sink2, "sink");
            if (byteCount == 0L) {
                return 0L;
            }
            if (!(byteCount >= 0L)) {
                boolean $i$a$-require-DefaultSocket$SocketSource$read$22 = false;
                String $i$a$-require-DefaultSocket$SocketSource$read$22 = "byteCount < 0: " + byteCount;
                throw new IllegalArgumentException($i$a$-require-DefaultSocket$SocketSource$read$22.toString());
            }
            this.timeout.throwIfReached();
            Segment tail = sink2.writableSegment$okio(1);
            int b$iv = 8192 - tail.limit;
            boolean $i$f$minOf2 = false;
            int maxToCopy = (int)Math.min(byteCount, (long)b$iv);
            try {
                int n2;
                block10: {
                    void this_$iv;
                    AsyncTimeout $i$f$minOf2 = this.timeout;
                    DefaultSocket defaultSocket = DefaultSocket.this;
                    boolean $i$f$withTimeout = false;
                    boolean throwOnTimeout$iv = false;
                    this_$iv.enter();
                    try {
                        boolean bl = false;
                        int result$iv = defaultSocket.getSocket().getInputStream().read(tail.data, tail.limit, maxToCopy);
                        throwOnTimeout$iv = true;
                        n2 = result$iv;
                        boolean timedOut$iv = this_$iv.exit();
                        if (!timedOut$iv) break block10;
                        throw this_$iv.access$newTimeoutException(null);
                    }
                    catch (IOException e$iv) {
                        try {
                            Throwable throwable;
                            if (!this_$iv.exit()) {
                                throwable = e$iv;
                                throw throwable;
                            }
                            throwable = this_$iv.access$newTimeoutException(e$iv);
                            throw throwable;
                        }
                        catch (Throwable throwable) {
                            boolean timedOut$iv = this_$iv.exit();
                            if (!timedOut$iv) throw throwable;
                            if (!throwOnTimeout$iv) throw throwable;
                            throw this_$iv.access$newTimeoutException(null);
                        }
                    }
                }
                n = n2;
            }
            catch (AssertionError e) {
                if (!_JavaIoKt.isAndroidGetsocknameError(e)) throw e;
                throw new IOException((Throwable)((Object)e));
            }
            int bytesRead = n;
            if (bytesRead == -1) {
                if (tail.pos != tail.limit) return -1L;
                sink2.head = tail.pop();
                SegmentPool.recycle(tail);
                return -1L;
            }
            tail.limit += bytesRead;
            sink2.setSize$okio(sink2.size() + (long)bytesRead);
            return bytesRead;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void close() {
            void this_$iv;
            AsyncTimeout asyncTimeout = this.timeout;
            DefaultSocket defaultSocket = DefaultSocket.this;
            boolean $i$f$withTimeout = false;
            boolean throwOnTimeout$iv = false;
            this_$iv.enter();
            try {
                boolean bl = false;
                switch (_AtomicKt.setBitsOrZero(defaultSocket.closeBits, 2)) {
                    case 0: {
                        if (!this_$iv.exit()) return;
                        return;
                    }
                    case 3: {
                        defaultSocket.getSocket().close();
                        break;
                    }
                    default: {
                        if (defaultSocket.getSocket().isClosed() || defaultSocket.getSocket().isInputShutdown()) {
                            if (!this_$iv.exit()) return;
                            return;
                        }
                        defaultSocket.getSocket().shutdownInput();
                    }
                }
                Unit result$iv = Unit.INSTANCE;
                throwOnTimeout$iv = true;
                Unit unit = result$iv;
                boolean timedOut$iv = this_$iv.exit();
                if (!timedOut$iv) return;
            }
            catch (IOException e$iv) {
                try {
                    Throwable throwable;
                    if (!this_$iv.exit()) {
                        throwable = e$iv;
                        throw throwable;
                    }
                    throwable = this_$iv.access$newTimeoutException(e$iv);
                    throw throwable;
                }
                catch (Throwable throwable) {
                    boolean timedOut$iv = this_$iv.exit();
                    if (!timedOut$iv) throw throwable;
                    if (!throwOnTimeout$iv) throw throwable;
                    throw this_$iv.access$newTimeoutException(null);
                }
            }
            throw this_$iv.access$newTimeoutException(null);
        }

        @Override
        @NotNull
        public SocketAsyncTimeout timeout() {
            return this.timeout;
        }

        @NotNull
        public String toString() {
            return "source(" + DefaultSocket.this.getSocket() + ')';
        }
    }
}

