/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.transactions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ru.astrainteractive.astrarating.libs.org.jetbrains.annotations.NotNull;
import ru.astrainteractive.astrarating.libs.org.jetbrains.annotations.Nullable;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.exceptions.ExposedSQLException;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.Database;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.SQLLogKt;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.Schema;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.SchemaUtils;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.SqlLogger;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.Transaction;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.statements.StatementContext;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.transactions.TransactionApiKt;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.transactions.TransactionInterface;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a6\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00010\u0005\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\u0010\b\u001aH\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00010\u0005\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\u0010\r\u001aT\u0010\u000e\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00010\u0005\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\u0010\u0010\u001a-\u0010\u0011\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014\u001a \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0000\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\nH\u0000\u001a\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0000\u001a\u00020\u0006H\u0000\u00a8\u0006\u001b"}, d2={"transaction", "T", "db", "Lru/astrainteractive/astrarating/libs/org/jetbrains/exposed/sql/Database;", "statement", "Lkotlin/Function1;", "Lru/astrainteractive/astrarating/libs/org/jetbrains/exposed/sql/Transaction;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/exposed/sql/Database;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "transactionIsolation", "", "readOnly", "", "(IZLorg/jetbrains/exposed/sql/Database;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "inTopLevelTransaction", "outerTransaction", "(IZLorg/jetbrains/exposed/sql/Database;Lorg/jetbrains/exposed/sql/Transaction;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "keepAndRestoreTransactionRefAfterRun", "block", "Lkotlin/Function0;", "(Lorg/jetbrains/exposed/sql/Database;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "handleSQLException", "", "cause", "Ljava/sql/SQLException;", "attempts", "closeStatementsAndConnection", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nThreadLocalTransactionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadLocalTransactionManager.kt\norg/jetbrains/exposed/sql/transactions/ThreadLocalTransactionManagerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 TransactionApi.kt\norg/jetbrains/exposed/sql/transactions/TransactionApiKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,447:1\n1863#2:448\n808#2,11:449\n1863#2,2:460\n1864#2:462\n247#3,6:463\n1#4:469\n*S KotlinDebug\n*F\n+ 1 ThreadLocalTransactionManager.kt\norg/jetbrains/exposed/sql/transactions/ThreadLocalTransactionManagerKt\n*L\n420#1:448\n421#1:449,11\n421#1:460,2\n420#1:462\n443#1:463,6\n*E\n"})
public final class ThreadLocalTransactionManagerKt {
    public static final <T> T transaction(@Nullable Database db, @NotNull Function1<? super Transaction, ? extends T> statement) {
        Intrinsics.checkNotNullParameter(statement, "statement");
        return ThreadLocalTransactionManagerKt.transaction(TransactionApiKt.getTransactionManager(db).getDefaultIsolationLevel(), TransactionApiKt.getTransactionManager(db).getDefaultReadOnly(), db, statement);
    }

    public static /* synthetic */ Object transaction$default(Database database, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            database = null;
        }
        return ThreadLocalTransactionManagerKt.transaction(database, function1);
    }

    public static final <T> T transaction(int transactionIsolation, boolean readOnly, @Nullable Database db, @NotNull Function1<? super Transaction, ? extends T> statement) {
        Intrinsics.checkNotNullParameter(statement, "statement");
        return (T)ThreadLocalTransactionManagerKt.keepAndRestoreTransactionRefAfterRun(db, () -> ThreadLocalTransactionManagerKt.transaction$lambda$5(db, transactionIsolation, readOnly, statement));
    }

    public static /* synthetic */ Object transaction$default(int n, boolean bl, Database database, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            database = null;
        }
        return ThreadLocalTransactionManagerKt.transaction(n, bl, database, function1);
    }

    public static final <T> T inTopLevelTransaction(int transactionIsolation, boolean readOnly, @Nullable Database db, @Nullable Transaction outerTransaction, @NotNull Function1<? super Transaction, ? extends T> statement) {
        Intrinsics.checkNotNullParameter(statement, "statement");
        return (T)ThreadLocalTransactionManagerKt.keepAndRestoreTransactionRefAfterRun(db, () -> ThreadLocalTransactionManagerKt.inTopLevelTransaction$lambda$11(outerTransaction, db, transactionIsolation, readOnly, statement));
    }

    public static /* synthetic */ Object inTopLevelTransaction$default(int n, boolean bl, Database database, Transaction transaction, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            database = null;
        }
        if ((n2 & 8) != 0) {
            transaction = null;
        }
        return ThreadLocalTransactionManagerKt.inTopLevelTransaction(n, bl, database, transaction, function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> T keepAndRestoreTransactionRefAfterRun(Database db, Function0<? extends T> block) {
        T t;
        TransactionManager manager = TransactionApiKt.getTransactionManager(db);
        Transaction currentTransaction = manager.currentOrNull();
        try {
            t = block.invoke();
        }
        finally {
            manager.bindTransactionToThread(currentTransaction);
        }
        return t;
    }

    static /* synthetic */ Object keepAndRestoreTransactionRefAfterRun$default(Database database, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            database = null;
        }
        return ThreadLocalTransactionManagerKt.keepAndRestoreTransactionRefAfterRun(database, function0);
    }

    /*
     * WARNING - void declaration
     */
    public static final void handleSQLException(@NotNull SQLException cause, @NotNull Transaction transaction, int attempts) {
        Intrinsics.checkNotNullParameter(cause, "cause");
        Intrinsics.checkNotNullParameter(transaction, "transaction");
        ExposedSQLException exposedSQLException = cause instanceof ExposedSQLException ? (ExposedSQLException)cause : null;
        Object object = exposedSQLException;
        if (object == null || (object = ((ExposedSQLException)object).causedByQueries()) == null || (object = CollectionsKt.joinToString$default((Iterable)object, ";\n", null, null, 0, null, null, 62, null)) == null) {
            object = String.valueOf(transaction.getCurrentStatement());
        }
        Object queriesToLog = object;
        String message = "Transaction attempt #" + attempts + " failed: " + cause.getMessage() + ". Statement(s): " + (String)queriesToLog;
        Iterable<Throwable> iterable = exposedSQLException;
        if (iterable != null && (iterable = iterable.getContexts()) != null) {
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                void $this$filterIsInstanceTo$iv$iv;
                StatementContext it = (StatementContext)element$iv;
                boolean bl = false;
                Iterable $this$filterIsInstance$iv = transaction.getInterceptors$exposed_core();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable2 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof SqlLogger)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    SqlLogger logger = (SqlLogger)element$iv2;
                    boolean bl2 = false;
                    logger.log(it, transaction);
                }
            }
        }
        SQLLogKt.getExposedLogger().warn(message, cause);
        TransactionApiKt.rollbackLoggingException(transaction, ThreadLocalTransactionManagerKt::handleSQLException$lambda$14);
    }

    public static final void closeStatementsAndConnection(@NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter(transaction, "transaction");
        PreparedStatementApi currentStatement = transaction.getCurrentStatement();
        try {
            PreparedStatementApi preparedStatementApi = currentStatement;
            if (preparedStatementApi != null) {
                PreparedStatementApi it = preparedStatementApi;
                boolean bl = false;
                it.closeIfPossible();
                transaction.setCurrentStatement(null);
            }
            transaction.closeExecutedStatements();
        }
        catch (Exception cause) {
            SQLLogKt.getExposedLogger().warn("Statements close failed", cause);
        }
        TransactionInterface $this$closeLoggingException$iv = transaction;
        boolean $i$f$closeLoggingException = false;
        try {
            $this$closeLoggingException$iv.close();
        }
        catch (Exception e$iv) {
            Exception it = e$iv;
            boolean bl = false;
            SQLLogKt.getExposedLogger().warn("Transaction close failed: " + it.getMessage() + ". Statement: " + currentStatement, it);
        }
    }

    private static final Unit transaction$lambda$5$lambda$1(PreparedStatementApi $currentStatement, Exception it) {
        Intrinsics.checkNotNullParameter(it, "it");
        SQLLogKt.getExposedLogger().warn("Transaction rollback failed: " + it.getMessage() + ". Statement: " + $currentStatement, it);
        return Unit.INSTANCE;
    }

    private static final Unit transaction$lambda$5$lambda$2(PreparedStatementApi $currentStatement, Exception it) {
        Intrinsics.checkNotNullParameter(it, "it");
        SQLLogKt.getExposedLogger().warn("Transaction rollback failed: " + it.getMessage() + ". Statement: " + $currentStatement, it);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object transaction$lambda$5(Database $db, int $transactionIsolation, boolean $readOnly, Function1 $statement) {
        Object object;
        block19: {
            block20: {
                Object r;
                Transaction outer;
                block18: {
                    Object r2;
                    Intrinsics.checkNotNullParameter($statement, "$statement");
                    outer = TransactionManager.Companion.currentOrNull();
                    if (outer == null || $db != null && !Intrinsics.areEqual(outer.getDb(), $db)) break block18;
                    TransactionManager outerManager = TransactionApiKt.getTransactionManager(outer.getDb());
                    Transaction transaction = outerManager.newTransaction($transactionIsolation, $readOnly, outer);
                    try {
                        Object it = r2 = $statement.invoke(transaction);
                        boolean bl = false;
                        if (outer.getDb().getUseNestedTransactions()) {
                            transaction.commit();
                        }
                    }
                    catch (SQLException cause) {
                        PreparedStatementApi currentStatement = transaction.getCurrentStatement();
                        TransactionApiKt.rollbackLoggingException(transaction, arg_0 -> ThreadLocalTransactionManagerKt.transaction$lambda$5$lambda$1(currentStatement, arg_0));
                        throw cause;
                    }
                    catch (Throwable cause) {
                        if (outer.getDb().getUseNestedTransactions()) {
                            PreparedStatementApi currentStatement = transaction.getCurrentStatement();
                            TransactionApiKt.rollbackLoggingException(transaction, arg_0 -> ThreadLocalTransactionManagerKt.transaction$lambda$5$lambda$2(currentStatement, arg_0));
                        }
                        throw cause;
                    }
                    finally {
                        TransactionManager.Companion.resetCurrent(outerManager);
                    }
                    object = r2;
                    break block19;
                }
                Database database = $db;
                TransactionManager existingForDb = database != null ? TransactionApiKt.getTransactionManager(database) : null;
                object = existingForDb;
                if (object == null || (object = object.currentOrNull()) == null) break block20;
                Object transaction = object;
                boolean bl = false;
                Transaction transaction2 = outer;
                TransactionManager currentManager = TransactionApiKt.getTransactionManager(transaction2 != null ? transaction2.getDb() : null);
                try {
                    TransactionManager.Companion.resetCurrent(existingForDb);
                    Object it = r = $statement.invoke(transaction);
                    boolean bl2 = false;
                    if ($db.getUseNestedTransactions()) {
                        ((Transaction)transaction).commit();
                    }
                }
                finally {
                    TransactionManager.Companion.resetCurrent(currentManager);
                }
                Object r3 = r;
                object = r3;
                if (r3 != null) break block19;
            }
            object = ThreadLocalTransactionManagerKt.inTopLevelTransaction($transactionIsolation, $readOnly, $db, null, $statement);
        }
        return object;
    }

    private static final Unit inTopLevelTransaction$run$lambda$10(PreparedStatementApi $currentStatement, Exception it) {
        Intrinsics.checkNotNullParameter(it, "it");
        SQLLogKt.getExposedLogger().warn("Transaction rollback failed: " + it.getMessage() + ". Statement: " + $currentStatement, it);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> T inTopLevelTransaction$run(Transaction $outerTransaction, Database $db, int $transactionIsolation, boolean $readOnly, Function1<? super Transaction, ? extends T> $statement) {
        TransactionManager transactionManager;
        int attempts = 0;
        Transaction transaction = $outerTransaction;
        TransactionManager it = transactionManager = TransactionApiKt.getTransactionManager(transaction != null ? transaction.getDb() : null);
        boolean bl = false;
        TransactionManager outerManager = it.currentOrNull() != null ? transactionManager : null;
        long intermediateDelay = 0L;
        Long retryInterval = null;
        while (true) {
            if ($db != null) {
                boolean bl2 = false;
                TransactionManager m = TransactionApiKt.getTransactionManager($db);
                boolean bl3 = false;
                TransactionManager.Companion.resetCurrent(m);
            }
            Transaction transaction2 = TransactionApiKt.getTransactionManager($db).newTransaction($transactionIsolation, $readOnly, $outerTransaction);
            try {
                Schema schema = transaction2.getDb().getConfig().getDefaultSchema();
                if (schema != null) {
                    Schema it2 = schema;
                    boolean bl4 = false;
                    SchemaUtils.setSchema$default(SchemaUtils.INSTANCE, it2, false, 2, null);
                }
                T answer = $statement.invoke(transaction2);
                transaction2.commit();
                T bl2 = answer;
                return bl2;
            }
            catch (SQLException cause) {
                ThreadLocalTransactionManagerKt.handleSQLException(cause, transaction2, attempts);
                if (++attempts >= transaction2.getMaxAttempts()) {
                    throw cause;
                }
                if (retryInterval == null) {
                    retryInterval = transaction2.getRetryInterval$exposed_core();
                    intermediateDelay = transaction2.getMinRetryDelay();
                }
                long delay = transaction2.getMinRetryDelay() < transaction2.getMaxRetryDelay() ? ThreadLocalRandom.current().nextLong(intermediateDelay += retryInterval * (long)attempts, intermediateDelay + retryInterval) : (transaction2.getMinRetryDelay() == transaction2.getMaxRetryDelay() ? transaction2.getMinRetryDelay() : 0L);
                SQLLogKt.getExposedLogger().warn("Wait " + delay + " milliseconds before retrying");
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
            catch (Throwable cause) {
                PreparedStatementApi currentStatement = transaction2.getCurrentStatement();
                TransactionApiKt.rollbackLoggingException(transaction2, arg_0 -> ThreadLocalTransactionManagerKt.inTopLevelTransaction$run$lambda$10(currentStatement, arg_0));
                throw cause;
            }
            finally {
                TransactionManager.Companion.resetCurrent(outerManager);
                ThreadLocalTransactionManagerKt.closeStatementsAndConnection(transaction2);
                continue;
            }
            break;
        }
    }

    private static final Object inTopLevelTransaction$lambda$11(Transaction $outerTransaction, Database $db, int $transactionIsolation, boolean $readOnly, Function1 $statement) {
        Intrinsics.checkNotNullParameter($statement, "$statement");
        return ThreadLocalTransactionManagerKt.inTopLevelTransaction$run($outerTransaction, $db, $transactionIsolation, $readOnly, $statement);
    }

    private static final Unit handleSQLException$lambda$14(Exception it) {
        Intrinsics.checkNotNullParameter(it, "it");
        SQLLogKt.getExposedLogger().warn("Transaction rollback failed: " + it.getMessage() + ". See previous log line for statement", it);
        return Unit.INSTANCE;
    }
}

