/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.vendors;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import ru.astrainteractive.astrarating.libs.org.jetbrains.annotations.NotNull;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.exceptions.UnsupportedByDialectException;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.Expression;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.ExpressionKt;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.ExpressionWithColumnType;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.IDateColumnType;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.IExpressionAlias;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.JsonColumnMarker;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.LiteralOp;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.QueryBuilder;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.SQLLogKt;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.SortOrder;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import ru.astrainteractive.astrarating.libs.org.jetbrains.exposed.sql.vendors.MysqlDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\u0014\u0010\u0015\u001a\u00020\u00052\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J$\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0016\u00a8\u0006\""}, d2={"Lru/astrainteractive/astrarating/libs/org/jetbrains/exposed/sql/vendors/MysqlDataTypeProvider;", "Lru/astrainteractive/astrarating/libs/org/jetbrains/exposed/sql/vendors/DataTypeProvider;", "<init>", "()V", "binaryType", "", "dateTimeType", "timestampWithTimeZoneType", "ubyteType", "ushortType", "uintegerType", "uintegerAutoincType", "ulongType", "ulongAutoincType", "textType", "mediumTextType", "largeTextType", "booleanFromStringToBoolean", "", "value", "jsonBType", "processForDefaultValue", "e", "Lru/astrainteractive/astrarating/libs/org/jetbrains/exposed/sql/Expression;", "precessOrderByClause", "", "queryBuilder", "Lru/astrainteractive/astrarating/libs/org/jetbrains/exposed/sql/QueryBuilder;", "expression", "sortOrder", "Lru/astrainteractive/astrarating/libs/org/jetbrains/exposed/sql/SortOrder;", "hexToDb", "hexString", "Companion", "exposed-core"})
public class MysqlDataTypeProvider
extends DataTypeProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final MysqlDataTypeProvider INSTANCE = new MysqlDataTypeProvider();

    @Override
    @NotNull
    public String binaryType() {
        SQLLogKt.getExposedLogger().error("The length of the Binary column is missing.");
        throw new IllegalStateException("The length of the Binary column is missing.".toString());
    }

    @Override
    @NotNull
    public String dateTimeType() {
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        MysqlDialect mysqlDialect = databaseDialect instanceof MysqlDialect ? (MysqlDialect)databaseDialect : null;
        return (mysqlDialect != null ? mysqlDialect.isFractionDateTimeSupported() : false) ? "DATETIME(6)" : "DATETIME";
    }

    @Override
    @NotNull
    public String timestampWithTimeZoneType() {
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        MysqlDialect mysqlDialect = databaseDialect instanceof MysqlDialect ? (MysqlDialect)databaseDialect : null;
        if (!(mysqlDialect != null ? mysqlDialect.isTimeZoneOffsetSupported() : false)) {
            throw new UnsupportedByDialectException("This vendor does not support timestamp with time zone data type for this version", DatabaseDialectKt.getCurrentDialect());
        }
        return "TIMESTAMP(6)";
    }

    @Override
    @NotNull
    public String ubyteType() {
        return "TINYINT UNSIGNED";
    }

    @Override
    @NotNull
    public String ushortType() {
        return "SMALLINT UNSIGNED";
    }

    @Override
    @NotNull
    public String uintegerType() {
        return "INT UNSIGNED";
    }

    @Override
    @NotNull
    public String uintegerAutoincType() {
        return "INT UNSIGNED AUTO_INCREMENT";
    }

    @Override
    @NotNull
    public String ulongType() {
        return "BIGINT UNSIGNED";
    }

    @Override
    @NotNull
    public String ulongAutoincType() {
        return "BIGINT UNSIGNED AUTO_INCREMENT";
    }

    @Override
    @NotNull
    public String textType() {
        return "text";
    }

    @Override
    @NotNull
    public String mediumTextType() {
        return "MEDIUMTEXT";
    }

    @Override
    @NotNull
    public String largeTextType() {
        return "LONGTEXT";
    }

    @Override
    public boolean booleanFromStringToBoolean(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        String string = value;
        return Intrinsics.areEqual(string, "0") ? false : (Intrinsics.areEqual(string, "1") ? true : Boolean.parseBoolean(value));
    }

    @Override
    @NotNull
    public String jsonBType() {
        return "JSON";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String processForDefaultValue(@NotNull Expression<?> e) {
        String string;
        Intrinsics.checkNotNullParameter(e, "e");
        if (e instanceof LiteralOp && ((LiteralOp)e).getColumnType() instanceof JsonColumnMarker) {
            DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
            Object object = databaseDialect instanceof MysqlDialect ? (MysqlDialect)databaseDialect : null;
            if (object == null || (object = ((MysqlDialect)object).getFullVersion$exposed_core()) == null) {
                object = "0";
            }
            if (((String)object).compareTo("8.0.13") < 0) throw new UnsupportedByDialectException("MySQL versions prior to 8.0.13 do not accept default values on JSON columns", DatabaseDialectKt.getCurrentDialect());
            string = '(' + super.processForDefaultValue(e) + ')';
            return string;
        }
        if (e instanceof ExpressionWithColumnType && ((ExpressionWithColumnType)e).getColumnType() instanceof IDateColumnType && StringsKt.startsWith$default(((ExpressionWithColumnType)e).toString(), "CURRENT_TIMESTAMP", false, 2, null)) {
            string = super.processForDefaultValue(e);
            return string;
        }
        if (!(e instanceof LiteralOp)) {
            DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
            Object object = databaseDialect instanceof MysqlDialect ? (MysqlDialect)databaseDialect : null;
            if (object == null || (object = ((MysqlDialect)object).getFullVersion$exposed_core()) == null) {
                object = "0";
            }
            if (((String)object).compareTo("8.0.13") >= 0) {
                string = '(' + super.processForDefaultValue(e) + ')';
                return string;
            }
        }
        string = super.processForDefaultValue(e);
        return string;
    }

    @Override
    public void precessOrderByClause(@NotNull QueryBuilder queryBuilder, @NotNull Expression<?> expression, @NotNull SortOrder sortOrder) {
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter((Object)sortOrder, "sortOrder");
        switch (WhenMappings.$EnumSwitchMapping$0[sortOrder.ordinal()]) {
            case 1: 
            case 2: {
                super.precessOrderByClause(queryBuilder, expression, sortOrder);
                break;
            }
            case 3: {
                super.precessOrderByClause(queryBuilder, expression, SortOrder.ASC);
                break;
            }
            case 4: {
                super.precessOrderByClause(queryBuilder, expression, SortOrder.DESC);
                break;
            }
            default: {
                Object object = expression instanceof IExpressionAlias ? (IExpressionAlias)((Object)expression) : null;
                if (object == null || (object = object.getAlias()) == null) {
                    object = expression;
                }
                Expression<?> exp = object;
                String nullExp = sortOrder == SortOrder.ASC_NULLS_LAST ? " IS NULL" : " IS NOT NULL";
                SortOrder order = sortOrder == SortOrder.ASC_NULLS_LAST ? SortOrder.ASC : SortOrder.DESC;
                Object[] objectArray = new Object[]{exp, nullExp, ", ", exp, " ", order.getCode()};
                ExpressionKt.append(queryBuilder, objectArray);
            }
        }
    }

    @Override
    @NotNull
    public String hexToDb(@NotNull String hexString) {
        Intrinsics.checkNotNullParameter(hexString, "hexString");
        return "0x" + hexString;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lru/astrainteractive/astrarating/libs/org/jetbrains/exposed/sql/vendors/MysqlDataTypeProvider$Companion;", "", "<init>", "()V", "INSTANCE", "Lru/astrainteractive/astrarating/libs/org/jetbrains/exposed/sql/vendors/MysqlDataTypeProvider;", "getINSTANCE$exposed_core", "()Lorg/jetbrains/exposed/sql/vendors/MysqlDataTypeProvider;", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MysqlDataTypeProvider getINSTANCE$exposed_core() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SortOrder.values().length];
            try {
                nArray[SortOrder.ASC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortOrder.DESC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortOrder.ASC_NULLS_FIRST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortOrder.DESC_NULLS_LAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

