/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astrarating.core.gui.util;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import ru.astrainteractive.astrarating.org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lru/astrainteractive/astrarating/core/gui/util/PlayerHeadUtil;", "", "<init>", "()V", "getHead", "Lorg/bukkit/inventory/ItemStack;", "player", "Lorg/bukkit/OfflinePlayer;", "playerName", "", "gui-bukkit"})
public final class PlayerHeadUtil {
    @NotNull
    public static final PlayerHeadUtil INSTANCE = new PlayerHeadUtil();

    private PlayerHeadUtil() {
    }

    @NotNull
    public final ItemStack getHead(@NotNull OfflinePlayer player) {
        Intrinsics.checkNotNullParameter(player, "player");
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta itemMeta = item.getItemMeta();
        Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.SkullMeta");
        SkullMeta meta = (SkullMeta)itemMeta;
        meta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)player.getUniqueId()));
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    @NotNull
    public final ItemStack getHead(@NotNull String playerName) {
        Intrinsics.checkNotNullParameter(playerName, "playerName");
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)playerName);
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
        return this.getHead(offlinePlayer);
    }
}

