/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.exceptions;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.exceptions.YamlEngineException;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character;
import ru.astrainteractive.astrarating.org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0010"}, d2={"Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/exceptions/ReaderException;", "Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/exceptions/YamlEngineException;", "name", "", "position", "", "codePoint", "message", "<init>", "(Ljava/lang/String;IILjava/lang/String;)V", "getName", "()Ljava/lang/String;", "getPosition", "()I", "getCodePoint", "toString", "snakeyaml-engine-kmp"})
public final class ReaderException
extends YamlEngineException {
    @NotNull
    private final String name;
    private final int position;
    private final int codePoint;

    public ReaderException(@NotNull String name, int position, int codePoint, @NotNull String message) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(message, "message");
        super(message);
        this.name = name;
        this.position = position;
        this.codePoint = codePoint;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getPosition() {
        return this.position;
    }

    public final int getCodePoint() {
        return this.codePoint;
    }

    @Override
    @NotNull
    public String toString() {
        String s = StringsKt.concatToString(Character.INSTANCE.toChars$snakeyaml_engine_kmp(this.codePoint));
        String string = Integer.toString(this.codePoint, CharsKt.checkRadix(16));
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
        String charHex = string2;
        return StringsKt.trimIndent("\n             unacceptable code point '" + s + "' (0x" + charHex + ") " + this.getMessage() + "\n             in \"" + this.name + "\", position " + this.position + "\n             ");
    }
}

