/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.scanner;

import java.io.Serializable;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.api.LoadSettings;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.comments.CommentType;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.common.Anchor;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.common.CharConstants;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.common.ScalarStyle;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.common.UriEncoder;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.exceptions.Mark;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.exceptions.ScannerException;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.exceptions.YamlEngineException;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.scanner.BreakIntentHolder;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.scanner.Chomping;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.scanner.Scanner;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.scanner.ScannerImplKt;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.scanner.SimpleKey;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.scanner.StreamReader;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.tokens.AliasToken;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.tokens.AnchorToken;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.tokens.BlockEndToken;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.tokens.BlockEntryToken;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.tokens.BlockMappingStartToken;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.tokens.BlockSequenceStartToken;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.tokens.CommentToken;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.tokens.DirectiveToken;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.tokens.DocumentEndToken;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.tokens.DocumentStartToken;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.tokens.FlowEntryToken;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.tokens.FlowMappingEndToken;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.tokens.FlowMappingStartToken;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.tokens.FlowSequenceEndToken;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.tokens.FlowSequenceStartToken;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.tokens.KeyToken;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.tokens.ScalarToken;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.tokens.StreamEndToken;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.tokens.StreamStartToken;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.tokens.TagToken;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.tokens.TagTuple;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.tokens.Token;
import ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.tokens.ValueToken;
import ru.astrainteractive.astrarating.okio.Buffer;
import ru.astrainteractive.astrarating.org.jetbrains.annotations.NotNull;
import ru.astrainteractive.astrarating.org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b'\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u008a\u00012\u00020\u0001:\u0002\u008a\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J!\u0010\u0017\u001a\u00020\u00112\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u001b\"\u00020\u0019H\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\nH\u0016J\t\u0010\u001e\u001a\u00020\u0011H\u0096\u0002J\t\u0010\u001f\u001a\u00020\nH\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\nH\u0002J\u0018\u0010\"\u001a\u00020!2\u0006\u0010$\u001a\u00020\f2\u0006\u0010#\u001a\u00020\nH\u0002J\u0016\u0010%\u001a\u00020!2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0&H\u0002J\b\u0010'\u001a\u00020\u0011H\u0002J\b\u0010(\u001a\u00020\u0011H\u0002J\b\u0010)\u001a\u00020\u0011H\u0002J\b\u0010*\u001a\u00020!H\u0002J\u000f\u0010+\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020!H\u0002J\b\u0010.\u001a\u00020!H\u0002J\b\u0010/\u001a\u00020!H\u0002J\u0010\u00100\u001a\u00020!2\u0006\u00101\u001a\u00020\fH\u0002J\u0010\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u00020\fH\u0002J\b\u00104\u001a\u00020!H\u0002J\b\u00105\u001a\u00020!H\u0002J\b\u00106\u001a\u00020!H\u0002J\b\u00107\u001a\u00020!H\u0002J\b\u00108\u001a\u00020!H\u0002J\u0010\u00109\u001a\u00020!2\u0006\u0010:\u001a\u00020\u0011H\u0002J\b\u0010;\u001a\u00020!H\u0002J\b\u0010<\u001a\u00020!H\u0002J\u0010\u0010=\u001a\u00020!2\u0006\u0010>\u001a\u00020\u0011H\u0002J\b\u0010?\u001a\u00020!H\u0002J\b\u0010@\u001a\u00020!H\u0002J\u0010\u0010A\u001a\u00020!2\u0006\u0010B\u001a\u00020\u0011H\u0002J\b\u0010C\u001a\u00020!H\u0002J\b\u0010D\u001a\u00020!H\u0002J\b\u0010E\u001a\u00020!H\u0002J\b\u0010F\u001a\u00020!H\u0002J\b\u0010G\u001a\u00020!H\u0002J\b\u0010H\u001a\u00020!H\u0002J\b\u0010I\u001a\u00020!H\u0002J\b\u0010J\u001a\u00020!H\u0002J\b\u0010K\u001a\u00020!H\u0002J\u0010\u0010L\u001a\u00020!2\u0006\u0010M\u001a\u00020NH\u0002J\b\u0010O\u001a\u00020!H\u0002J\b\u0010P\u001a\u00020!H\u0002J\u0012\u0010Q\u001a\u00020!2\b\u0010M\u001a\u0004\u0018\u00010NH\u0002J\b\u0010R\u001a\u00020!H\u0002J\b\u0010S\u001a\u00020\u0011H\u0002J\b\u0010T\u001a\u00020\u0011H\u0002J\b\u0010U\u001a\u00020\u0011H\u0002J\b\u0010V\u001a\u00020\u0011H\u0002J\b\u0010W\u001a\u00020\u0011H\u0002J\b\u0010X\u001a\u00020\u0011H\u0002J\b\u0010Y\u001a\u00020\u0011H\u0002J\b\u0010Z\u001a\u00020!H\u0002J\u0010\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020^H\u0002J\u000e\u0010_\u001a\b\u0012\u0004\u0012\u00020\n0&H\u0002J\u0012\u0010`\u001a\u00020a2\b\u0010b\u001a\u0004\u0018\u00010cH\u0002J\u0012\u0010d\u001a\u00020e2\b\u0010b\u001a\u0004\u0018\u00010cH\u0002J\u0012\u0010f\u001a\u00020\f2\b\u0010b\u001a\u0004\u0018\u00010cH\u0002J\u0012\u0010g\u001a\u00020h2\b\u0010b\u001a\u0004\u0018\u00010cH\u0002J\u0012\u0010i\u001a\u00020a2\b\u0010b\u001a\u0004\u0018\u00010cH\u0002J\u0012\u0010j\u001a\u00020a2\b\u0010b\u001a\u0004\u0018\u00010cH\u0002J\u0014\u0010k\u001a\u0004\u0018\u00010\\2\b\u0010b\u001a\u0004\u0018\u00010cH\u0002J\u0010\u0010l\u001a\u00020\n2\u0006\u0010m\u001a\u00020\u0011H\u0002J\b\u0010n\u001a\u00020\nH\u0002J\u0016\u0010o\u001a\b\u0012\u0004\u0012\u00020\n0&2\u0006\u0010M\u001a\u00020NH\u0002J\u0012\u0010p\u001a\u00020q2\b\u0010b\u001a\u0004\u0018\u00010cH\u0002J\u0014\u0010r\u001a\u0004\u0018\u00010\\2\b\u0010b\u001a\u0004\u0018\u00010cH\u0002J\b\u0010s\u001a\u00020tH\u0002J\u0010\u0010u\u001a\u00020t2\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u0010\u0010v\u001a\u00020\n2\u0006\u0010M\u001a\u00020NH\u0002J&\u0010w\u001a\u00020!2\u0006\u0010x\u001a\u00020\u00112\b\u0010b\u001a\u0004\u0018\u00010c2\n\u0010y\u001a\u00060zj\u0002`{H\u0002J\u001e\u0010|\u001a\u00020!2\b\u0010b\u001a\u0004\u0018\u00010c2\n\u0010y\u001a\u00060zj\u0002`{H\u0002J\u0012\u0010}\u001a\u00020a2\b\u0010b\u001a\u0004\u0018\u00010cH\u0002J\b\u0010~\u001a\u00020\nH\u0002J\b\u0010\u007f\u001a\u00020\u0011H\u0002J\t\u0010\u0080\u0001\u001a\u00020aH\u0002J\u001c\u0010\u0081\u0001\u001a\u00020a2\u0007\u0010\u0082\u0001\u001a\u00020a2\b\u0010b\u001a\u0004\u0018\u00010cH\u0002J&\u0010\u0083\u0001\u001a\u00020a2\u0007\u0010\u0082\u0001\u001a\u00020a2\b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\b\u0010b\u001a\u0004\u0018\u00010cH\u0002J\u001c\u0010\u0086\u0001\u001a\u00020a2\u0007\u0010\u0082\u0001\u001a\u00020a2\b\u0010b\u001a\u0004\u0018\u00010cH\u0002J\u000b\u0010\u0087\u0001\u001a\u0004\u0018\u00010aH\u0002J-\u0010\u0088\u0001\u001a\b\u0012\u0004\u0012\u00020\n0&2\u0016\u0010\b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\n0\u001b\"\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0003\u0010\u0089\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008b\u0001"}, d2={"Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/scanner/ScannerImpl;", "Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/scanner/Scanner;", "settings", "Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/api/LoadSettings;", "reader", "Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/scanner/StreamReader;", "<init>", "(Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/api/LoadSettings;Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/scanner/StreamReader;)V", "tokens", "Lkotlin/collections/ArrayDeque;", "Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/tokens/Token;", "indents", "", "possibleSimpleKeys", "", "Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/scanner/SimpleKey;", "done", "", "flowLevel", "lastToken", "tokensTaken", "indent", "allowSimpleKey", "checkToken", "choice", "Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/tokens/Token$ID;", "choices", "", "([Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/tokens/Token$ID;)Z", "peekToken", "hasNext", "next", "resetDocumentIndex", "", "addToken", "token", "index", "addAllTokens", "", "isBlockContext", "isFlowContext", "needMoreTokens", "fetchMoreTokens", "nextPossibleSimpleKey", "()Ljava/lang/Integer;", "stalePossibleSimpleKeys", "savePossibleSimpleKey", "removePossibleSimpleKey", "unwindIndent", "col", "addIndent", "column", "fetchStreamStart", "fetchStreamEnd", "fetchDirective", "fetchDocumentStart", "fetchDocumentEnd", "fetchDocumentIndicator", "isDocumentStart", "fetchFlowSequenceStart", "fetchFlowMappingStart", "fetchFlowCollectionStart", "isMappingStart", "fetchFlowSequenceEnd", "fetchFlowMappingEnd", "fetchFlowCollectionEnd", "isMappingEnd", "fetchFlowEntry", "fetchBlockEntry", "fetchKey", "fetchValue", "fetchAlias", "fetchAnchor", "fetchTag", "fetchLiteral", "fetchFolded", "fetchBlockScalar", "style", "Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/common/ScalarStyle;", "fetchSingle", "fetchDouble", "fetchFlowScalar", "fetchPlain", "checkDirective", "checkDocumentStart", "checkDocumentEnd", "checkBlockEntry", "checkKey", "checkValue", "checkPlain", "scanToNextToken", "scanComment", "Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/tokens/CommentToken;", "type", "Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/comments/CommentType;", "scanDirective", "scanDirectiveName", "", "startMark", "Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/exceptions/Mark;", "scanYamlDirectiveValue", "Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/tokens/DirectiveToken$YamlDirective;", "scanYamlDirectiveNumber", "scanTagDirectiveValue", "Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/tokens/DirectiveToken$TagDirective;", "scanTagDirectiveHandle", "scanTagDirectivePrefix", "scanDirectiveIgnoredLine", "scanAnchor", "isAnchor", "scanTag", "scanBlockScalar", "scanBlockScalarIndicators", "Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/scanner/Chomping;", "scanBlockScalarIgnoredLine", "scanBlockScalarIndentation", "Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/scanner/BreakIntentHolder;", "scanBlockScalarBreaks", "scanFlowScalar", "scanFlowScalarNonSpaces", "doubleQuoted", "chunks", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "scanFlowScalarSpaces", "scanFlowScalarBreaks", "scanPlain", "atEndOfPlain", "scanPlainSpaces", "scanTagHandle", "name", "scanTagUri", "range", "Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/common/CharConstants;", "scanUriEscapes", "scanLineBreak", "makeTokenList", "([Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/tokens/Token;)Ljava/util/List;", "Companion", "snakeyaml-engine-kmp"})
@SourceDebugExtension(value={"SMAP\nScannerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScannerImpl.kt\nit/krzeminski/snakeyaml/engine/kmp/scanner/ScannerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,2320:1\n774#2:2321\n865#2,2:2322\n*S KotlinDebug\n*F\n+ 1 ScannerImpl.kt\nit/krzeminski/snakeyaml/engine/kmp/scanner/ScannerImpl\n*L\n2217#1:2321\n2217#1:2322,2\n*E\n"})
public final class ScannerImpl
implements Scanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LoadSettings settings;
    @NotNull
    private final StreamReader reader;
    @NotNull
    private final ArrayDeque<Token> tokens;
    @NotNull
    private final ArrayDeque<Integer> indents;
    @NotNull
    private final Map<Integer, SimpleKey> possibleSimpleKeys;
    private boolean done;
    private int flowLevel;
    @Nullable
    private Token lastToken;
    private int tokensTaken;
    private int indent;
    private boolean allowSimpleKey;
    @NotNull
    private static final String DIRECTIVE_PREFIX = "while scanning a directive";
    @NotNull
    private static final String EXPECTED_ALPHA_ERROR_PREFIX = "expected alphabetic or numeric character, but found ";
    @NotNull
    private static final String SCANNING_SCALAR = "while scanning a block scalar";
    @NotNull
    private static final String SCANNING_PREFIX = "while scanning a ";
    @NotNull
    private static final Regex NOT_HEXA = new Regex("[^0-9A-Fa-f]");

    public ScannerImpl(@NotNull LoadSettings settings, @NotNull StreamReader reader) {
        Intrinsics.checkNotNullParameter(settings, "settings");
        Intrinsics.checkNotNullParameter(reader, "reader");
        this.settings = settings;
        this.reader = reader;
        this.tokens = new ArrayDeque(100);
        this.indents = new ArrayDeque(10);
        this.possibleSimpleKeys = new LinkedHashMap();
        this.indent = -1;
        this.allowSimpleKey = true;
        this.fetchStreamStart();
    }

    @Override
    public boolean checkToken(@NotNull Token.ID choice) {
        Intrinsics.checkNotNullParameter((Object)choice, "choice");
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        if (!this.tokens.isEmpty()) {
            return this.tokens.get(0).getTokenId() == choice;
        }
        return false;
    }

    @Override
    public boolean checkToken(Token.ID ... choices) {
        Token.ID firstTokenId;
        Intrinsics.checkNotNullParameter(choices, "choices");
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        Token token = this.tokens.firstOrNull();
        Token.ID iD = firstTokenId = token != null ? token.getTokenId() : null;
        return firstTokenId != null && (choices.length == 0 || ArraysKt.contains(choices, firstTokenId));
    }

    @Override
    @NotNull
    public Token peekToken() {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        return this.tokens.first();
    }

    @Override
    public boolean hasNext() {
        return this.checkToken(new Token.ID[0]);
    }

    @Override
    @NotNull
    public Token next() {
        int n = this.tokensTaken;
        this.tokensTaken = n + 1;
        Token token = this.tokens.removeFirstOrNull();
        if (token == null) {
            throw new NoSuchElementException("No more Tokens found.");
        }
        return token;
    }

    @Override
    public void resetDocumentIndex() {
        this.reader.resetDocumentIndex();
    }

    private final void addToken(Token token) {
        this.lastToken = token;
        this.tokens.addLast(token);
    }

    private final void addToken(int index, Token token) {
        if (index == this.tokens.size()) {
            this.lastToken = token;
        }
        this.tokens.add(index, token);
    }

    private final void addAllTokens(List<? extends Token> tokens) {
        this.lastToken = CollectionsKt.last(tokens);
        CollectionsKt.addAll((Collection)this.tokens, (Iterable)tokens);
    }

    private final boolean isBlockContext() {
        return this.flowLevel == 0;
    }

    private final boolean isFlowContext() {
        return !this.isBlockContext();
    }

    private final boolean needMoreTokens() {
        if (this.done) {
            return false;
        }
        if (this.tokens.isEmpty()) {
            return true;
        }
        this.stalePossibleSimpleKeys();
        Integer n = this.nextPossibleSimpleKey();
        int n2 = this.tokensTaken;
        return n != null && n == n2;
    }

    private final void fetchMoreTokens() {
        if (this.reader.getDocumentIndex() > this.settings.codePointLimit) {
            throw new YamlEngineException("The incoming YAML document exceeds the limit: " + this.settings.codePointLimit + " code points.");
        }
        this.scanToNextToken();
        this.stalePossibleSimpleKeys();
        this.unwindIndent(this.reader.getColumn());
        int c = this.reader.peek();
        if (c == 0) {
            this.fetchStreamEnd();
            return;
        }
        switch ((char)c) {
            case '%': {
                if (!this.checkDirective()) break;
                this.fetchDirective();
                return;
            }
            case '-': {
                if (this.checkDocumentStart()) {
                    this.fetchDocumentStart();
                    return;
                }
                if (!this.checkBlockEntry()) break;
                this.fetchBlockEntry();
                return;
            }
            case '.': {
                if (!this.checkDocumentEnd()) break;
                this.fetchDocumentEnd();
                return;
            }
            case '[': {
                this.fetchFlowSequenceStart();
                return;
            }
            case '{': {
                this.fetchFlowMappingStart();
                return;
            }
            case ']': {
                this.fetchFlowSequenceEnd();
                return;
            }
            case '}': {
                this.fetchFlowMappingEnd();
                return;
            }
            case ',': {
                this.fetchFlowEntry();
                return;
            }
            case '?': {
                if (!this.checkKey()) break;
                this.fetchKey();
                return;
            }
            case ':': {
                if (!this.checkValue()) break;
                this.fetchValue();
                return;
            }
            case '*': {
                this.fetchAlias();
                return;
            }
            case '&': {
                this.fetchAnchor();
                return;
            }
            case '!': {
                this.fetchTag();
                return;
            }
            case '|': {
                if (!this.isBlockContext()) break;
                this.fetchLiteral();
                return;
            }
            case '>': {
                if (!this.isBlockContext()) break;
                this.fetchFolded();
                return;
            }
            case '\'': {
                this.fetchSingle();
                return;
            }
            case '\"': {
                this.fetchDouble();
                return;
            }
        }
        if (this.checkPlain()) {
            this.fetchPlain();
            return;
        }
        String chRepresentation = CharConstants.Companion.escapeChar(ArraysKt.first(ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c)));
        if (c == 9) {
            chRepresentation = chRepresentation + "(TAB)";
        }
        String string = "found character '" + chRepresentation + "' that cannot start any token. (Do not use " + chRepresentation + " for indentation)";
        Mark mark = this.reader.getMark();
        throw new ScannerException(string, mark, "while scanning for the next token", null, null, 16, null);
    }

    private final Integer nextPossibleSimpleKey() {
        SimpleKey simpleKey = (SimpleKey)CollectionsKt.firstOrNull((Iterable)this.possibleSimpleKeys.values());
        return simpleKey != null ? Integer.valueOf(simpleKey.getTokenNumber()) : null;
    }

    private final void stalePossibleSimpleKeys() {
        Iterator<Map.Entry<Integer, SimpleKey>> iterator2 = this.possibleSimpleKeys.entrySet().iterator();
        while (iterator2.hasNext()) {
            SimpleKey key = iterator2.next().getValue();
            if (key.getLine() == this.reader.getLine() && this.reader.getIndex() - key.getIndex() <= 1024) continue;
            if (key.isRequired()) {
                Mark mark = key.getMark();
                Mark mark2 = this.reader.getMark();
                throw new ScannerException("could not find expected ':'", mark2, "while scanning a simple key", mark, null, 16, null);
            }
            iterator2.remove();
        }
    }

    private final void savePossibleSimpleKey() {
        boolean required;
        boolean bl = required = this.isBlockContext() && this.indent == this.reader.getColumn();
        if (!this.allowSimpleKey && required) {
            throw new YamlEngineException("A simple key is required only if it is the first token in the current line");
        }
        if (this.allowSimpleKey) {
            this.removePossibleSimpleKey();
            int tokenNumber = this.tokensTaken + this.tokens.size();
            SimpleKey key = new SimpleKey(tokenNumber, required, this.reader.getIndex(), this.reader.getLine(), this.reader.getColumn(), this.reader.getMark());
            this.possibleSimpleKeys.put(this.flowLevel, key);
        }
    }

    private final void removePossibleSimpleKey() {
        SimpleKey key = this.possibleSimpleKeys.remove(this.flowLevel);
        if (key != null && key.isRequired()) {
            Mark mark = key.getMark();
            Mark mark2 = this.reader.getMark();
            throw new ScannerException("could not find expected ':'", mark2, "while scanning a simple key", mark, null, 16, null);
        }
    }

    private final void unwindIndent(int col) {
        if (this.isFlowContext()) {
            return;
        }
        while (this.indent > col) {
            Mark mark = this.reader.getMark();
            this.indent = ((Number)this.indents.removeLast()).intValue();
            this.addToken(new BlockEndToken(mark, mark));
        }
    }

    private final boolean addIndent(int column) {
        if (this.indent >= column) {
            return false;
        }
        this.indents.addLast(this.indent);
        this.indent = column;
        return true;
    }

    private final void fetchStreamStart() {
        Mark mark = this.reader.getMark();
        Token token = new StreamStartToken(mark, mark);
        this.addToken(token);
    }

    private final void fetchStreamEnd() {
        this.unwindIndent(-1);
        this.removePossibleSimpleKey();
        this.allowSimpleKey = false;
        this.possibleSimpleKeys.clear();
        Mark mark = this.reader.getMark();
        Token token = new StreamEndToken(mark, mark);
        this.addToken(token);
        this.done = true;
    }

    private final void fetchDirective() {
        this.unwindIndent(-1);
        this.removePossibleSimpleKey();
        this.allowSimpleKey = false;
        List<Token> tok = this.scanDirective();
        this.addAllTokens(tok);
    }

    private final void fetchDocumentStart() {
        this.fetchDocumentIndicator(true);
    }

    private final void fetchDocumentEnd() {
        this.fetchDocumentIndicator(false);
    }

    private final void fetchDocumentIndicator(boolean isDocumentStart) {
        this.unwindIndent(-1);
        this.removePossibleSimpleKey();
        this.allowSimpleKey = false;
        Mark startMark = this.reader.getMark();
        this.reader.forward(3);
        Mark endMark = this.reader.getMark();
        Token token = isDocumentStart ? (Token)new DocumentStartToken(startMark, endMark) : (Token)new DocumentEndToken(startMark, endMark);
        this.addToken(token);
    }

    private final void fetchFlowSequenceStart() {
        this.fetchFlowCollectionStart(false);
    }

    private final void fetchFlowMappingStart() {
        this.fetchFlowCollectionStart(true);
    }

    private final void fetchFlowCollectionStart(boolean isMappingStart) {
        this.savePossibleSimpleKey();
        int n = this.flowLevel;
        this.flowLevel = n + 1;
        this.allowSimpleKey = true;
        Mark startMark = this.reader.getMark();
        this.reader.forward(1);
        Mark endMark = this.reader.getMark();
        Token token = isMappingStart ? (Token)new FlowMappingStartToken(startMark, endMark) : (Token)new FlowSequenceStartToken(startMark, endMark);
        this.addToken(token);
    }

    private final void fetchFlowSequenceEnd() {
        this.fetchFlowCollectionEnd(false);
    }

    private final void fetchFlowMappingEnd() {
        this.fetchFlowCollectionEnd(true);
    }

    private final void fetchFlowCollectionEnd(boolean isMappingEnd) {
        this.removePossibleSimpleKey();
        int n = this.flowLevel;
        this.flowLevel = n + -1;
        this.allowSimpleKey = false;
        Mark startMark = this.reader.getMark();
        StreamReader.forward$default(this.reader, 0, 1, null);
        Mark endMark = this.reader.getMark();
        Token token = isMappingEnd ? (Token)new FlowMappingEndToken(startMark, endMark) : (Token)new FlowSequenceEndToken(startMark, endMark);
        this.addToken(token);
    }

    private final void fetchFlowEntry() {
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        Mark startMark = this.reader.getMark();
        StreamReader.forward$default(this.reader, 0, 1, null);
        Mark endMark = this.reader.getMark();
        FlowEntryToken token = new FlowEntryToken(startMark, endMark);
        this.addToken(token);
    }

    private final void fetchBlockEntry() {
        if (this.isBlockContext()) {
            if (!this.allowSimpleKey) {
                throw new ScannerException("", null, "sequence entries are not allowed here", this.reader.getMark(), null, 16, null);
            }
            if (this.addIndent(this.reader.getColumn())) {
                Mark mark = this.reader.getMark();
                this.addToken(new BlockSequenceStartToken(mark, mark));
            }
        }
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        Mark startMark = this.reader.getMark();
        StreamReader.forward$default(this.reader, 0, 1, null);
        Mark endMark = this.reader.getMark();
        Token token = new BlockEntryToken(startMark, endMark);
        this.addToken(token);
    }

    private final void fetchKey() {
        if (this.isBlockContext()) {
            if (!this.allowSimpleKey) {
                throw new ScannerException("mapping keys are not allowed here", this.reader.getMark(), null, null, null, 28, null);
            }
            if (this.addIndent(this.reader.getColumn())) {
                Mark mark = this.reader.getMark();
                this.addToken(new BlockMappingStartToken(mark, mark));
            }
        }
        this.allowSimpleKey = this.isBlockContext();
        this.removePossibleSimpleKey();
        Mark startMark = this.reader.getMark();
        StreamReader.forward$default(this.reader, 0, 1, null);
        Mark endMark = this.reader.getMark();
        Token token = new KeyToken(startMark, endMark);
        this.addToken(token);
    }

    private final void fetchValue() {
        SimpleKey key = this.possibleSimpleKeys.remove(this.flowLevel);
        if (key != null) {
            this.addToken(key.getTokenNumber() - this.tokensTaken, new KeyToken(key.getMark(), key.getMark()));
            if (this.isBlockContext() && this.addIndent(key.getColumn())) {
                this.addToken(key.getTokenNumber() - this.tokensTaken, new BlockMappingStartToken(key.getMark(), key.getMark()));
            }
            this.allowSimpleKey = false;
        } else {
            if (this.isBlockContext() && !this.allowSimpleKey) {
                throw new ScannerException("mapping values are not allowed here", this.reader.getMark(), null, null, null, 28, null);
            }
            if (this.isBlockContext() && this.addIndent(this.reader.getColumn())) {
                Mark mark = this.reader.getMark();
                this.addToken(new BlockMappingStartToken(mark, mark));
            }
            this.allowSimpleKey = this.isBlockContext();
            this.removePossibleSimpleKey();
        }
        Mark startMark = this.reader.getMark();
        StreamReader.forward$default(this.reader, 0, 1, null);
        Mark endMark = this.reader.getMark();
        Token token = new ValueToken(startMark, endMark);
        this.addToken(token);
    }

    private final void fetchAlias() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanAnchor(false);
        this.addToken(tok);
    }

    private final void fetchAnchor() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanAnchor(true);
        this.addToken(tok);
    }

    private final void fetchTag() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanTag();
        this.addToken(token);
    }

    private final void fetchLiteral() {
        this.fetchBlockScalar(ScalarStyle.LITERAL);
    }

    private final void fetchFolded() {
        this.fetchBlockScalar(ScalarStyle.FOLDED);
    }

    private final void fetchBlockScalar(ScalarStyle style) {
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        List<Token> tok = this.scanBlockScalar(style);
        this.addAllTokens(tok);
    }

    private final void fetchSingle() {
        this.fetchFlowScalar(ScalarStyle.SINGLE_QUOTED);
    }

    private final void fetchDouble() {
        this.fetchFlowScalar(ScalarStyle.DOUBLE_QUOTED);
    }

    private final void fetchFlowScalar(ScalarStyle style) {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        ScalarStyle scalarStyle = style;
        Intrinsics.checkNotNull((Object)scalarStyle);
        Token tok = this.scanFlowScalar(scalarStyle);
        this.addToken(tok);
    }

    private final void fetchPlain() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanPlain();
        this.addToken(tok);
    }

    private final boolean checkDirective() {
        return this.reader.getColumn() == 0;
    }

    private final boolean checkDocumentStart() {
        return this.checkDirective() && Intrinsics.areEqual("---", this.reader.prefix(3)) && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(3));
    }

    private final boolean checkDocumentEnd() {
        return this.checkDirective() && Intrinsics.areEqual("...", this.reader.prefix(3)) && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(3));
    }

    private final boolean checkBlockEntry() {
        return CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(1));
    }

    private final boolean checkKey() {
        return CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(1));
    }

    private final boolean checkValue() {
        return this.isFlowContext() || CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(1));
    }

    private final boolean checkPlain() {
        int c = this.reader.peek();
        boolean notForbidden = CharConstants.NULL_BL_T_LINEBR.hasNo(c, "-?:,[]{}#&*!|>'\"%@`");
        return notForbidden ? true : (this.isBlockContext() ? CharConstants.NULL_BL_T_LINEBR.hasNo(this.reader.peek(1)) && StringsKt.contains$default((CharSequence)"-?:", (char)c, false, 2, null) : CharConstants.NULL_BL_T_LINEBR.hasNo(this.reader.peek(1), ",]") && StringsKt.contains$default((CharSequence)"-?", (char)c, false, 2, null));
    }

    /*
     * Unable to fully structure code
     */
    private final void scanToNextToken() {
        found = false;
        inlineStartColumn = -1;
        while (!found) {
            block11: {
                startMark = this.reader.getMark();
                columnBeforeComment = this.reader.getColumn();
                commentSeen = false;
                ff = 0;
                while (this.reader.peek(ff) == 32) {
                    ++ff;
                }
                if (this.reader.peek(ff) == 9 && this.isFlowContext()) {
                    ++ff;
                }
                if (ff > 0) {
                    this.reader.forward(ff);
                }
                if (this.reader.peek() != 35) break block11;
                commentSeen = true;
                type = null;
                if (columnBeforeComment == 0) ** GOTO lbl-1000
                if (this.lastToken == null) ** GOTO lbl-1000
                v0 = this.lastToken;
                if ((v0 != null ? v0.getTokenId() : null) != Token.ID.BlockEntry) lbl-1000:
                // 2 sources

                {
                    type = CommentType.IN_LINE;
                    inlineStartColumn = this.reader.getColumn();
                } else if (inlineStartColumn == this.reader.getColumn()) {
                    type = CommentType.IN_LINE;
                } else {
                    inlineStartColumn = -1;
                    type = CommentType.BLOCK;
                }
                token = this.scanComment(type);
                if (this.settings.parseComments) {
                    this.addToken(token);
                }
            }
            if ((breaksOpt = this.scanLineBreak()) != null) {
                if (this.settings.parseComments && !commentSeen && columnBeforeComment == 0) {
                    this.addToken(new CommentToken(CommentType.BLANK_LINE, breaksOpt, startMark, this.reader.getMark()));
                }
                if (!this.isBlockContext()) continue;
                this.allowSimpleKey = true;
                continue;
            }
            found = true;
        }
    }

    private final CommentToken scanComment(CommentType type) {
        Mark startMark = this.reader.getMark();
        StreamReader.forward$default(this.reader, 0, 1, null);
        int length = 0;
        while (CharConstants.NULL_OR_LINEBR.hasNo(this.reader.peek(length))) {
            ++length;
        }
        String value = this.reader.prefixForward(length);
        Mark endMark = this.reader.getMark();
        return new CommentToken(type, value, startMark, endMark);
    }

    private final List<Token> scanDirective() {
        Mark startMark = this.reader.getMark();
        Mark endMark = null;
        StreamReader.forward$default(this.reader, 0, 1, null);
        String name = this.scanDirectiveName(startMark);
        DirectiveToken.TokenValue value = null;
        if (Intrinsics.areEqual("YAML", name)) {
            value = this.scanYamlDirectiveValue(startMark);
            endMark = this.reader.getMark();
        } else if (Intrinsics.areEqual("TAG", name)) {
            value = this.scanTagDirectiveValue(startMark);
            endMark = this.reader.getMark();
        } else {
            endMark = this.reader.getMark();
            int ff = 0;
            while (CharConstants.NULL_OR_LINEBR.hasNo(this.reader.peek(ff))) {
                ++ff;
            }
            if (ff > 0) {
                this.reader.forward(ff);
            }
            value = null;
        }
        CommentToken commentToken = this.scanDirectiveIgnoredLine(startMark);
        DirectiveToken token = new DirectiveToken(value, startMark, endMark);
        Token[] tokenArray = new Token[]{token, commentToken};
        return this.makeTokenList(tokenArray);
    }

    private final String scanDirectiveName(Mark startMark) {
        int length = 0;
        int c = this.reader.peek(length);
        while (CharConstants.ALPHA.has(c)) {
            c = this.reader.peek(++length);
        }
        if (length == 0) {
            String s = StringsKt.concatToString(ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException(DIRECTIVE_PREFIX, startMark, EXPECTED_ALPHA_ERROR_PREFIX + s + '(' + c + ')', this.reader.getMark(), null, 16, null);
        }
        String value = this.reader.prefixForward(length);
        c = this.reader.peek();
        if (CharConstants.NULL_BL_LINEBR.hasNo(c)) {
            String s = StringsKt.concatToString(ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException(DIRECTIVE_PREFIX, startMark, EXPECTED_ALPHA_ERROR_PREFIX + s + '(' + c + ')', this.reader.getMark(), null, 16, null);
        }
        return value;
    }

    private final DirectiveToken.YamlDirective scanYamlDirectiveValue(Mark startMark) {
        while (this.reader.peek() == 32) {
            StreamReader.forward$default(this.reader, 0, 1, null);
        }
        int major = this.scanYamlDirectiveNumber(startMark);
        int c = this.reader.peek();
        if (c != 46) {
            String s = StringsKt.concatToString(ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException(DIRECTIVE_PREFIX, startMark, "expected a digit or '.', but found " + s + '(' + c + ')', this.reader.getMark(), null, 16, null);
        }
        StreamReader.forward$default(this.reader, 0, 1, null);
        int minor = this.scanYamlDirectiveNumber(startMark);
        c = this.reader.peek();
        if (CharConstants.NULL_BL_LINEBR.hasNo(c)) {
            String s = StringsKt.concatToString(ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException(DIRECTIVE_PREFIX, startMark, "expected a digit or ' ', but found " + s + '(' + c + ')', this.reader.getMark(), null, 16, null);
        }
        return new DirectiveToken.YamlDirective(major, minor);
    }

    private final int scanYamlDirectiveNumber(Mark startMark) {
        int c = this.reader.peek();
        if (!Character.isDigit((char)c)) {
            String s = StringsKt.concatToString(ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException(DIRECTIVE_PREFIX, startMark, "expected a digit, but found " + s + '(' + c + ')', this.reader.getMark(), null, 16, null);
        }
        int length = 0;
        while (Character.isDigit((char)this.reader.peek(length))) {
            ++length;
        }
        String number = this.reader.prefixForward(length);
        if (length > 3) {
            throw new ScannerException("while scanning a YAML directive", startMark, "found a number which cannot represent a valid version: " + number, this.reader.getMark(), null, 16, null);
        }
        return Integer.parseInt(number);
    }

    private final DirectiveToken.TagDirective scanTagDirectiveValue(Mark startMark) {
        while (this.reader.peek() == 32) {
            StreamReader.forward$default(this.reader, 0, 1, null);
        }
        String handle = this.scanTagDirectiveHandle(startMark);
        while (this.reader.peek() == 32) {
            StreamReader.forward$default(this.reader, 0, 1, null);
        }
        String prefix = this.scanTagDirectivePrefix(startMark);
        return new DirectiveToken.TagDirective(handle, prefix);
    }

    private final String scanTagDirectiveHandle(Mark startMark) {
        String value = this.scanTagHandle("directive", startMark);
        int c = this.reader.peek();
        if (c != 32) {
            String s = StringsKt.concatToString(ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException(DIRECTIVE_PREFIX, startMark, "expected ' ', but found " + s + '(' + c + ')', this.reader.getMark(), null, 16, null);
        }
        return value;
    }

    private final String scanTagDirectivePrefix(Mark startMark) {
        String value = this.scanTagUri("directive", CharConstants.URI_CHARS_FOR_TAG_PREFIX, startMark);
        int c = this.reader.peek();
        if (CharConstants.NULL_BL_LINEBR.hasNo(c)) {
            String s = StringsKt.concatToString(ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException(DIRECTIVE_PREFIX, startMark, "expected ' ', but found " + s + '(' + c + ')', this.reader.getMark(), null, 16, null);
        }
        return value;
    }

    private final CommentToken scanDirectiveIgnoredLine(Mark startMark) {
        while (this.reader.peek() == 32) {
            StreamReader.forward$default(this.reader, 0, 1, null);
        }
        CommentToken commentToken = null;
        if (this.reader.peek() == 35) {
            CommentToken comment = this.scanComment(CommentType.IN_LINE);
            if (this.settings.parseComments) {
                commentToken = comment;
            }
        }
        int c = this.reader.peek();
        if (this.scanLineBreak() == null && c != 0) {
            String s = StringsKt.concatToString(ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException(DIRECTIVE_PREFIX, startMark, "expected a comment or a line break, but found " + s + '(' + c + ')', this.reader.getMark(), null, 16, null);
        }
        return commentToken;
    }

    private final Token scanAnchor(boolean isAnchor) {
        Mark startMark = this.reader.getMark();
        int indicator = this.reader.peek();
        String name = indicator == 42 ? "alias" : "anchor";
        StreamReader.forward$default(this.reader, 0, 1, null);
        int length = 0;
        int c = this.reader.peek(length);
        while (CharConstants.NULL_BL_T_LINEBR.hasNo(c, ",[]{}/.*&")) {
            c = this.reader.peek(++length);
        }
        if (length == 0) {
            String s = StringsKt.concatToString(ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException("while scanning an " + name, startMark, "unexpected character found " + s + '(' + c + ')', this.reader.getMark(), null, 16, null);
        }
        String value = this.reader.prefixForward(length);
        c = this.reader.peek();
        if (CharConstants.NULL_BL_T_LINEBR.hasNo(c, "?:,]}%@`")) {
            String s = StringsKt.concatToString(ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException("while scanning an " + name, startMark, "unexpected character found " + s + '(' + c + ')', this.reader.getMark(), null, 16, null);
        }
        Mark endMark = this.reader.getMark();
        return isAnchor ? (Token)new AnchorToken(new Anchor(value), startMark, endMark) : (Token)new AliasToken(new Anchor(value), startMark, endMark);
    }

    private final Token scanTag() {
        Mark startMark = this.reader.getMark();
        int c = this.reader.peek(1);
        String handle = null;
        String suffix = null;
        if (c == 60) {
            this.reader.forward(2);
            suffix = this.scanTagUri("tag", CharConstants.URI_CHARS_FOR_TAG_PREFIX, startMark);
            c = this.reader.peek();
            if (c != 62) {
                String s = StringsKt.concatToString(ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
                throw new ScannerException("while scanning a tag", startMark, "expected '>', but found '" + s + "' (" + c + ')', this.reader.getMark(), null, 16, null);
            }
            handle = null;
            StreamReader.forward$default(this.reader, 0, 1, null);
        } else if (CharConstants.NULL_BL_T_LINEBR.has(c)) {
            suffix = "!";
            handle = null;
            StreamReader.forward$default(this.reader, 0, 1, null);
        } else {
            int length = 1;
            boolean useHandle = false;
            while (CharConstants.NULL_BL_LINEBR.hasNo(c)) {
                if (c == 33) {
                    useHandle = true;
                    break;
                }
                c = this.reader.peek(++length);
            }
            if (useHandle) {
                handle = this.scanTagHandle("tag", startMark);
            } else {
                handle = "!";
                StreamReader.forward$default(this.reader, 0, 1, null);
            }
            suffix = this.scanTagUri("tag", CharConstants.URI_CHARS_FOR_TAG_SUFFIX, startMark);
        }
        c = this.reader.peek();
        if (CharConstants.NULL_BL_LINEBR.hasNo(c)) {
            String s = StringsKt.concatToString(ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException("while scanning a tag", startMark, "expected ' ', but found '" + s + "' (" + c + ')', this.reader.getMark(), null, 16, null);
        }
        TagTuple value = new TagTuple(handle, suffix);
        Mark endMark = this.reader.getMark();
        return new TagToken(value, startMark, endMark);
    }

    private final List<Token> scanBlockScalar(ScalarStyle style) {
        BreakIntentHolder brme;
        StringBuilder stringBuilder = new StringBuilder();
        Mark startMark = this.reader.getMark();
        StreamReader.forward$default(this.reader, 0, 1, null);
        Chomping chomping = this.scanBlockScalarIndicators(startMark);
        CommentToken commentToken = this.scanBlockScalarIgnoredLine(startMark);
        int minIndent = RangesKt.coerceAtLeast(this.indent + 1, 1);
        String breaks = null;
        int maxIndent = 0;
        int blockIndent = 0;
        Mark endMark = null;
        Integer chompingIncrement = chomping.getIncrement();
        if (chompingIncrement == null) {
            brme = this.scanBlockScalarIndentation();
            breaks = brme.getBreaks();
            maxIndent = brme.getMaxIndent();
            endMark = brme.getEndMark();
            blockIndent = RangesKt.coerceAtLeast(minIndent, maxIndent);
        } else {
            blockIndent = minIndent + chompingIncrement - 1;
            brme = this.scanBlockScalarBreaks(blockIndent);
            breaks = brme.getBreaks();
            endMark = brme.getEndMark();
        }
        String lineBreak = null;
        while (this.reader.getColumn() == blockIndent && this.reader.peek() != 0) {
            stringBuilder.append(breaks);
            boolean leadingNonSpace = !StringsKt.contains$default((CharSequence)" \t", (char)this.reader.peek(), false, 2, null);
            int length = 0;
            while (CharConstants.NULL_OR_LINEBR.hasNo(this.reader.peek(length))) {
                ++length;
            }
            stringBuilder.append(this.reader.prefixForward(length));
            lineBreak = this.scanLineBreak();
            BreakIntentHolder brme2 = this.scanBlockScalarBreaks(blockIndent);
            breaks = brme2.getBreaks();
            endMark = brme2.getEndMark();
            if (this.reader.getColumn() != blockIndent || this.reader.peek() == 0) break;
            if (style == ScalarStyle.FOLDED && Intrinsics.areEqual("\n", lineBreak) && leadingNonSpace && !StringsKt.contains$default((CharSequence)" \t", (char)this.reader.peek(), false, 2, null)) {
                if (!(((CharSequence)breaks).length() == 0)) continue;
                stringBuilder.append(' ');
                continue;
            }
            String string = lineBreak;
            if (string == null) {
                string = "";
            }
            stringBuilder.append(string);
        }
        if (chomping.getAddExistingFinalLineBreak()) {
            String string = lineBreak;
            if (string == null) {
                string = "";
            }
            stringBuilder.append(string);
        }
        if (chomping.getRetainTrailingEmptyLines()) {
            stringBuilder.append(breaks);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        ScalarToken scalarToken = new ScalarToken(string, false, startMark, endMark, style);
        Token[] tokenArray = new Token[]{commentToken, scalarToken};
        return this.makeTokenList(tokenArray);
    }

    private final Chomping scanBlockScalarIndicators(Mark startMark) {
        int incr;
        Integer indicator = null;
        Integer increment = null;
        int c = this.reader.peek();
        if (c == 45 || c == 43) {
            indicator = c;
            StreamReader.forward$default(this.reader, 0, 1, null);
            c = this.reader.peek();
            if (Character.isDigit((char)c)) {
                incr = Integer.parseInt(StringsKt.concatToString(ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c)));
                if (incr == 0) {
                    throw new ScannerException(SCANNING_SCALAR, startMark, "expected indentation indicator in the range 1-9, but found 0", this.reader.getMark(), null, 16, null);
                }
                increment = incr;
                StreamReader.forward$default(this.reader, 0, 1, null);
            } else {
                increment = null;
            }
        } else if (Character.isDigit((char)c)) {
            incr = Integer.parseInt(StringsKt.concatToString(ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c)));
            if (incr == 0) {
                throw new ScannerException(SCANNING_SCALAR, startMark, "expected indentation indicator in the range 1-9, but found 0", this.reader.getMark(), null, 16, null);
            }
            increment = incr;
            StreamReader.forward$default(this.reader, 0, 1, null);
            c = this.reader.peek();
            switch (c) {
                case 43: 
                case 45: {
                    indicator = c;
                    StreamReader.forward$default(this.reader, 0, 1, null);
                    break;
                }
                default: {
                    indicator = null;
                    break;
                }
            }
        } else {
            increment = null;
            indicator = null;
        }
        c = this.reader.peek();
        if (CharConstants.NULL_BL_LINEBR.hasNo(c)) {
            String s = StringsKt.concatToString(ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException(SCANNING_SCALAR, startMark, "expected chomping or indentation indicators, but found " + s + '(' + c + ')', this.reader.getMark(), null, 16, null);
        }
        Chomping chomping = ScannerImplKt.access$Chomping(indicator, increment);
        if (chomping == null) {
            throw new IllegalArgumentException("Unexpected block chomping indicator: " + indicator);
        }
        return chomping;
    }

    private final CommentToken scanBlockScalarIgnoredLine(Mark startMark) {
        while (this.reader.peek() == 32) {
            StreamReader.forward$default(this.reader, 0, 1, null);
        }
        CommentToken commentToken = this.reader.peek() == 35 ? this.scanComment(CommentType.IN_LINE) : null;
        int c = this.reader.peek();
        if (this.scanLineBreak() == null && c != 0) {
            String s = StringsKt.concatToString(ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException(SCANNING_SCALAR, startMark, "expected a comment or a line break, but found " + s + '(' + c + ')', this.reader.getMark(), null, 16, null);
        }
        return commentToken;
    }

    private final BreakIntentHolder scanBlockScalarIndentation() {
        StringBuilder chunks = new StringBuilder();
        int maxIndentOnEmptyLine = 0;
        Mark endMark = this.reader.getMark();
        while (CharConstants.LINEBR.has(this.reader.peek(), " \r")) {
            if (this.reader.peek() != 32) {
                String string = this.scanLineBreak();
                if (string == null) {
                    string = "";
                }
                chunks.append(string);
                endMark = this.reader.getMark();
                continue;
            }
            StreamReader.forward$default(this.reader, 0, 1, null);
            if (this.reader.getColumn() <= maxIndentOnEmptyLine) continue;
            maxIndentOnEmptyLine = this.reader.getColumn();
        }
        int indent = this.reader.getColumn();
        boolean bl = 1 <= indent ? indent < maxIndentOnEmptyLine : false;
        if (bl) {
            throw new ScannerException(SCANNING_SCALAR, endMark, " the leading empty lines contain more spaces (" + maxIndentOnEmptyLine + ") than the first non-empty line (" + indent + ").", this.reader.getMark(), null, 16, null);
        }
        String string = chunks.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return new BreakIntentHolder(string, indent, endMark);
    }

    private final BreakIntentHolder scanBlockScalarBreaks(int indent) {
        int col;
        StringBuilder chunks = new StringBuilder();
        Mark endMark = this.reader.getMark();
        for (col = this.reader.getColumn(); col < indent && this.reader.peek() == 32; ++col) {
            StreamReader.forward$default(this.reader, 0, 1, null);
        }
        while (this.scanLineBreak() != null) {
            String lineBreak;
            chunks.append(lineBreak);
            endMark = this.reader.getMark();
            for (col = this.reader.getColumn(); col < indent && this.reader.peek() == 32; ++col) {
                StreamReader.forward$default(this.reader, 0, 1, null);
            }
        }
        String string = chunks.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return new BreakIntentHolder(string, -1, endMark);
    }

    private final Token scanFlowScalar(ScalarStyle style) {
        StringBuilder stringBuilder;
        boolean doubleValue = style == ScalarStyle.DOUBLE_QUOTED;
        Mark startMark = this.reader.getMark();
        int quote = this.reader.peek();
        StreamReader.forward$default(this.reader, 0, 1, null);
        StringBuilder $this$scanFlowScalar_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        this.scanFlowScalarNonSpaces(doubleValue, startMark, $this$scanFlowScalar_u24lambda_u240);
        while (this.reader.peek() != quote) {
            this.scanFlowScalarSpaces(startMark, $this$scanFlowScalar_u24lambda_u240);
            this.scanFlowScalarNonSpaces(doubleValue, startMark, $this$scanFlowScalar_u24lambda_u240);
        }
        String chunks = stringBuilder.toString();
        StreamReader.forward$default(this.reader, 0, 1, null);
        Mark endMark = this.reader.getMark();
        return new ScalarToken(chunks, false, startMark, endMark, style);
    }

    private final void scanFlowScalarNonSpaces(boolean doubleQuoted, Mark startMark, StringBuilder chunks) {
        block11: {
            int c;
            while (true) {
                int length = 0;
                while (CharConstants.NULL_BL_T_LINEBR.hasNo(this.reader.peek(length), "'\"\\")) {
                    ++length;
                }
                if (length != 0) {
                    chunks.append(this.reader.prefixForward(length));
                }
                c = this.reader.peek();
                if (!doubleQuoted && c == 39 && this.reader.peek(1) == 39) {
                    chunks.append('\'');
                    this.reader.forward(2);
                    continue;
                }
                if (doubleQuoted && c == 39 || !doubleQuoted && StringsKt.contains$default((CharSequence)"\"\\", (char)c, false, 2, null)) {
                    chunks.appendCodePoint(c);
                    StreamReader.forward$default(this.reader, 0, 1, null);
                    continue;
                }
                if (!doubleQuoted || c != 92) break block11;
                StreamReader.forward$default(this.reader, 0, 1, null);
                c = this.reader.peek();
                if (!ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.isSupplementaryCodePoint$snakeyaml_engine_kmp(c) && CharConstants.ESCAPE_REPLACEMENTS.containsKey(Character.valueOf((char)c))) {
                    chunks.append(CharConstants.ESCAPE_REPLACEMENTS.get(Character.valueOf((char)c)));
                    StreamReader.forward$default(this.reader, 0, 1, null);
                    continue;
                }
                if (!ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.isSupplementaryCodePoint$snakeyaml_engine_kmp(c) && CharConstants.ESCAPE_CODES.containsKey(Character.valueOf((char)c))) {
                    Integer n = CharConstants.ESCAPE_CODES.get(Character.valueOf((char)c));
                    Intrinsics.checkNotNull(n);
                    length = ((Number)n).intValue();
                    StreamReader.forward$default(this.reader, 0, 1, null);
                    String hex = this.reader.prefix(length);
                    if (NOT_HEXA.containsMatchIn(hex)) {
                        throw new ScannerException("while scanning a double-quoted scalar", startMark, "expected escape sequence of " + length + " hexadecimal numbers, but found: " + hex, this.reader.getMark(), null, 16, null);
                    }
                    try {
                        int decimal = Integer.parseInt(hex, CharsKt.checkRadix(16));
                        chunks.appendCodePoint(decimal);
                        this.reader.forward(length);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ScannerException("while scanning a double-quoted scalar", startMark, "found unknown escape character " + hex, this.reader.getMark(), null, 16, null);
                    }
                }
                if (c == 9) {
                    chunks.append('\t');
                    StreamReader.forward$default(this.reader, 0, 1, null);
                    continue;
                }
                if (this.scanLineBreak() == null) break;
                chunks.append(this.scanFlowScalarBreaks(startMark));
            }
            String s = StringsKt.concatToString(ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException("while scanning a double-quoted scalar", startMark, "found unknown escape character " + s + '(' + c + ')', this.reader.getMark(), null, 16, null);
        }
    }

    private final void scanFlowScalarSpaces(Mark startMark, StringBuilder chunks) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        int length = 0;
        while (StringsKt.contains$default((CharSequence)" \t", (char)this.reader.peek(length), false, 2, null)) {
            ++length;
        }
        String whitespaces = this.reader.prefixForward(length);
        if (this.reader.peek() == 0) {
            throw new ScannerException("found unexpected end of stream", this.reader.getMark(), "while scanning a quoted scalar", startMark, null, 16, null);
        }
        String lineBreakOpt = this.scanLineBreak();
        StringBuilder $this$scanFlowScalarSpaces_u24lambda_u241 = stringBuilder2 = chunks;
        boolean bl = false;
        if (lineBreakOpt != null) {
            String breaks = this.scanFlowScalarBreaks(startMark);
            if (!Intrinsics.areEqual("\n", lineBreakOpt)) {
                $this$scanFlowScalarSpaces_u24lambda_u241.append(lineBreakOpt);
            } else if (((CharSequence)breaks).length() == 0) {
                $this$scanFlowScalarSpaces_u24lambda_u241.append(' ');
            }
            stringBuilder = $this$scanFlowScalarSpaces_u24lambda_u241.append(breaks);
        } else {
            stringBuilder = $this$scanFlowScalarSpaces_u24lambda_u241.append(whitespaces);
        }
    }

    private final String scanFlowScalarBreaks(Mark startMark) {
        StringBuilder chunks = new StringBuilder();
        while (true) {
            String lineBreakOpt;
            String prefix;
            if ((Intrinsics.areEqual("---", prefix = this.reader.prefix(3)) || Intrinsics.areEqual("...", prefix)) && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(3))) {
                throw new ScannerException("while scanning a quoted scalar", startMark, "found unexpected document separator", this.reader.getMark(), null, 16, null);
            }
            while (StringsKt.contains$default((CharSequence)" \t", (char)this.reader.peek(), false, 2, null)) {
                StreamReader.forward$default(this.reader, 0, 1, null);
            }
            if (this.scanLineBreak() == null) break;
            chunks.append(lineBreakOpt);
        }
        String string = chunks.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private final Token scanPlain() {
        Mark startMark;
        StringBuilder chunks = new StringBuilder();
        Mark endMark = startMark = this.reader.getMark();
        int plainIndent = this.indent + 1;
        String spaces = "";
        do {
            int c = 0;
            int length = 0;
            if (this.reader.peek() == 35) break;
            while (!(CharConstants.NULL_BL_T_LINEBR.has(c = this.reader.peek(length)) || c == 58 && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(length + 1), this.isFlowContext() ? ",[]{}" : "") || this.isFlowContext() && StringsKt.contains$default((CharSequence)",[]{}", (char)c, false, 2, null))) {
                ++length;
            }
            if (length == 0) break;
            this.allowSimpleKey = false;
            chunks.append(spaces);
            chunks.append(this.reader.prefixForward(length));
            endMark = this.reader.getMark();
        } while (!(((CharSequence)(spaces = this.scanPlainSpaces())).length() == 0) && this.reader.peek() != 35 && (!this.isBlockContext() || this.reader.getColumn() >= plainIndent));
        String string = chunks.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return new ScalarToken(string, true, startMark, endMark, null, 16, null);
    }

    private final boolean atEndOfPlain() {
        int c;
        int wsLength = 0;
        int wsColumn = this.reader.getColumn();
        while ((c = this.reader.peek(wsLength)) != 0 && CharConstants.NULL_BL_T_LINEBR.has(c)) {
            if (!(CharConstants.LINEBR.has(c) || c == 13 && this.reader.peek(++wsLength + 1) == 10 || c == 65279)) {
                ++wsColumn;
                continue;
            }
            wsColumn = 0;
        }
        if (this.reader.peek(wsLength) == 35 || this.reader.peek(wsLength + 1) == 0 || this.isBlockContext() && wsColumn < this.indent) {
            return true;
        }
        if (this.isBlockContext()) {
            int c2;
            int extra = 1;
            while ((c2 = this.reader.peek(wsLength + extra)) != 0 && !CharConstants.NULL_BL_T_LINEBR.has(c2)) {
                int nextC;
                if (c2 == 58 && CharConstants.NULL_BL_T_LINEBR.has(nextC = this.reader.peek(wsLength + extra + 1))) {
                    return true;
                }
                ++extra;
            }
        }
        return false;
    }

    private final String scanPlainSpaces() {
        String string;
        StringBuilder breaks;
        String lineBreak;
        block10: {
            int length = 0;
            while (StringsKt.contains$default((CharSequence)" \t", (char)this.reader.peek(length), false, 2, null)) {
                ++length;
            }
            String whitespaces = this.reader.prefixForward(length);
            String string2 = this.scanLineBreak();
            if (string2 == null) {
                return whitespaces;
            }
            lineBreak = string2;
            this.allowSimpleKey = true;
            String prefix = this.reader.prefix(3);
            if (Intrinsics.areEqual("---", prefix) || Intrinsics.areEqual("...", prefix) && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(3))) {
                return "";
            }
            if (this.settings.parseComments && this.atEndOfPlain()) {
                return "";
            }
            breaks = new StringBuilder();
            while (true) {
                if (StringsKt.contains$default((CharSequence)" \t", (char)this.reader.peek(), false, 2, null)) {
                    StreamReader.forward$default(this.reader, 0, 1, null);
                    continue;
                }
                String lbOpt = this.scanLineBreak();
                if (lbOpt == null) break block10;
                breaks.append(lbOpt);
                prefix = this.reader.prefix(3);
                if (Intrinsics.areEqual("---", prefix) || Intrinsics.areEqual("...", prefix) && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(3))) break;
            }
            return "";
        }
        if (!Intrinsics.areEqual("\n", lineBreak)) {
            string = lineBreak + breaks;
        } else if (((CharSequence)breaks).length() == 0) {
            string = " ";
        } else {
            String string3 = breaks.toString();
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        }
        return string;
    }

    private final String scanTagHandle(String name, Mark startMark) {
        int c = this.reader.peek();
        if (c != 33) {
            String s = StringsKt.concatToString(ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException(SCANNING_PREFIX + name, startMark, "expected '!', but found " + s + '(' + c + ')', this.reader.getMark(), null, 16, null);
        }
        int length = 1;
        c = this.reader.peek(length);
        if (c != 32) {
            while (CharConstants.ALPHA.has(c)) {
                c = this.reader.peek(++length);
            }
            if (c != 33) {
                this.reader.forward(length);
                String s = StringsKt.concatToString(ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
                throw new ScannerException(SCANNING_PREFIX + name, startMark, "expected '!', but found " + s + '(' + c + ')', this.reader.getMark(), null, 16, null);
            }
            ++length;
        }
        return this.reader.prefixForward(length);
    }

    private final String scanTagUri(String name, CharConstants range, Mark startMark) {
        StringBuilder chunks = new StringBuilder();
        int length = 0;
        int c = this.reader.peek(length);
        while (range.has(c)) {
            Serializable serializable;
            if (c == 37) {
                chunks.append(this.reader.prefixForward(length));
                length = 0;
                serializable = chunks.append(this.scanUriEscapes(name, startMark));
            } else {
                serializable = Integer.valueOf(length++);
            }
            c = this.reader.peek(length);
        }
        if (length != 0) {
            chunks.append(this.reader.prefixForward(length));
        }
        if (((CharSequence)chunks).length() == 0) {
            String s = StringsKt.concatToString(ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c));
            throw new ScannerException(SCANNING_PREFIX + name, startMark, "expected URI, but found " + s + '(' + c + ')', this.reader.getMark(), null, 16, null);
        }
        String string = chunks.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private final String scanUriEscapes(String name, Mark startMark) {
        int length = 1;
        while (this.reader.peek(length * 3) == 37) {
            ++length;
        }
        Mark beginningMark = this.reader.getMark();
        Buffer buff = new Buffer();
        while (this.reader.peek() == 37) {
            StreamReader.forward$default(this.reader, 0, 1, null);
            try {
                int code = Integer.parseInt(this.reader.prefix(2), CharsKt.checkRadix(16));
                buff.writeByte(code);
            }
            catch (NumberFormatException nfe) {
                int c1 = this.reader.peek();
                String s1 = StringsKt.concatToString(ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c1));
                int c2 = this.reader.peek(1);
                String s2 = StringsKt.concatToString(ru.astrainteractive.astrarating.it.krzeminski.snakeyaml.engine.kmp.internal.utils.Character.INSTANCE.toChars$snakeyaml_engine_kmp(c2));
                throw new ScannerException(SCANNING_PREFIX + name, startMark, "expected URI escape sequence of 2 hexadecimal numbers, but found " + s1 + '(' + c1 + ") and " + s2 + '(' + c2 + ')', this.reader.getMark(), null, 16, null);
            }
            this.reader.forward(2);
        }
        buff.flush();
        try {
            return UriEncoder.decode(buff);
        }
        catch (CharacterCodingException e) {
            throw new ScannerException(SCANNING_PREFIX + name, startMark, "expected URI in UTF-8: " + e.getMessage(), beginningMark, null, 16, null);
        }
    }

    private final String scanLineBreak() {
        int c = this.reader.peek();
        switch (c) {
            case 10: 
            case 13: 
            case 133: {
                if (c == 13 && 10 == this.reader.peek(1)) {
                    this.reader.forward(2);
                } else {
                    StreamReader.forward$default(this.reader, 0, 1, null);
                }
                return "\n";
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Token> makeTokenList(Token ... tokens) {
        List list;
        List notNullTokens = ArraysKt.filterNotNull(tokens);
        if (!this.settings.parseComments) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = notNullTokens;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Token token = (Token)element$iv$iv;
                boolean bl = false;
                if (!(!(token instanceof CommentToken))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = notNullTokens;
        }
        return list;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lru/astrainteractive/astrarating/it/krzeminski/snakeyaml/engine/kmp/scanner/ScannerImpl$Companion;", "", "<init>", "()V", "DIRECTIVE_PREFIX", "", "EXPECTED_ALPHA_ERROR_PREFIX", "SCANNING_SCALAR", "SCANNING_PREFIX", "NOT_HEXA", "Lkotlin/text/Regex;", "snakeyaml-engine-kmp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

