/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.statements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import ru.astrainteractive.astrarating.org.jetbrains.annotations.NotNull;
import ru.astrainteractive.astrarating.org.jetbrains.annotations.Nullable;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.Column;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.ColumnTypeKt;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.EntityIDColumnType;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.ResultRow;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.Table;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.Transaction;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.statements.BatchDataInconsistentException;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.statements.DefaultValueMarker;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.statements.InsertStatement;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010#\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0015\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\u0011H\u0002J*\u0010\u0016\u001a\u00020\u0017\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u00112\u0006\u0010\u001a\u001a\u0002H\u0018H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u0017J\r\u0010\u001d\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u001eJ\r\u0010\u001f\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\b J\u0012\u0010!\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110#H\u0002J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016R\u0014\u0010\b\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR,\u0010\u000e\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00100\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010!\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R<\u0010$\u001a\"\u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120%0\u0002\u0018\u00010\u00028VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u00060"}, d2={"Lru/astrainteractive/astrarating/org/jetbrains/exposed/sql/statements/BaseBatchInsertStatement;", "Lru/astrainteractive/astrarating/org/jetbrains/exposed/sql/statements/InsertStatement;", "", "Lru/astrainteractive/astrarating/org/jetbrains/exposed/sql/ResultRow;", "table", "Lru/astrainteractive/astrarating/org/jetbrains/exposed/sql/Table;", "ignore", "", "shouldReturnGeneratedValues", "<init>", "(Lru/astrainteractive/astrarating/org/jetbrains/exposed/sql/Table;ZZ)V", "getShouldReturnGeneratedValues", "()Z", "isAlwaysBatch", "data", "Ljava/util/ArrayList;", "", "Lru/astrainteractive/astrarating/org/jetbrains/exposed/sql/Column;", "", "getData$exposed_core", "()Ljava/util/ArrayList;", "isDefaultable", "set", "", "S", "column", "value", "(Lru/astrainteractive/astrarating/org/jetbrains/exposed/sql/Column;Ljava/lang/Object;)V", "addBatch", "removeLastBatch", "removeLastBatch$exposed_core", "validateLastBatch", "validateLastBatch$exposed_core", "allColumnsInDataSet", "", "", "arguments", "Lkotlin/Pair;", "getArguments", "()Ljava/util/List;", "setArguments", "(Ljava/util/List;)V", "prepared", "Lru/astrainteractive/astrarating/org/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "transaction", "Lru/astrainteractive/astrarating/org/jetbrains/exposed/sql/Transaction;", "sql", "", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nBaseBatchInsertStatement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseBatchInsertStatement.kt\norg/jetbrains/exposed/sql/statements/BaseBatchInsertStatement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1454#2,5:116\n827#2:121\n855#2,2:122\n1368#2:124\n1454#2,5:125\n774#2:130\n865#2,2:131\n1557#2:133\n1628#2,3:134\n1557#2:137\n1628#2,2:138\n1557#2:140\n1628#2,3:141\n1630#2:144\n1#3:145\n*S KotlinDebug\n*F\n+ 1 BaseBatchInsertStatement.kt\norg/jetbrains/exposed/sql/statements/BaseBatchInsertStatement\n*L\n53#1:116,5\n62#1:121\n62#1:122,2\n69#1:124\n69#1:125,5\n69#1:130\n69#1:131,2\n89#1:133\n89#1:134,3\n90#1:137\n90#1:138,2\n91#1:140\n91#1:141,3\n90#1:144\n*E\n"})
public abstract class BaseBatchInsertStatement
extends InsertStatement<List<? extends ResultRow>> {
    private final boolean shouldReturnGeneratedValues;
    private final boolean isAlwaysBatch;
    @NotNull
    private final ArrayList<Map<Column<?>, Object>> data;
    @NotNull
    private final Set<Column<?>> allColumnsInDataSet;
    @Nullable
    private List<? extends List<? extends Pair<? extends Column<?>, ? extends Object>>> arguments;

    public BaseBatchInsertStatement(@NotNull Table table, boolean ignore, boolean shouldReturnGeneratedValues) {
        Intrinsics.checkNotNullParameter(table, "table");
        super(table, ignore);
        this.shouldReturnGeneratedValues = shouldReturnGeneratedValues;
        this.isAlwaysBatch = true;
        this.data = new ArrayList();
        this.allColumnsInDataSet = new LinkedHashSet();
    }

    public /* synthetic */ BaseBatchInsertStatement(Table table, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl2 = true;
        }
        this(table, bl, bl2);
    }

    protected final boolean getShouldReturnGeneratedValues() {
        return this.shouldReturnGeneratedValues;
    }

    @Override
    public boolean isAlwaysBatch() {
        return this.isAlwaysBatch;
    }

    @NotNull
    public final ArrayList<Map<Column<?>, Object>> getData$exposed_core() {
        return this.data;
    }

    private final boolean isDefaultable(Column<?> $this$isDefaultable) {
        return $this$isDefaultable.getColumnType().getNullable() || $this$isDefaultable.getDefaultValueFun() != null || $this$isDefaultable.isDatabaseGenerated$exposed_core();
    }

    @Override
    public <S> void set(@NotNull Column<S> column, S value) {
        Intrinsics.checkNotNullParameter(column, "column");
        if (this.data.size() > 1) {
            Map<Column<?>, Object> map2 = this.data.get(this.data.size() - 2);
            Intrinsics.checkNotNullExpressionValue(map2, "get(...)");
            if (!map2.containsKey(column) && !this.isDefaultable(column)) {
                String fullIdentity = TransactionManager.Companion.current().fullIdentity(column);
                throw new BatchDataInconsistentException("Can't set " + value + " for " + fullIdentity + " because previous insertion can't be defaulted for that column.");
            }
        }
        super.set(column, value);
    }

    public final void addBatch() {
        if (!((Collection)this.data).isEmpty()) {
            this.validateLastBatch$exposed_core();
            this.data.set(this.data.size() - 1, new LinkedHashMap(this.getValues()));
            this.allColumnsInDataSet.addAll((Collection)this.getValues().keySet());
            this.getValues().clear();
            this.setHasBatchedValues(true);
        }
        this.data.add(this.getValues());
        this.setArguments(null);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeLastBatch$exposed_core() {
        void $this$flatMapTo$iv;
        this.data.remove(this.data.size() - 1);
        this.allColumnsInDataSet.clear();
        Iterable iterable = this.data;
        Collection destination$iv = this.allColumnsInDataSet;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Map it = (Map)element$iv;
            boolean bl = false;
            Iterable list$iv = it.keySet();
            CollectionsKt.addAll(destination$iv, list$iv);
        }
        this.getValues().clear();
        this.getValues().putAll((Map)CollectionsKt.last((List)this.data));
        this.setArguments(null);
        this.setHasBatchedValues(this.data.size() > 0);
    }

    /*
     * WARNING - void declaration
     */
    public void validateLastBatch$exposed_core() {
        void $this$filterTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        void $this$filterNotTo$iv$iv;
        Transaction tr = TransactionManager.Companion.current();
        Iterable $this$filterNot$iv = SetsKt.minus(this.allColumnsInDataSet, (Iterable)this.getValues().keySet());
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Column it = (Column)element$iv$iv;
            boolean bl = false;
            if (this.isDefaultable(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List cantBeDefaulted = (List)destination$iv$iv;
        if (!((Collection)cantBeDefaulted).isEmpty()) {
            String columnList = CollectionsKt.joinToString$default(cantBeDefaulted, null, null, null, 0, null, arg_0 -> BaseBatchInsertStatement.validateLastBatch$lambda$2(tr, arg_0), 31, null);
            throw new BatchDataInconsistentException("Can't add a new batch because columns: " + columnList + " don't have client default values. DB defaults are not supported in batch inserts");
        }
        Iterable $this$flatMap$iv = this.getTargets();
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Table it = (Table)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getColumns();
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        Iterable $this$filter$iv = CollectionsKt.minus((Iterable)((List)destination$iv$iv2), (Iterable)this.getValues().keySet());
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Column it = (Column)element$iv$iv;
            boolean bl = false;
            if (!(!this.isDefaultable(it) && !ColumnTypeKt.isAutoInc(it.getColumnType()) && it.getDbDefaultValue$exposed_core() == null && !(it.getColumnType() instanceof EntityIDColumnType))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List requiredInTargets = (List)destination$iv$iv2;
        if (CollectionsKt.any(requiredInTargets)) {
            String columnList = CollectionsKt.joinToString$default(requiredInTargets, null, null, null, 0, null, arg_0 -> BaseBatchInsertStatement.validateLastBatch$lambda$5(tr, arg_0), 31, null);
            throw new BatchDataInconsistentException("Can't add a new batch because columns: " + columnList + " don't have default values. DB defaults are not supported in batch inserts");
        }
    }

    private final Set<Column<?>> allColumnsInDataSet() {
        Object object = (Map)CollectionsKt.lastOrNull((List)this.data);
        if (object == null || (object = object.keySet()) == null) {
            throw new BatchDataInconsistentException("No data provided for inserting into " + this.getTable().getTableName());
        }
        return SetsKt.plus(this.allColumnsInDataSet, (Iterable)object);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<List<Pair<Column<?>, Object>>> getArguments() {
        Iterable<List<Pair<Column<Object>, Object>>> iterable = this.arguments;
        if (iterable == null) {
            Map it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            BaseBatchInsertStatement $this$_get_arguments__u24lambda_u2411 = this;
            boolean bl = false;
            Set columnsToInsert = CollectionsKt.toSet((Iterable)SetsKt.plus($this$_get_arguments__u24lambda_u2411.allColumnsInDataSet(), (Iterable)$this$_get_arguments__u24lambda_u2411.clientDefaultColumns()));
            Iterable iterable2 = $this$_get_arguments__u24lambda_u2411.data;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Map map2 = (Map)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                Map<Column<?>, Object> map3 = $this$_get_arguments__u24lambda_u2411.valuesAndClientDefaults(it);
                Intrinsics.checkNotNull(map3, "null cannot be cast to non-null type kotlin.collections.MutableMap<org.jetbrains.exposed.sql.Column<*>, kotlin.Any?>");
                collection.add(TypeIntrinsics.asMutableMap(map3));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                it = (Map)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                Iterable $this$map$iv2 = columnsToInsert;
                boolean $i$f$map2 = false;
                Iterable iterable3 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    Object object;
                    void values2;
                    void column;
                    Column column2 = (Column)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl4 = false;
                    void v2 = column;
                    if (values2.containsKey(column)) {
                        object = values2.get(column);
                    } else if (column.getDbDefaultValue$exposed_core() != null || column.isDatabaseGenerated$exposed_core()) {
                        object = DefaultValueMarker.INSTANCE;
                    } else {
                        if (!column.getColumnType().getNullable()) {
                            void var24_26 = v2;
                            boolean bl5 = false;
                            void v4 = var24_26;
                            String string = "The value for the column " + column.getName() + " was not provided. The value for non-nullable column without defaults must be specified.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        object = null;
                    }
                    collection2.add(TuplesKt.to(v2, object));
                }
                collection.add((List)destination$iv$iv2);
            }
            Iterable $this$_get_arguments__u24lambda_u2411_u24lambda_u2410 = iterable2 = (List)destination$iv$iv;
            boolean bl6 = false;
            this.arguments = $this$_get_arguments__u24lambda_u2411_u24lambda_u2410;
            iterable = iterable2;
        }
        return iterable;
    }

    @Override
    public void setArguments(@Nullable List<? extends List<? extends Pair<? extends Column<?>, ? extends Object>>> list) {
        this.arguments = list;
    }

    @Override
    @NotNull
    public PreparedStatementApi prepared(@NotNull Transaction transaction, @NotNull String sql) {
        Intrinsics.checkNotNullParameter(transaction, "transaction");
        Intrinsics.checkNotNullParameter(sql, "sql");
        return !this.shouldReturnGeneratedValues ? transaction.getConnection().prepareStatement(sql, false) : super.prepared(transaction, sql);
    }

    private static final CharSequence validateLastBatch$lambda$2(Transaction $tr, Column it) {
        Intrinsics.checkNotNullParameter($tr, "$tr");
        Intrinsics.checkNotNullParameter(it, "it");
        return $tr.fullIdentity(it);
    }

    private static final CharSequence validateLastBatch$lambda$5(Transaction $tr, Column it) {
        Intrinsics.checkNotNullParameter($tr, "$tr");
        Intrinsics.checkNotNullParameter(it, "it");
        return $tr.fullIdentity(it);
    }
}

