/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.vendors;

import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ru.astrainteractive.astrarating.org.jetbrains.annotations.NotNull;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.exceptions.UnsupportedByDialectException;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.Expression;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.ExpressionKt;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.Function;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.IColumnType;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.IExpressionAlias;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.LiteralOp;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.QueryBuilder;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.SortOrder;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.vendors.MysqlDialect;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.vendors.SQLServerDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u0005H&J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\b\u0010\u001b\u001a\u00020\u0005H\u0016J\b\u0010\u001c\u001a\u00020\u0005H\u0016J\u0010\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0005H\u0016J\b\u0010!\u001a\u00020\u0005H\u0016J\b\u0010\"\u001a\u00020\u0005H\u0016J\b\u0010#\u001a\u00020\u0005H\u0016J\b\u0010$\u001a\u00020\u0005H\u0016J\b\u0010%\u001a\u00020\u0005H\u0016J\u0010\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\b\u0010*\u001a\u00020\u0005H\u0016J\b\u0010+\u001a\u00020\u0005H\u0016J\u0014\u0010,\u001a\u00020\u00052\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.H\u0016J$\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\n\u00103\u001a\u0006\u0012\u0002\b\u00030.2\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u00020\u0005H&\u00a8\u00068"}, d2={"Lru/astrainteractive/astrarating/org/jetbrains/exposed/sql/vendors/DataTypeProvider;", "", "<init>", "()V", "byteType", "", "ubyteType", "shortType", "ushortType", "integerType", "uintegerType", "integerAutoincType", "uintegerAutoincType", "longType", "ulongType", "longAutoincType", "ulongAutoincType", "floatType", "doubleType", "varcharType", "colLength", "", "textType", "mediumTextType", "largeTextType", "binaryType", "length", "blobType", "uuidType", "uuidToDB", "value", "Ljava/util/UUID;", "dateTimeType", "timestampType", "timestampWithTimeZoneType", "timeType", "dateType", "booleanType", "booleanToStatementString", "bool", "", "booleanFromStringToBoolean", "jsonType", "jsonBType", "processForDefaultValue", "e", "Lru/astrainteractive/astrarating/org/jetbrains/exposed/sql/Expression;", "precessOrderByClause", "", "queryBuilder", "Lru/astrainteractive/astrarating/org/jetbrains/exposed/sql/QueryBuilder;", "expression", "sortOrder", "Lru/astrainteractive/astrarating/org/jetbrains/exposed/sql/SortOrder;", "hexToDb", "hexString", "exposed-core"})
public abstract class DataTypeProvider {
    @NotNull
    public String byteType() {
        return "TINYINT";
    }

    @NotNull
    public String ubyteType() {
        return "SMALLINT";
    }

    @NotNull
    public String shortType() {
        return "SMALLINT";
    }

    @NotNull
    public String ushortType() {
        return "INT";
    }

    @NotNull
    public String integerType() {
        return "INT";
    }

    @NotNull
    public String uintegerType() {
        return "BIGINT";
    }

    @NotNull
    public String integerAutoincType() {
        return "INT AUTO_INCREMENT";
    }

    @NotNull
    public String uintegerAutoincType() {
        return "BIGINT AUTO_INCREMENT";
    }

    @NotNull
    public String longType() {
        return "BIGINT";
    }

    @NotNull
    public String ulongType() {
        return "NUMERIC(20)";
    }

    @NotNull
    public String longAutoincType() {
        return "BIGINT AUTO_INCREMENT";
    }

    @NotNull
    public String ulongAutoincType() {
        return "NUMERIC(20) AUTO_INCREMENT";
    }

    @NotNull
    public String floatType() {
        return "FLOAT";
    }

    @NotNull
    public String doubleType() {
        return "DOUBLE PRECISION";
    }

    @NotNull
    public String varcharType(int colLength) {
        return "VARCHAR(" + colLength + ')';
    }

    @NotNull
    public String textType() {
        return "TEXT";
    }

    @NotNull
    public String mediumTextType() {
        return "TEXT";
    }

    @NotNull
    public String largeTextType() {
        return "TEXT";
    }

    @NotNull
    public abstract String binaryType();

    @NotNull
    public String binaryType(int length) {
        return length == Integer.MAX_VALUE ? "VARBINARY(MAX)" : "VARBINARY(" + length + ')';
    }

    @NotNull
    public String blobType() {
        return "BLOB";
    }

    @NotNull
    public String uuidType() {
        return "BINARY(16)";
    }

    @NotNull
    public Object uuidToDB(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter(value, "value");
        byte[] byArray = ByteBuffer.allocate(16).putLong(value.getMostSignificantBits()).putLong(value.getLeastSignificantBits()).array();
        Intrinsics.checkNotNullExpressionValue(byArray, "array(...)");
        return byArray;
    }

    @NotNull
    public String dateTimeType() {
        return "DATETIME";
    }

    @NotNull
    public String timestampType() {
        return this.dateTimeType();
    }

    @NotNull
    public String timestampWithTimeZoneType() {
        return "TIMESTAMP WITH TIME ZONE";
    }

    @NotNull
    public String timeType() {
        return "TIME";
    }

    @NotNull
    public String dateType() {
        return "DATE";
    }

    @NotNull
    public String booleanType() {
        return "BOOLEAN";
    }

    @NotNull
    public String booleanToStatementString(boolean bool) {
        String string = String.valueOf(bool).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
        return string;
    }

    public boolean booleanFromStringToBoolean(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return Boolean.parseBoolean(value);
    }

    @NotNull
    public String jsonType() {
        return "JSON";
    }

    @NotNull
    public String jsonBType() {
        throw new UnsupportedByDialectException("This vendor does not support binary JSON data type", DatabaseDialectKt.getCurrentDialect());
    }

    @NotNull
    public String processForDefaultValue(@NotNull Expression<?> e) {
        String string;
        Intrinsics.checkNotNullParameter(e, "e");
        if (e instanceof LiteralOp) {
            IColumnType iColumnType = ((LiteralOp)e).getColumnType();
            Intrinsics.checkNotNull(iColumnType, "null cannot be cast to non-null type org.jetbrains.exposed.sql.IColumnType<kotlin.Any?>");
            string = iColumnType.valueAsDefaultString(((LiteralOp)e).getValue());
        } else {
            string = e instanceof Function ? String.valueOf(e) : (DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect ? String.valueOf(e) : (DatabaseDialectKt.getCurrentDialect() instanceof SQLServerDialect ? String.valueOf(e) : "" + '(' + e + ')'));
        }
        return string;
    }

    public void precessOrderByClause(@NotNull QueryBuilder queryBuilder, @NotNull Expression<?> expression, @NotNull SortOrder sortOrder) {
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter((Object)sortOrder, "sortOrder");
        Object[] objectArray = new Object[3];
        Object object = expression instanceof IExpressionAlias ? (IExpressionAlias)((Object)expression) : null;
        if (object == null || (object = object.getAlias()) == null) {
            object = expression;
        }
        objectArray[0] = object;
        objectArray[1] = " ";
        objectArray[2] = sortOrder.getCode();
        ExpressionKt.append(queryBuilder, objectArray);
    }

    @NotNull
    public abstract String hexToDb(@NotNull String var1);
}

