/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.vendors;

import java.util.Locale;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import ru.astrainteractive.astrarating.org.jetbrains.annotations.NotNull;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.Column;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.Expression;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.Index;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.SQLLogKt;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.statements.api.ExposedDatabaseMetadata;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.transactions.TransactionManager;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.vendors.SQLiteDataTypeProvider;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.vendors.SQLiteFunctionProvider;
import ru.astrainteractive.astrarating.org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u0014\u0010\u000f\u001a\u00020\u00052\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J(\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013H\u0016J\b\u0010\u001d\u001a\u00020\u0013H\u0016J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006 "}, d2={"Lru/astrainteractive/astrarating/org/jetbrains/exposed/sql/vendors/SQLiteDialect;", "Lru/astrainteractive/astrarating/org/jetbrains/exposed/sql/vendors/VendorDialect;", "<init>", "()V", "supportsCreateSequence", "", "getSupportsCreateSequence", "()Z", "supportsMultipleGeneratedKeys", "getSupportsMultipleGeneratedKeys", "supportsCreateSchema", "getSupportsCreateSchema", "supportsWindowFrameGroupsMode", "getSupportsWindowFrameGroupsMode", "supportsLimitWithUpdateOrDelete", "isAllowedAsColumnDefault", "e", "Lru/astrainteractive/astrarating/org/jetbrains/exposed/sql/Expression;", "createIndex", "", "index", "Lru/astrainteractive/astrarating/org/jetbrains/exposed/sql/Index;", "dropIndex", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "createDatabase", "name", "listDatabases", "dropDatabase", "Companion", "exposed-core"})
public class SQLiteDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean supportsCreateSequence;
    private final boolean supportsMultipleGeneratedKeys;
    private final boolean supportsCreateSchema;
    private final boolean supportsWindowFrameGroupsMode;
    @NotNull
    private static final Lazy<Boolean> ENABLE_UPDATE_DELETE_LIMIT$delegate = LazyKt.lazy(SQLiteDialect::ENABLE_UPDATE_DELETE_LIMIT_delegate$lambda$3);

    public SQLiteDialect() {
        super(Companion.getDialectName(), SQLiteDataTypeProvider.INSTANCE, SQLiteFunctionProvider.INSTANCE);
        this.supportsWindowFrameGroupsMode = true;
    }

    @Override
    public boolean getSupportsCreateSequence() {
        return this.supportsCreateSequence;
    }

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        return this.supportsMultipleGeneratedKeys;
    }

    @Override
    public boolean getSupportsCreateSchema() {
        return this.supportsCreateSchema;
    }

    @Override
    public boolean getSupportsWindowFrameGroupsMode() {
        return this.supportsWindowFrameGroupsMode;
    }

    @Override
    public boolean supportsLimitWithUpdateOrDelete() {
        return TransactionManager.Companion.current().getDb().metadata$exposed_core(SQLiteDialect::supportsLimitWithUpdateOrDelete$lambda$0);
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, "e");
        return true;
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        Intrinsics.checkNotNullParameter(index, "index");
        if (index.getIndexType() != null) {
            SQLLogKt.getExposedLogger().warn("Index of type " + index.getIndexType() + " on " + index.getTable().getTableName() + " for " + CollectionsKt.joinToString$default(index.getColumns(), null, null, null, 0, null, SQLiteDialect::createIndex$lambda$1, 31, null) + " can't be created in SQLite");
            return "";
        }
        String originalCreateIndex = super.createIndex(Index.copy$default(index, null, false, null, null, null, null, null, 125, null));
        return index.getUnique() ? StringsKt.replace$default(originalCreateIndex, "CREATE INDEX", "CREATE UNIQUE INDEX", false, 4, null) : originalCreateIndex;
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName, boolean isUnique, boolean isPartialOrFunctional) {
        Intrinsics.checkNotNullParameter(tableName, "tableName");
        Intrinsics.checkNotNullParameter(indexName, "indexName");
        return "DROP INDEX IF EXISTS " + this.getIdentifierManager().quoteIfNecessary(indexName);
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        StringBuilder stringBuilder = new StringBuilder().append("ATTACH DATABASE '");
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        return stringBuilder.append(string).append(".db' AS ").append(DatabaseDialectKt.inProperCase(name)).toString();
    }

    @Override
    @NotNull
    public String listDatabases() {
        return "SELECT name FROM pragma_database_list";
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return "DETACH DATABASE " + DatabaseDialectKt.inProperCase(name);
    }

    private static final boolean supportsLimitWithUpdateOrDelete$lambda$0(ExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter($this$metadata, "$this$metadata");
        return $this$metadata.supportsLimitWithUpdateOrDelete();
    }

    private static final CharSequence createIndex$lambda$1(Column it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getName();
    }

    private static final boolean ENABLE_UPDATE_DELETE_LIMIT_delegate$lambda$3$lambda$2(ExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter($this$metadata, "$this$metadata");
        return $this$metadata.supportsLimitWithUpdateOrDelete();
    }

    private static final boolean ENABLE_UPDATE_DELETE_LIMIT_delegate$lambda$3() {
        return TransactionManager.Companion.current().getDb().metadata$exposed_core(SQLiteDialect::ENABLE_UPDATE_DELETE_LIMIT_delegate$lambda$3$lambda$2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u00020\u00058FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lru/astrainteractive/astrarating/org/jetbrains/exposed/sql/vendors/SQLiteDialect$Companion;", "Lru/astrainteractive/astrarating/org/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "<init>", "()V", "ENABLE_UPDATE_DELETE_LIMIT", "", "getENABLE_UPDATE_DELETE_LIMIT$annotations", "getENABLE_UPDATE_DELETE_LIMIT", "()Z", "ENABLE_UPDATE_DELETE_LIMIT$delegate", "Lkotlin/Lazy;", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("SQLite");
        }

        public final boolean getENABLE_UPDATE_DELETE_LIMIT() {
            Lazy lazy = ENABLE_UPDATE_DELETE_LIMIT$delegate;
            return (Boolean)lazy.getValue();
        }

        @Deprecated(message="This property will be removed in future releases.", replaceWith=@ReplaceWith(expression="currentDialect.supportsLimitWithUpdateOrDelete()", imports={}), level=DeprecationLevel.WARNING)
        public static /* synthetic */ void getENABLE_UPDATE_DELETE_LIMIT$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

